/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.neo4j.internal.kernel.api.CursorFactory;
import org.neo4j.internal.kernel.api.KernelAPIWriteTestBase;
import org.neo4j.internal.kernel.api.KernelAPIWriteTestSupport;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.PropertyCursor;
import org.neo4j.internal.kernel.api.Read;
import org.neo4j.internal.kernel.api.RelationshipTraversalCursor;
import org.neo4j.internal.kernel.api.Transaction;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

public abstract class TwoLayerTxStateTestBase<G extends KernelAPIWriteTestSupport>
extends KernelAPIWriteTestBase<G> {
    @Rule
    public ExpectedException exception = ExpectedException.none();

    @Test
    public void shouldNotSeeCreatedNodeInStableState() throws Exception {
        Assume.assumeTrue((boolean)this.modes.twoLayerTransactionState());
        try (Transaction tx = this.session.beginTransaction();){
            long node = tx.dataWrite().nodeCreate();
            try (NodeCursor cursor = tx.cursors().allocateNodeCursor();){
                tx.stableDataRead().singleNode(node, cursor);
                Assert.assertFalse((String)"not in stable tx state", (boolean)cursor.next());
                tx.dataRead().singleNode(node, cursor);
                Assert.assertTrue((String)"in active tx state", (boolean)cursor.next());
                Assert.assertEquals((long)node, (long)cursor.nodeReference());
                Assert.assertFalse((String)"only single node in active tx state", (boolean)cursor.next());
            }
        }
    }

    @Test
    public void shouldSeeStabilizedCreatedNodeInStableState() throws Exception {
        Assume.assumeTrue((boolean)this.modes.twoLayerTransactionState());
        try (Transaction tx = this.session.beginTransaction();){
            long node = tx.dataWrite().nodeCreate();
            tx.markAsStable();
            try (NodeCursor cursor = tx.cursors().allocateNodeCursor();){
                tx.dataRead().singleNode(node, cursor);
                Assert.assertTrue((String)"in active tx state", (boolean)cursor.next());
                tx.stableDataRead().singleNode(node, cursor);
                Assert.assertTrue((String)"in stable tx state", (boolean)cursor.next());
                Assert.assertEquals((long)node, (long)cursor.nodeReference());
                Assert.assertFalse((String)"only single node in stable tx state", (boolean)cursor.next());
            }
        }
    }

    @Test
    public void shouldNotSeeRemovedNodeInActiveState() throws Exception {
        long n1;
        Assume.assumeTrue((boolean)this.modes.twoLayerTransactionState());
        try (Transaction tx = this.session.beginTransaction();){
            n1 = tx.dataWrite().nodeCreate();
            tx.success();
        }
        tx = this.session.beginTransaction();
        var4_2 = null;
        try {
            long n2 = tx.dataWrite().nodeCreate();
            long n3 = tx.dataWrite().nodeCreate();
            tx.markAsStable();
            tx.dataWrite().nodeDelete(n2);
            this.assertAllNodes(tx.cursors(), tx.stableDataRead(), n1, n2, n3);
            this.assertAllNodes(tx.cursors(), tx.dataRead(), n1, n3);
        }
        catch (Throwable throwable) {
            var4_2 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var4_2 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var4_2.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    @Test
    public void shouldSeparateRelationshipWritesIntoLayers() throws Exception {
        long r2;
        long r1;
        long n2;
        long n1;
        Assume.assumeTrue((boolean)this.modes.twoLayerTransactionState());
        boolean TYPE = false;
        try (Transaction tx = this.session.beginTransaction();){
            n1 = tx.dataWrite().nodeCreate();
            n2 = tx.dataWrite().nodeCreate();
            r1 = tx.dataWrite().relationshipCreate(n1, 0, n2);
            r2 = tx.dataWrite().relationshipCreate(n1, 0, n2);
            tx.success();
        }
        tx = this.session.beginTransaction();
        var11_3 = null;
        try {
            long r3 = tx.dataWrite().relationshipCreate(n1, 0, n2);
            long r4 = tx.dataWrite().relationshipCreate(n1, 0, n2);
            tx.dataWrite().relationshipDelete(r2);
            tx.markAsStable();
            long r5 = tx.dataWrite().relationshipCreate(n1, 0, n2);
            tx.dataWrite().relationshipDelete(r4);
            this.assertExpandNode(tx.cursors(), tx.stableDataRead(), n1, r1, r3, r4);
            this.assertExpandNode(tx.cursors(), tx.dataRead(), n1, r1, r3, r5);
        }
        catch (Throwable throwable) {
            var11_3 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var11_3 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var11_3.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    @Test
    public void shouldSeparatePropertyWritesIntoLayers() throws Exception {
        long n1;
        Assume.assumeTrue((boolean)this.modes.twoLayerTransactionState());
        boolean prop1 = false;
        boolean prop2 = true;
        int prop3 = 2;
        int prop4 = 2;
        int prop5 = 2;
        int prop6 = 2;
        try (Transaction tx = this.session.beginTransaction();){
            n1 = tx.dataWrite().nodeCreate();
            tx.dataWrite().nodeSetProperty(n1, 0, (Value)Values.intValue((int)1));
            tx.dataWrite().nodeSetProperty(n1, 1, (Value)Values.stringValue((String)"yo1"));
            tx.dataWrite().nodeSetProperty(n1, 2, (Value)Values.booleanValue((boolean)true));
            tx.success();
        }
        tx = this.session.beginTransaction();
        var10_8 = null;
        try {
            tx.dataWrite().nodeSetProperty(n1, 1, (Value)Values.stringValue((String)"yo2"));
            tx.dataWrite().nodeSetProperty(n1, 2, (Value)Values.intValue((int)2));
            tx.dataWrite().nodeSetProperty(n1, 2, (Value)Values.stringValue((String)"onlyInStable"));
            tx.dataWrite().nodeRemoveProperty(n1, 2);
            tx.markAsStable();
            tx.dataWrite().nodeSetProperty(n1, 1, (Value)Values.stringValue((String)"yo3"));
            tx.dataWrite().nodeRemoveProperty(n1, 2);
            tx.dataWrite().nodeSetProperty(n1, 2, (Value)Values.intValue((int)3));
            this.assertNode(tx.cursors(), tx.stableDataRead(), n1).hasProperty(0, (Value)Values.intValue((int)1)).hasProperty(1, (Value)Values.stringValue((String)"yo2")).hasProperty(2, (Value)Values.intValue((int)2)).hasProperty(2, (Value)Values.stringValue((String)"onlyInStable")).andNothingElse();
            this.assertNode(tx.cursors(), tx.dataRead(), n1).hasProperty(0, (Value)Values.intValue((int)1)).hasProperty(1, (Value)Values.stringValue((String)"yo3")).hasProperty(2, (Value)Values.intValue((int)2)).hasProperty(2, (Value)Values.intValue((int)3)).andNothingElse();
        }
        catch (Throwable throwable) {
            var10_8 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var10_8 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var10_8.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    private void assertAllNodes(CursorFactory cursors, Read read, long ... nodes) {
        Set expectedSet = Arrays.stream(nodes).boxed().collect(Collectors.toSet());
        try (NodeCursor node = cursors.allocateNodeCursor();){
            int count = 0;
            read.allNodesScan(node);
            while (node.next()) {
                Assert.assertTrue((boolean)expectedSet.contains(node.nodeReference()));
                ++count;
            }
            Assert.assertEquals((long)expectedSet.size(), (long)count);
        }
    }

    private void assertExpandNode(CursorFactory cursors, Read read, long nodeId, long ... relationshipIds) {
        Set expectedSet = Arrays.stream(relationshipIds).boxed().collect(Collectors.toSet());
        try (NodeCursor node = cursors.allocateNodeCursor();
             RelationshipTraversalCursor relationship = cursors.allocateRelationshipTraversalCursor();){
            int count = 0;
            read.singleNode(nodeId, node);
            Assert.assertTrue((boolean)node.next());
            node.allRelationships(relationship);
            while (relationship.next()) {
                Assert.assertTrue((boolean)expectedSet.contains(relationship.relationshipReference()));
                ++count;
            }
            Assert.assertEquals((long)expectedSet.size(), (long)count);
        }
    }

    private NodeProperties assertNode(CursorFactory cursors, Read read, long nodeId) {
        HashMap<Integer, Value> properties = new HashMap<Integer, Value>();
        try (NodeCursor node = cursors.allocateNodeCursor();
             PropertyCursor property = cursors.allocatePropertyCursor();){
            read.singleNode(nodeId, node);
            Assert.assertTrue((boolean)node.next());
            node.properties(property);
            while (property.next()) {
                properties.put(property.propertyKey(), property.propertyValue());
            }
        }
        return new NodeProperties(properties);
    }

    static class NodeProperties {
        final Map<Integer, Value> properties;

        NodeProperties(Map<Integer, Value> properties) {
            this.properties = properties;
        }

        NodeProperties hasProperty(Integer key, Value value) {
            Assert.assertTrue((boolean)this.properties.containsKey(key));
            Assert.assertEquals((Object)this.properties.get(key), (Object)value);
            this.properties.remove(key);
            return this;
        }

        void andNothingElse() {
            Assert.assertTrue((boolean)this.properties.isEmpty());
        }
    }
}

