/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api.helpers;

import org.junit.Assert;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.internal.kernel.api.helpers.RelationshipSelectionCursor;

class RelationshipSelectionTestBase {
    final int typeA = 100;
    final int typeB = 101;
    final int typeC = 102;

    RelationshipSelectionTestBase() {
    }

    void assertOutgoing(ResourceIterator<R> iterator, int targetNode, int type) {
        Assert.assertTrue((String)"has next", (boolean)iterator.hasNext());
        R r = (R)iterator.next();
        Assert.assertEquals((String)"expected type", (long)type, (long)r.type);
        Assert.assertEquals((String)"expected target", (long)targetNode, (long)r.targetNode);
    }

    void assertIncoming(ResourceIterator<R> iterator, int sourceNode, int type) {
        Assert.assertTrue((String)"has next", (boolean)iterator.hasNext());
        R r = (R)iterator.next();
        Assert.assertEquals((String)"expected type", (long)type, (long)r.type);
        Assert.assertEquals((String)"expected source", (long)sourceNode, (long)r.sourceNode);
    }

    void assertLoop(ResourceIterator<R> iterator, int type) {
        Assert.assertTrue((String)"has next", (boolean)iterator.hasNext());
        R r = (R)iterator.next();
        Assert.assertEquals((String)"expected type", (long)type, (long)r.type);
        Assert.assertEquals((String)"expected loop", (long)r.sourceNode, (long)r.targetNode);
    }

    void assertEmpty(ResourceIterator<R> iterator) {
        Assert.assertFalse((String)"no more", (boolean)iterator.hasNext());
    }

    void assertOutgoing(RelationshipSelectionCursor cursor, int targetNode, int type) {
        Assert.assertTrue((String)"has next", (boolean)cursor.next());
        Assert.assertEquals((String)"expected type", (long)type, (long)cursor.type());
        Assert.assertEquals((String)"expected target", (long)targetNode, (long)cursor.targetNodeReference());
    }

    void assertIncoming(RelationshipSelectionCursor cursor, int sourceNode, int type) {
        Assert.assertTrue((String)"has next", (boolean)cursor.next());
        Assert.assertEquals((String)"expected type", (long)type, (long)cursor.type());
        Assert.assertEquals((String)"expected source", (long)sourceNode, (long)cursor.sourceNodeReference());
    }

    void assertLoop(RelationshipSelectionCursor cursor, int type) {
        Assert.assertTrue((String)"has next", (boolean)cursor.next());
        Assert.assertEquals((String)"expected type", (long)type, (long)cursor.type());
        Assert.assertEquals((String)"expected loop", (long)cursor.sourceNodeReference(), (long)cursor.targetNodeReference());
    }

    void assertEmpty(RelationshipSelectionCursor cursor) {
        Assert.assertFalse((String)"no more", (boolean)cursor.next());
    }

    int[] types(int ... types) {
        return types;
    }

    static class R {
        final long relationship;
        final long sourceNode;
        final int type;
        final long targetNode;

        R(long relationship, long sourceNode, int type, long targetNode) {
            this.relationship = relationship;
            this.sourceNode = sourceNode;
            this.type = type;
            this.targetNode = targetNode;
        }
    }
}

