/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.index;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.neo4j.internal.kernel.api.IndexQuery;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexOrder;
import org.neo4j.kernel.api.index.IndexProgressor;
import org.neo4j.values.storable.Value;

public class BridgingIndexProgressor
implements IndexProgressor.EntityValueClient,
IndexProgressor {
    private final IndexProgressor.EntityValueClient client;
    private final int[] keys;
    private final Queue<IndexProgressor> progressors = new ConcurrentLinkedQueue<IndexProgressor>();
    private IndexProgressor current;

    public BridgingIndexProgressor(IndexProgressor.EntityValueClient client, int[] keys) {
        this.client = client;
        this.keys = keys;
    }

    @Override
    public boolean next() {
        if (this.current == null) {
            this.current = this.progressors.poll();
        }
        while (this.current != null) {
            if (this.current.next()) {
                return true;
            }
            this.current.close();
            this.current = this.progressors.poll();
        }
        return false;
    }

    @Override
    public boolean needsValues() {
        return this.client.needsValues();
    }

    @Override
    public void close() {
        this.progressors.forEach(IndexProgressor::close);
    }

    @Override
    public void initialize(IndexDescriptor descriptor, IndexProgressor progressor, IndexQuery[] queries, IndexOrder indexOrder, boolean needsValues, boolean indexIncludesTransactionState) {
        this.assertKeysAlign(descriptor.schema().getPropertyIds());
        this.progressors.add(progressor);
    }

    private void assertKeysAlign(int[] keys) {
        for (int i = 0; i < this.keys.length; ++i) {
            if (this.keys[i] == keys[i]) continue;
            throw new UnsupportedOperationException("Can not chain multiple progressors with different key set.");
        }
    }

    @Override
    public boolean acceptEntity(long reference, float score, Value[] values) {
        return this.client.acceptEntity(reference, score, values);
    }
}

