/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.storageengine.api.enrichment;

import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Objects;
import org.neo4j.collection.trackable.HeapTrackingArrayList;
import org.neo4j.collection.trackable.HeapTrackingCollections;
import org.neo4j.io.fs.WritableChannel;
import org.neo4j.memory.MemoryTracker;

public class WriteEnrichmentChannel
implements WritableChannel {
    public static final int CHUNK_SIZE = 32768;
    private final HeapTrackingArrayList<ByteBuffer> chunks;
    private final MemoryTracker memoryTracker;
    private ByteBuffer currentChunk;
    private State state = State.APPENDING;

    public WriteEnrichmentChannel(MemoryTracker memoryTracker) {
        this.memoryTracker = Objects.requireNonNull(memoryTracker);
        this.chunks = HeapTrackingCollections.newArrayList((int)1, (MemoryTracker)memoryTracker);
    }

    public WriteEnrichmentChannel flip() {
        if (this.state != State.FLIPPED) {
            this.state = State.FLIPPED;
            this.chunks.forEach(ByteBuffer::flip);
        }
        return this;
    }

    public void serialize(WritableChannel channel) throws IOException {
        if (this.state != State.FLIPPED) {
            throw new IOException("Please ensure that the channel has been flipped");
        }
        for (ByteBuffer chunk : this.chunks) {
            channel.putAll(chunk.slice().order(ByteOrder.LITTLE_ENDIAN));
        }
    }

    public boolean isEmpty() {
        return this.chunks.isEmpty();
    }

    public int size() {
        int pos = 0;
        for (ByteBuffer chunk : this.chunks) {
            pos += this.size(chunk);
        }
        return pos;
    }

    public byte peek(int position) {
        for (ByteBuffer chunk : this.chunks) {
            int endOfChunk = this.size(chunk);
            if (position < endOfChunk) {
                return chunk.get(position);
            }
            position -= endOfChunk;
        }
        throw new BufferOverflowException();
    }

    public char peekChar(int position) {
        for (ByteBuffer chunk : this.chunks) {
            int endOfChunk = this.size(chunk);
            if (position < endOfChunk) {
                return chunk.getChar(position);
            }
            position -= endOfChunk;
        }
        throw new BufferOverflowException();
    }

    public short peekShort(int position) {
        for (ByteBuffer chunk : this.chunks) {
            int endOfChunk = this.size(chunk);
            if (position < endOfChunk) {
                return chunk.getShort(position);
            }
            position -= endOfChunk;
        }
        throw new BufferOverflowException();
    }

    public int peekInt(int position) {
        for (ByteBuffer chunk : this.chunks) {
            int endOfChunk = this.size(chunk);
            if (position < endOfChunk) {
                return chunk.getInt(position);
            }
            position -= endOfChunk;
        }
        throw new BufferOverflowException();
    }

    public long peekLong(int position) {
        for (ByteBuffer chunk : this.chunks) {
            int endOfChunk = this.size(chunk);
            if (position < endOfChunk) {
                return chunk.getLong(position);
            }
            position -= endOfChunk;
        }
        throw new BufferOverflowException();
    }

    public float peekFloat(int position) {
        for (ByteBuffer chunk : this.chunks) {
            int endOfChunk = this.size(chunk);
            if (position < endOfChunk) {
                return chunk.getFloat(position);
            }
            position -= endOfChunk;
        }
        throw new BufferOverflowException();
    }

    public double peekDouble(int position) {
        for (ByteBuffer chunk : this.chunks) {
            int endOfChunk = this.size(chunk);
            if (position < endOfChunk) {
                return chunk.getDouble(position);
            }
            position -= endOfChunk;
        }
        throw new BufferOverflowException();
    }

    public WriteEnrichmentChannel put(int position, byte value) {
        for (ByteBuffer chunk : this.chunks) {
            int endOfChunk = this.size(chunk);
            if (position < endOfChunk) {
                chunk.put(position, value);
                return this;
            }
            position -= endOfChunk;
        }
        throw new BufferOverflowException();
    }

    public WriteEnrichmentChannel putShort(int position, short value) {
        for (ByteBuffer chunk : this.chunks) {
            int endOfChunk = this.size(chunk);
            if (position < endOfChunk) {
                chunk.putShort(position, value);
                return this;
            }
            position -= endOfChunk;
        }
        throw new BufferOverflowException();
    }

    public WriteEnrichmentChannel putInt(int position, int value) {
        for (ByteBuffer chunk : this.chunks) {
            int endOfChunk = this.size(chunk);
            if (position < endOfChunk) {
                chunk.putInt(position, value);
                return this;
            }
            position -= endOfChunk;
        }
        throw new BufferOverflowException();
    }

    public WriteEnrichmentChannel putLong(int position, long value) {
        for (ByteBuffer chunk : this.chunks) {
            int endOfChunk = this.size(chunk);
            if (position < endOfChunk) {
                chunk.putLong(position, value);
                return this;
            }
            position -= endOfChunk;
        }
        throw new BufferOverflowException();
    }

    public WriteEnrichmentChannel putFloat(int position, float value) {
        for (ByteBuffer chunk : this.chunks) {
            int endOfChunk = this.size(chunk);
            if (position < endOfChunk) {
                chunk.putFloat(position, value);
                return this;
            }
            position -= endOfChunk;
        }
        throw new BufferOverflowException();
    }

    public WriteEnrichmentChannel putDouble(int position, double value) {
        for (ByteBuffer chunk : this.chunks) {
            int endOfChunk = this.size(chunk);
            if (position < endOfChunk) {
                chunk.putDouble(position, value);
                return this;
            }
            position -= endOfChunk;
        }
        throw new BufferOverflowException();
    }

    public WriteEnrichmentChannel putChar(char value) {
        this.ensureCapacityForWrite(2).putChar(value);
        return this;
    }

    public WriteEnrichmentChannel put(byte[] value) {
        return this.put(value, value.length);
    }

    public WriteEnrichmentChannel put(byte value) {
        this.ensureCapacityForWrite(1).put(value);
        return this;
    }

    public WriteEnrichmentChannel putShort(short value) {
        this.ensureCapacityForWrite(2).putShort(value);
        return this;
    }

    public WriteEnrichmentChannel putInt(int value) {
        this.ensureCapacityForWrite(4).putInt(value);
        return this;
    }

    public WriteEnrichmentChannel putLong(long value) {
        this.ensureCapacityForWrite(8).putLong(value);
        return this;
    }

    public WriteEnrichmentChannel putFloat(float value) {
        this.ensureCapacityForWrite(4).putFloat(value);
        return this;
    }

    public WriteEnrichmentChannel putDouble(double value) {
        this.ensureCapacityForWrite(8).putDouble(value);
        return this;
    }

    public WriteEnrichmentChannel put(byte[] value, int length) {
        return this.put(value, 0, length);
    }

    public WriteEnrichmentChannel put(byte[] value, int offset, int length) {
        int available;
        for (int pos = offset; pos < length; pos += available) {
            ByteBuffer buffer = this.ensureCapacityForWrite(1);
            available = Math.min(length - pos, buffer.remaining());
            buffer.put(value, pos, available);
        }
        return this;
    }

    public WriteEnrichmentChannel putAll(ByteBuffer src) {
        this.write(src);
        return this;
    }

    public int write(ByteBuffer src) {
        int allToWrite;
        int toWrite;
        for (int remaining = allToWrite = src.remaining(); remaining > 0; remaining -= toWrite) {
            ByteBuffer buffer = this.ensureCapacityForWrite(1);
            toWrite = Math.min(buffer.remaining(), remaining);
            int destPos = buffer.position();
            int srcPos = src.position();
            buffer.put(destPos, src, srcPos, toWrite).position(destPos + toWrite);
            buffer.position(destPos + toWrite);
            src.position(srcPos + toWrite);
        }
        return allToWrite;
    }

    public int putChecksum() throws IOException {
        return 0;
    }

    public void beginChecksumForWriting() {
    }

    public boolean isOpen() {
        return this.state != State.CLOSED;
    }

    public void close() {
        if (this.state != State.CLOSED) {
            this.state = State.CLOSED;
            this.memoryTracker.releaseHeap((long)this.chunks.size() * 32768L);
            this.chunks.close();
        }
    }

    private ByteBuffer ensureCapacityForWrite(int size) {
        if (this.chunks.isEmpty()) {
            return this.newChunk();
        }
        if (this.currentChunk.remaining() < size) {
            return this.newChunk();
        }
        return this.currentChunk;
    }

    private ByteBuffer newChunk() {
        this.memoryTracker.allocateHeap(32768L);
        this.currentChunk = ByteBuffer.allocate(32768).order(ByteOrder.LITTLE_ENDIAN);
        this.chunks.add((Object)this.currentChunk);
        return this.currentChunk;
    }

    private int size(ByteBuffer buffer) {
        return this.state == State.FLIPPED ? buffer.limit() : buffer.position();
    }

    private static enum State {
        APPENDING,
        FLIPPED,
        CLOSED;

    }
}

