/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api.security;

import java.util.Objects;
import org.neo4j.internal.kernel.api.security.Segment;

public class ProcedureSegment
implements Segment {
    private final String procedure;
    public static final ProcedureSegment ALL = new ProcedureSegment(null);

    public ProcedureSegment(String procedure) {
        this.procedure = procedure;
    }

    public String getProcedure() {
        return this.procedure;
    }

    @Override
    public boolean satisfies(Segment segment) {
        if (segment instanceof ProcedureSegment) {
            ProcedureSegment other = (ProcedureSegment)segment;
            return this.procedure == null || this.procedure.equals(other.procedure);
        }
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProcedureSegment that = (ProcedureSegment)o;
        return Objects.equals(this.procedure, that.procedure);
    }

    public int hashCode() {
        return this.procedure != null ? this.procedure.hashCode() : 0;
    }

    public String toString() {
        return this.procedure == null ? "*" : this.procedure;
    }
}

