/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api.security;

import java.util.Collections;
import java.util.Set;
import org.neo4j.gqlstatus.ErrorClassification;
import org.neo4j.gqlstatus.ErrorGqlStatusObject;
import org.neo4j.gqlstatus.ErrorGqlStatusObjectImplementation;
import org.neo4j.gqlstatus.GqlClassification;
import org.neo4j.gqlstatus.GqlStatusInfoCodes;
import org.neo4j.internal.kernel.api.connectioninfo.ClientConnectionInfo;
import org.neo4j.internal.kernel.api.security.AbstractSecurityLog;
import org.neo4j.internal.kernel.api.security.AccessMode;
import org.neo4j.internal.kernel.api.security.AdminAccessMode;
import org.neo4j.internal.kernel.api.security.AdminActionOnResource;
import org.neo4j.internal.kernel.api.security.AuthSubject;
import org.neo4j.internal.kernel.api.security.AuthenticationResult;
import org.neo4j.internal.kernel.api.security.DatabaseAccessMode;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.internal.kernel.api.security.PermissionState;
import org.neo4j.internal.kernel.api.security.SecurityAuthorizationHandler;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.database.PrivilegeDatabaseReference;
import org.neo4j.messages.MessageUtil;

public class SecurityContext
extends LoginContext {
    protected final AccessMode mode;
    private final String database;
    public static final SecurityContext AUTH_DISABLED = SecurityContext.authDisabled(AccessMode.Static.FULL, ClientConnectionInfo.EMBEDDED_CONNECTION, null);

    public SecurityContext(AuthSubject subject, AccessMode mode, ClientConnectionInfo connectionInfo, String database) {
        super(subject, connectionInfo);
        this.mode = mode;
        this.database = database;
    }

    public AccessMode mode() {
        return this.mode;
    }

    public DatabaseAccessMode databaseAccessMode() {
        return DatabaseAccessMode.FULL;
    }

    public String database() {
        return this.database;
    }

    public PermissionState allowExecuteAdminProcedure(int procedureId) {
        return PermissionState.EXPLICIT_GRANT;
    }

    public PermissionState allowsAdminAction(AdminActionOnResource action) {
        return PermissionState.EXPLICIT_GRANT;
    }

    public Set<String> roles() {
        return Collections.emptySet();
    }

    @Override
    public SecurityContext authorize(LoginContext.IdLookup idLookup, PrivilegeDatabaseReference dbReference, AbstractSecurityLog securityLog) {
        return this;
    }

    public SecurityContext withMode(AccessMode mode) {
        return new SecurityContext(this.subject, mode, this.connectionInfo(), this.database());
    }

    public SecurityContext withMode(AdminAccessMode adminAccessMode) {
        return new SecurityContext(this.subject, this.mode, this.connectionInfo(), this.database());
    }

    public void assertCredentialsNotExpired(SecurityAuthorizationHandler handler) {
        if (AuthenticationResult.PASSWORD_CHANGE_REQUIRED.equals((Object)this.subject().getAuthenticationResult())) {
            ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42NFF).withClassification((GqlClassification)ErrorClassification.CLIENT_ERROR).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42NFD).withClassification((GqlClassification)ErrorClassification.CLIENT_ERROR).build()).build();
            throw handler.logAndGetAuthorizationException(gql, this, SecurityAuthorizationHandler.generateCredentialsExpiredMessage("Permission denied."), (Status)Status.Security.CredentialsExpired);
        }
    }

    public String description() {
        return MessageUtil.withUser((String)this.subject().executingUser(), (String)this.mode().name());
    }

    protected String defaultString(String name) {
        return String.format("%s{ username=%s, accessMode=%s }", name, this.subject().executingUser(), this.mode());
    }

    public static SecurityContext authDisabled(AccessMode mode, ClientConnectionInfo connectionInfo, String database) {
        return new SecurityContext(AuthSubject.AUTH_DISABLED, mode, connectionInfo, database){

            @Override
            public SecurityContext withMode(AccessMode mode) {
                return 1.authDisabled(mode, this.connectionInfo(), this.database());
            }

            @Override
            public String description() {
                return "AUTH_DISABLED with " + this.mode().name();
            }

            public String toString() {
                return this.defaultString("auth-disabled");
            }
        };
    }
}

