/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api.security;

import org.neo4j.internal.helpers.NameUtil;
import org.neo4j.internal.kernel.api.security.Segment;

public record UserSegment(String username) implements Segment
{
    public static final UserSegment ALL = new UserSegment(null);

    @Override
    public boolean satisfies(Segment segment) {
        if (segment instanceof UserSegment) {
            UserSegment other = (UserSegment)segment;
            return this.username == null || this.username.equals(other.username);
        }
        return false;
    }

    @Override
    public String toCypherSnippet() {
        if (this.username == null) {
            return "*";
        }
        return NameUtil.escapeName((String)this.username);
    }

    @Override
    public String toString() {
        return String.format("USER(%s)", this.nullToStar(this.username));
    }
}

