/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import java.io.Serializable;
import java.util.List;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.map.primitive.ImmutableByteObjectMap;
import org.eclipse.collections.impl.factory.primitive.ByteObjectMaps;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseInternalSettings;

public enum KernelVersion {
    V2_3(-10),
    V4_0(1),
    V4_2(2),
    V4_3_D4(3),
    V4_4(4),
    V5_0(5),
    V5_7(6),
    GLORIOUS_FUTURE(127);

    public static final KernelVersion EARLIEST;
    private static final KernelVersion LATEST;
    public static final KernelVersion VERSION_IN_WHICH_TOKEN_INDEXES_ARE_INTRODUCED;
    public static final KernelVersion VERSION_LITTLE_ENDIAN_TX_LOG_INTRODUCED;
    public static final KernelVersion VERSION_REL_UNIQUE_CONSTRAINTS_INTRODUCED;
    public static final KernelVersion DEFAULT_BOOTSTRAP_VERSION;
    public static final List<KernelVersion> VERSIONS;
    private static final ImmutableByteObjectMap<KernelVersion> versionMap;
    private final byte version;

    public static KernelVersion getLatestVersion(Config config) {
        Byte version = (Byte)config.get(GraphDatabaseInternalSettings.latest_kernel_version);
        return version == null ? LATEST : KernelVersion.getForVersion(version);
    }

    private KernelVersion(byte version) {
        this.version = version;
    }

    public byte version() {
        return this.version;
    }

    public boolean isLatest(Config config) {
        return this == KernelVersion.getLatestVersion(config);
    }

    public boolean isGreaterThan(KernelVersion other) {
        return this.version > other.version;
    }

    public boolean isGreaterThan(byte other) {
        return this.version > other;
    }

    public boolean isLessThan(KernelVersion other) {
        return this.version < other.version;
    }

    public boolean isLessThan(byte other) {
        return this.version < other;
    }

    public boolean isAtLeast(KernelVersion other) {
        return this.version >= other.version;
    }

    public String toString() {
        return "KernelVersion{" + this.name() + ",version=" + this.version + "}";
    }

    public static KernelVersion getForVersion(byte version) {
        KernelVersion kernelVersion = (KernelVersion)((Object)versionMap.get(version));
        if (kernelVersion == null) {
            throw new IllegalArgumentException("No matching " + KernelVersion.class.getSimpleName() + " for version " + version);
        }
        return kernelVersion;
    }

    static {
        EARLIEST = V4_2;
        LATEST = V5_7;
        VERSION_IN_WHICH_TOKEN_INDEXES_ARE_INTRODUCED = V4_3_D4;
        VERSION_LITTLE_ENDIAN_TX_LOG_INTRODUCED = V5_0;
        VERSION_REL_UNIQUE_CONSTRAINTS_INTRODUCED = V5_7;
        DEFAULT_BOOTSTRAP_VERSION = V5_0;
        VERSIONS = List.of(KernelVersion.values());
        versionMap = ByteObjectMaps.immutable.from(VERSIONS, KernelVersion::version, (Function & Serializable)v -> v);
    }
}

