/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.state;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import org.neo4j.io.memory.ByteBuffers;
import org.neo4j.kernel.impl.util.collection.Memory;
import org.neo4j.kernel.impl.util.collection.MemoryAllocator;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;

class TestMemoryAllocator
implements MemoryAllocator {
    TestMemoryAllocator() {
    }

    public Memory allocate(long size, boolean zeroed, MemoryTracker memoryTracker) {
        ByteBuffer buf = ByteBuffers.allocate((int)Math.toIntExact(size), (ByteOrder)ByteOrder.LITTLE_ENDIAN, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        if (zeroed) {
            Arrays.fill(buf.array(), (byte)0);
        }
        return new MemoryImpl(buf, memoryTracker);
    }

    static class MemoryImpl
    implements Memory {
        final ByteBuffer buf;

        MemoryImpl(ByteBuffer buf, MemoryTracker memoryTracker) {
            this.buf = buf;
            memoryTracker.allocateNative((long)buf.capacity());
        }

        public long readLong(long offset) {
            return this.buf.getLong(Math.toIntExact(offset));
        }

        public void writeLong(long offset, long value) {
            this.buf.putLong(Math.toIntExact(offset), value);
        }

        public void clear() {
            Arrays.fill(this.buf.array(), (byte)0);
        }

        public long size() {
            return this.buf.capacity();
        }

        public void free(MemoryTracker memoryTracker) {
            memoryTracker.releaseNative((long)this.buf.capacity());
        }

        public Memory copy(MemoryTracker memoryTracker) {
            ByteBuffer copyBuf = ByteBuffer.wrap(Arrays.copyOf(this.buf.array(), this.buf.array().length));
            return new MemoryImpl(copyBuf, memoryTracker);
        }

        public ByteBuffer asByteBuffer() {
            return this.buf;
        }
    }
}

