/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test;

import java.util.Map;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.configuration.SettingMigrator;
import org.neo4j.logging.InternalLog;

public class LogFormatOverrideMigrator
implements SettingMigrator {
    public static final String OVERRIDE_LOG_FORMAT_KEY = "NEO4J_OVERRIDE_LOG_FORMAT";
    public static final String ENVELOPES = "envelopes";

    public void migrate(Map<String, String> values, Map<String, String> defaultValues, InternalLog log) {
        String overrideLogFormat = System.getProperty(OVERRIDE_LOG_FORMAT_KEY);
        if (ENVELOPES.equals(overrideLogFormat)) {
            try {
                defaultValues.put(GraphDatabaseInternalSettings.allow_new_log_format_on_upgrade_or_create.name(), "true");
            }
            catch (RuntimeException ex) {
                log.warn("Unable to override the log format to " + overrideLogFormat, (Throwable)ex);
            }
        }
    }
}

