/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test;

import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import org.neo4j.exceptions.KernelException;
import org.neo4j.graphdb.Entity;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.ResourceIterable;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.AnyTokens;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.internal.schema.ConstraintDescriptor;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.internal.GraphDatabaseAPI;

public class GraphDatabaseServiceCleaner {
    private GraphDatabaseServiceCleaner() {
        throw new UnsupportedOperationException();
    }

    public static void cleanDatabaseContent(GraphDatabaseService db) {
        GraphDatabaseServiceCleaner.cleanupSchema(db);
        GraphDatabaseServiceCleaner.cleanupAllRelationshipsAndNodes(db);
    }

    public static void cleanupSchema(GraphDatabaseService db) {
        InternalTransaction tx;
        try {
            tx = ((GraphDatabaseAPI)db).beginTransaction(KernelTransaction.Type.EXPLICIT, LoginContext.AUTH_DISABLED);
            try {
                for (ConstraintDescriptor constraintDescriptor : Iterators.loop((Iterator)tx.kernelTransaction().schemaRead().constraintsGetAll())) {
                    tx.kernelTransaction().schemaWrite().constraintDrop(constraintDescriptor, true);
                }
                for (IndexDefinition index : tx.schema().getIndexes()) {
                    index.drop();
                }
                tx.commit();
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
        }
        catch (KernelException e) {
            throw new RuntimeException(e);
        }
        tx = db.beginTx();
        try {
            tx.schema().indexFor(AnyTokens.ANY_RELATIONSHIP_TYPES).withName("rti").create();
            tx.schema().indexFor(AnyTokens.ANY_LABELS).withName("lti").create();
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = db.beginTx();
        try {
            tx.schema().awaitIndexesOnline(1L, TimeUnit.MINUTES);
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    public static void cleanupAllRelationshipsAndNodes(GraphDatabaseService db) {
        try (Transaction tx = db.beginTx();
             ResourceIterable allRelationships = tx.getAllRelationships();
             ResourceIterable allNodes = tx.getAllNodes();){
            allRelationships.forEach(Entity::delete);
            allNodes.forEach(Node::delete);
            tx.commit();
        }
    }
}

