/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.util.Iterator;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.constraints.UniquenessConstraint;
import org.neo4j.kernel.api.exceptions.schema.AddIndexFailureException;
import org.neo4j.kernel.api.exceptions.schema.AlreadyConstrainedException;
import org.neo4j.kernel.api.exceptions.schema.AlreadyIndexedException;
import org.neo4j.kernel.api.exceptions.schema.CreateConstraintFailureException;
import org.neo4j.kernel.api.exceptions.schema.DropConstraintFailureException;
import org.neo4j.kernel.api.exceptions.schema.DropIndexFailureException;
import org.neo4j.kernel.api.exceptions.schema.IllegalTokenNameException;
import org.neo4j.kernel.api.exceptions.schema.IndexBelongsToConstraintException;
import org.neo4j.kernel.api.exceptions.schema.NoSuchConstraintException;
import org.neo4j.kernel.api.exceptions.schema.NoSuchIndexException;
import org.neo4j.kernel.api.exceptions.schema.SchemaKernelException;
import org.neo4j.kernel.api.exceptions.schema.TooManyLabelsException;
import org.neo4j.kernel.api.index.IndexDescriptor;
import org.neo4j.kernel.impl.api.KernelStatement;
import org.neo4j.kernel.impl.api.operations.KeyWriteOperations;
import org.neo4j.kernel.impl.api.operations.SchemaReadOperations;
import org.neo4j.kernel.impl.api.operations.SchemaWriteOperations;

public class DataIntegrityValidatingStatementOperations
implements KeyWriteOperations,
SchemaWriteOperations {
    private final KeyWriteOperations keyWriteDelegate;
    private final SchemaReadOperations schemaReadDelegate;
    private final SchemaWriteOperations schemaWriteDelegate;

    public DataIntegrityValidatingStatementOperations(KeyWriteOperations keyWriteDelegate, SchemaReadOperations schemaReadDelegate, SchemaWriteOperations schemaWriteDelegate) {
        this.keyWriteDelegate = keyWriteDelegate;
        this.schemaReadDelegate = schemaReadDelegate;
        this.schemaWriteDelegate = schemaWriteDelegate;
    }

    @Override
    public int propertyKeyGetOrCreateForName(Statement state, String propertyKey) throws IllegalTokenNameException {
        return this.keyWriteDelegate.propertyKeyGetOrCreateForName(state, this.checkValidTokenName(propertyKey));
    }

    @Override
    public int relationshipTypeGetOrCreateForName(Statement state, String relationshipTypeName) throws IllegalTokenNameException {
        return this.keyWriteDelegate.relationshipTypeGetOrCreateForName(state, this.checkValidTokenName(relationshipTypeName));
    }

    @Override
    public int labelGetOrCreateForName(Statement state, String label) throws IllegalTokenNameException, TooManyLabelsException {
        return this.keyWriteDelegate.labelGetOrCreateForName(state, this.checkValidTokenName(label));
    }

    @Override
    public IndexDescriptor indexCreate(KernelStatement state, int labelId, int propertyKey) throws AddIndexFailureException, AlreadyIndexedException, AlreadyConstrainedException {
        this.checkIndexExistence(state, SchemaKernelException.OperationContext.INDEX_CREATION, labelId, propertyKey);
        return this.schemaWriteDelegate.indexCreate(state, labelId, propertyKey);
    }

    @Override
    public void indexDrop(KernelStatement state, IndexDescriptor descriptor) throws DropIndexFailureException {
        try {
            this.assertIsNotUniqueIndex(descriptor, this.schemaReadDelegate.uniqueIndexesGetForLabel(state, descriptor.getLabelId()));
            this.assertIndexExists(descriptor, this.schemaReadDelegate.indexesGetForLabel(state, descriptor.getLabelId()));
        }
        catch (IndexBelongsToConstraintException | NoSuchIndexException e) {
            throw new DropIndexFailureException(descriptor, e);
        }
        this.schemaWriteDelegate.indexDrop(state, descriptor);
    }

    @Override
    public void uniqueIndexDrop(KernelStatement state, IndexDescriptor descriptor) throws DropIndexFailureException {
        this.schemaWriteDelegate.uniqueIndexDrop(state, descriptor);
    }

    @Override
    public UniquenessConstraint uniquenessConstraintCreate(KernelStatement state, int labelId, int propertyKey) throws AlreadyConstrainedException, CreateConstraintFailureException, AlreadyIndexedException {
        Iterator<UniquenessConstraint> constraints = this.schemaReadDelegate.constraintsGetForLabelAndPropertyKey(state, labelId, propertyKey);
        if (constraints.hasNext()) {
            throw new AlreadyConstrainedException(constraints.next(), SchemaKernelException.OperationContext.CONSTRAINT_CREATION);
        }
        this.checkIndexExistence(state, SchemaKernelException.OperationContext.CONSTRAINT_CREATION, labelId, propertyKey);
        return this.schemaWriteDelegate.uniquenessConstraintCreate(state, labelId, propertyKey);
    }

    @Override
    public void constraintDrop(KernelStatement state, UniquenessConstraint constraint) throws DropConstraintFailureException {
        try {
            this.assertConstraintExists(constraint, this.schemaReadDelegate.constraintsGetForLabelAndPropertyKey(state, constraint.label(), constraint.propertyKeyId()));
        }
        catch (NoSuchConstraintException e) {
            throw new DropConstraintFailureException(constraint, (Throwable)e);
        }
        this.schemaWriteDelegate.constraintDrop(state, constraint);
    }

    private void checkIndexExistence(KernelStatement state, SchemaKernelException.OperationContext context, int labelId, int propertyKey) throws AlreadyIndexedException, AlreadyConstrainedException {
        for (IndexDescriptor descriptor : IteratorUtil.loop(this.schemaReadDelegate.indexesGetForLabel(state, labelId))) {
            if (descriptor.getPropertyKeyId() != propertyKey) continue;
            throw new AlreadyIndexedException(descriptor, context);
        }
        for (IndexDescriptor descriptor : IteratorUtil.loop(this.schemaReadDelegate.uniqueIndexesGetForLabel(state, labelId))) {
            if (descriptor.getPropertyKeyId() != propertyKey) continue;
            throw new AlreadyConstrainedException(new UniquenessConstraint(descriptor.getLabelId(), descriptor.getPropertyKeyId()), context);
        }
    }

    private String checkValidTokenName(String name) throws IllegalTokenNameException {
        if (name == null || name.isEmpty()) {
            throw new IllegalTokenNameException(name);
        }
        return name;
    }

    private void assertIsNotUniqueIndex(IndexDescriptor descriptor, Iterator<IndexDescriptor> uniqueIndexes) throws IndexBelongsToConstraintException {
        while (uniqueIndexes.hasNext()) {
            IndexDescriptor uniqueIndex = uniqueIndexes.next();
            if (uniqueIndex.getPropertyKeyId() != descriptor.getPropertyKeyId()) continue;
            throw new IndexBelongsToConstraintException(descriptor);
        }
    }

    private void assertIndexExists(IndexDescriptor descriptor, Iterator<IndexDescriptor> indexes) throws NoSuchIndexException {
        for (IndexDescriptor existing : IteratorUtil.loop(indexes)) {
            if (existing.getPropertyKeyId() != descriptor.getPropertyKeyId()) continue;
            return;
        }
        throw new NoSuchIndexException(descriptor);
    }

    private void assertConstraintExists(UniquenessConstraint constraint, Iterator<UniquenessConstraint> constraints) throws NoSuchConstraintException {
        for (UniquenessConstraint existing : IteratorUtil.loop(constraints)) {
            if (!existing.equals(constraint.label(), constraint.propertyKeyId())) continue;
            return;
        }
        throw new NoSuchConstraintException(constraint);
    }
}

