/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.state;

import java.util.Iterator;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.helpers.Predicate;
import org.neo4j.helpers.collection.CombiningIterator;
import org.neo4j.helpers.collection.FilteringIterator;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.kernel.api.properties.DefinedProperty;
import org.neo4j.kernel.impl.api.state.EntityState;
import org.neo4j.kernel.impl.util.VersionedHashMap;

public class PropertyContainerState
extends EntityState {
    private static final ResourceIterator<DefinedProperty> NO_PROPERTIES = IteratorUtil.emptyIterator();
    private VersionedHashMap<Integer, DefinedProperty> addedProperties;
    private VersionedHashMap<Integer, DefinedProperty> changedProperties;
    private VersionedHashMap<Integer, DefinedProperty> removedProperties;
    private final Predicate<DefinedProperty> excludePropertiesWeKnowAbout = new Predicate<DefinedProperty>(){

        @Override
        public boolean accept(DefinedProperty item) {
            return !(PropertyContainerState.this.removedProperties != null && PropertyContainerState.this.removedProperties.containsKey(item.propertyKeyId()) || PropertyContainerState.this.addedProperties != null && PropertyContainerState.this.addedProperties.containsKey(item.propertyKeyId()) || PropertyContainerState.this.changedProperties != null && PropertyContainerState.this.changedProperties.containsKey(item.propertyKeyId()));
        }
    };

    public PropertyContainerState(long id) {
        super(id);
    }

    public void clear() {
        if (this.changedProperties != null) {
            this.changedProperties.clear();
        }
        if (this.addedProperties != null) {
            this.addedProperties.clear();
        }
        if (this.removedProperties != null) {
            this.removedProperties.clear();
        }
    }

    public void changeProperty(DefinedProperty property) {
        if (this.addedProperties != null && this.addedProperties.containsKey(property.propertyKeyId())) {
            this.addedProperties.put(property.propertyKeyId(), property);
            return;
        }
        if (this.changedProperties == null) {
            this.changedProperties = new VersionedHashMap();
        }
        this.changedProperties.put(property.propertyKeyId(), property);
        if (this.removedProperties != null) {
            this.removedProperties.remove(property.propertyKeyId());
        }
    }

    public void addProperty(DefinedProperty property) {
        DefinedProperty removed;
        if (this.removedProperties != null && (removed = this.removedProperties.remove(property.propertyKeyId())) != null) {
            this.changeProperty(property);
            return;
        }
        if (this.addedProperties == null) {
            this.addedProperties = new VersionedHashMap();
        }
        this.addedProperties.put(property.propertyKeyId(), property);
    }

    public void removeProperty(DefinedProperty property) {
        if (this.addedProperties != null && this.addedProperties.remove(property.propertyKeyId()) != null) {
            return;
        }
        if (this.removedProperties == null) {
            this.removedProperties = new VersionedHashMap();
        }
        this.removedProperties.put(property.propertyKeyId(), property);
        if (this.changedProperties != null) {
            this.changedProperties.remove(property.propertyKeyId());
        }
    }

    public Iterator<DefinedProperty> addedProperties() {
        return this.addedProperties != null ? this.addedProperties.values().iterator() : NO_PROPERTIES;
    }

    public Iterator<DefinedProperty> changedProperties() {
        return this.changedProperties != null ? this.changedProperties.values().iterator() : NO_PROPERTIES;
    }

    public Iterator<Integer> removedProperties() {
        return this.removedProperties != null ? this.removedProperties.keySet().iterator() : IteratorUtil.emptyIterator();
    }

    public Iterator<DefinedProperty> addedAndChangedProperties() {
        Iterator<DefinedProperty> out = null;
        if (this.addedProperties != null) {
            out = this.addedProperties.values().iterator();
        }
        if (this.changedProperties != null) {
            out = out != null ? new CombiningIterator<DefinedProperty>(IteratorUtil.iterator(out, this.changedProperties.values().iterator())) : this.changedProperties.values().iterator();
        }
        return out != null ? out : NO_PROPERTIES;
    }

    public Iterator<DefinedProperty> augmentProperties(Iterator<DefinedProperty> iterator) {
        if (this.removedProperties != null || this.addedProperties != null || this.changedProperties != null) {
            iterator = new FilteringIterator<DefinedProperty>(iterator, this.excludePropertiesWeKnowAbout);
            if (this.addedProperties != null && this.addedProperties.size() > 0) {
                iterator = new CombiningIterator<DefinedProperty>(IteratorUtil.iterator(iterator, this.addedProperties.values().iterator()));
            }
            if (this.changedProperties != null && this.changedProperties.size() > 0) {
                iterator = new CombiningIterator<DefinedProperty>(IteratorUtil.iterator(iterator, this.changedProperties.values().iterator()));
            }
        }
        return iterator;
    }

    public void accept(Visitor visitor) {
        if (this.addedProperties != null || this.removedProperties != null || this.changedProperties != null) {
            visitor.visitPropertyChanges(this.getId(), this.addedProperties(), this.changedProperties(), this.removedProperties());
        }
    }

    public static interface Visitor {
        public void visitPropertyChanges(long var1, Iterator<DefinedProperty> var3, Iterator<DefinedProperty> var4, Iterator<Integer> var5);
    }
}

