/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.helpers.UTF8;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.helpers.collection.IteratorWrapper;
import org.neo4j.kernel.DefaultIdGeneratorFactory;
import org.neo4j.kernel.DefaultTxHook;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.core.Token;
import org.neo4j.kernel.impl.nioneo.store.DefaultWindowPoolFactory;
import org.neo4j.kernel.impl.nioneo.store.DynamicRecord;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;
import org.neo4j.kernel.impl.nioneo.store.NeoStore;
import org.neo4j.kernel.impl.nioneo.store.NeoStoreUtil;
import org.neo4j.kernel.impl.nioneo.store.NodeRecord;
import org.neo4j.kernel.impl.nioneo.store.PropertyBlock;
import org.neo4j.kernel.impl.nioneo.store.PropertyKeyTokenRecord;
import org.neo4j.kernel.impl.nioneo.store.PropertyKeyTokenStore;
import org.neo4j.kernel.impl.nioneo.store.PropertyRecord;
import org.neo4j.kernel.impl.nioneo.store.PropertyStore;
import org.neo4j.kernel.impl.nioneo.store.RelationshipRecord;
import org.neo4j.kernel.impl.nioneo.store.StoreFactory;
import org.neo4j.kernel.impl.nioneo.xa.command.PhysicalLogNeoXaCommandWriter;
import org.neo4j.kernel.impl.storemigration.StoreFileType;
import org.neo4j.kernel.impl.storemigration.StoreMigrationParticipant;
import org.neo4j.kernel.impl.storemigration.StoreVersionCheck;
import org.neo4j.kernel.impl.storemigration.UpgradableDatabase;
import org.neo4j.kernel.impl.storemigration.legacystore.LegacyLogFiles;
import org.neo4j.kernel.impl.storemigration.legacystore.LegacyLuceneCommandReader;
import org.neo4j.kernel.impl.storemigration.legacystore.LegacyNodeStoreReader;
import org.neo4j.kernel.impl.storemigration.legacystore.LegacyRelationshipStoreReader;
import org.neo4j.kernel.impl.storemigration.legacystore.LegacyStore;
import org.neo4j.kernel.impl.storemigration.legacystore.v19.Legacy19CommandReader;
import org.neo4j.kernel.impl.storemigration.legacystore.v19.Legacy19LogIoUtil;
import org.neo4j.kernel.impl.storemigration.legacystore.v19.Legacy19Store;
import org.neo4j.kernel.impl.storemigration.legacystore.v20.Legacy20CommandReader;
import org.neo4j.kernel.impl.storemigration.legacystore.v20.Legacy20LogIoUtil;
import org.neo4j.kernel.impl.storemigration.legacystore.v20.Legacy20Store;
import org.neo4j.kernel.impl.storemigration.legacystore.v20.StoreFile20;
import org.neo4j.kernel.impl.storemigration.monitoring.MigrationProgressMonitor;
import org.neo4j.kernel.impl.transaction.xaframework.LogEntryWriterv1;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.kernel.logging.Logging;
import org.neo4j.kernel.logging.SystemOutLogging;
import org.neo4j.unsafe.impl.batchimport.Configuration;
import org.neo4j.unsafe.impl.batchimport.ParallelBatchImporter;
import org.neo4j.unsafe.impl.batchimport.cache.idmapping.IdMappings;
import org.neo4j.unsafe.impl.batchimport.input.InputNode;
import org.neo4j.unsafe.impl.batchimport.input.InputRelationship;
import org.neo4j.unsafe.impl.batchimport.staging.CoarseBoundedProgressExecutionMonitor;

public class StoreMigrator
extends StoreMigrationParticipant.Adapter {
    private static final Object[] NO_PROPERTIES = new Object[0];
    private final MigrationProgressMonitor progressMonitor;
    private final UpgradableDatabase upgradableDatabase;
    private final Config config;
    private final Logging logging;
    private String versionToUpgradeFrom;
    private LegacyStore legacyStore;
    private LegacyLogFiles legacyLogFiles;

    public StoreMigrator(MigrationProgressMonitor progressMonitor, FileSystemAbstraction fileSystem) {
        this(progressMonitor, new UpgradableDatabase(new StoreVersionCheck(fileSystem)), new Config(), new SystemOutLogging());
    }

    public StoreMigrator(MigrationProgressMonitor progressMonitor, UpgradableDatabase upgradableDatabase, Config config, Logging logging) {
        this.progressMonitor = progressMonitor;
        this.upgradableDatabase = upgradableDatabase;
        this.config = config;
        this.logging = logging;
    }

    @Override
    public boolean needsMigration(FileSystemAbstraction fileSystem, File storeDir) throws IOException {
        NeoStoreUtil neoStoreUtil = new NeoStoreUtil(storeDir, fileSystem);
        String versionAsString = NeoStore.versionLongToString(neoStoreUtil.getStoreVersion());
        boolean sameVersion = "v0.A.3".equals(versionAsString);
        if (!sameVersion) {
            this.upgradableDatabase.checkUpgradeable(storeDir);
        }
        return !sameVersion;
    }

    private String versionToUpgradeFrom(FileSystemAbstraction fileSystem, File storeDir) {
        if (this.versionToUpgradeFrom == null) {
            this.versionToUpgradeFrom = this.upgradableDatabase.checkUpgradeable(storeDir);
            LogEntryWriterv1 logEntryWriter = new LogEntryWriterv1();
            logEntryWriter.setCommandWriter(new PhysicalLogNeoXaCommandWriter());
            LogEntryWriterv1 luceneLogEntryWriter = new LogEntryWriterv1();
            luceneLogEntryWriter.setCommandWriter(LegacyLuceneCommandReader.newWriter());
            if (this.versionToUpgradeFrom.equals("v0.A.0")) {
                Legacy19LogIoUtil logIoUtil = new Legacy19LogIoUtil(new Legacy19CommandReader());
                Legacy19LogIoUtil luceneLogIoUtil = new Legacy19LogIoUtil(LegacyLuceneCommandReader.newReader());
                this.legacyLogFiles = new LegacyLogFiles(fileSystem, logEntryWriter, luceneLogEntryWriter, logIoUtil, luceneLogIoUtil);
            } else {
                Legacy20LogIoUtil logIoUtil = new Legacy20LogIoUtil(new Legacy20CommandReader());
                Legacy20LogIoUtil luceneLogIoUtil = new Legacy20LogIoUtil(LegacyLuceneCommandReader.newReader());
                this.legacyLogFiles = new LegacyLogFiles(fileSystem, logEntryWriter, luceneLogEntryWriter, logIoUtil, luceneLogIoUtil);
            }
        }
        return this.versionToUpgradeFrom;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void migrate(FileSystemAbstraction fileSystem, File storeDir, File migrationDir, DependencyResolver dependencyResolver) throws IOException {
        this.progressMonitor.started();
        this.legacyStore = this.versionToUpgradeFrom(fileSystem, storeDir).equals("v0.A.0") ? new Legacy19Store(fileSystem, new File(storeDir, "neostore")) : new Legacy20Store(fileSystem, new File(storeDir, "neostore"));
        CoarseBoundedProgressExecutionMonitor executionMonitor = new CoarseBoundedProgressExecutionMonitor(this.legacyStore.getNodeStoreReader().getMaxId(), this.legacyStore.getRelStoreReader().getMaxId()){

            @Override
            protected void percent(int percent) {
                StoreMigrator.this.progressMonitor.percentComplete(percent);
            }
        };
        ParallelBatchImporter importer = new ParallelBatchImporter(migrationDir.getAbsolutePath(), fileSystem, new Configuration.OverrideFromConfig(this.config), this.logging, executionMonitor);
        Iterable<InputNode> nodes = this.legacyNodesAsInput(this.legacyStore);
        Iterable<InputRelationship> relationships = this.legacyRelationshipsAsInput(this.legacyStore);
        importer.doImport(nodes, relationships, IdMappings.actual());
        this.progressMonitor.finished();
        importer.shutdown();
        if (this.legacyStore instanceof Legacy19Store) {
            Legacy19Store legacy19Store = (Legacy19Store)this.legacyStore;
            try (PropertyStore propertyStore = this.storeFactory(fileSystem, migrationDir).newPropertyStore(new File(migrationDir.getPath(), "neostore.propertystore.db"));){
                this.migratePropertyKeys(legacy19Store, propertyStore);
            }
        }
        this.legacyLogFiles.migrateNeoLogs(fileSystem, migrationDir, storeDir);
        this.legacyLogFiles.migrateLuceneLogs(fileSystem, migrationDir, storeDir);
        this.legacyStore.close();
    }

    private StoreFactory storeFactory(FileSystemAbstraction fileSystem, File migrationDir) {
        return new StoreFactory(StoreFactory.configForNeoStore(this.config, new File(migrationDir, "neostore")), new DefaultIdGeneratorFactory(), new DefaultWindowPoolFactory(), fileSystem, StringLogger.DEV_NULL, new DefaultTxHook());
    }

    private void migratePropertyKeys(Legacy19Store legacyStore, PropertyStore propertyStore) throws IOException {
        Token[] tokens = legacyStore.getPropertyIndexReader().readTokens();
        Map<Integer, Integer> propertyKeyTranslation = this.dedupAndWritePropertyKeyTokenStore(propertyStore, tokens);
        this.migratePropertyStore(legacyStore, propertyKeyTranslation, propertyStore);
    }

    private Map<Integer, Integer> dedupAndWritePropertyKeyTokenStore(PropertyStore propertyStore, Token[] tokens) {
        PropertyKeyTokenStore keyTokenStore = propertyStore.getPropertyKeyTokenStore();
        HashMap<Integer, Integer> translations = new HashMap<Integer, Integer>();
        HashMap<String, Integer> createdTokens = new HashMap<String, Integer>();
        for (Token token : tokens) {
            Integer id = (Integer)createdTokens.get(token.name());
            if (id == null) {
                id = (int)keyTokenStore.nextId();
                PropertyKeyTokenRecord record = new PropertyKeyTokenRecord(id);
                Collection<DynamicRecord> nameRecords = keyTokenStore.allocateNameRecords(UTF8.encode(token.name()));
                record.setNameId((int)IteratorUtil.first(nameRecords).getId());
                record.addNameRecords(nameRecords);
                record.setInUse(true);
                record.setCreated();
                keyTokenStore.updateRecord(record);
                createdTokens.put(token.name(), id);
            }
            translations.put(token.id(), id);
        }
        return translations;
    }

    private void migratePropertyStore(Legacy19Store legacyStore, Map<Integer, Integer> propertyKeyTranslation, PropertyStore propertyStore) throws IOException {
        long lastInUseId = -1L;
        for (PropertyRecord propertyRecord : IteratorUtil.loop(legacyStore.getPropertyStoreReader().readPropertyStore())) {
            for (PropertyBlock block : propertyRecord.getPropertyBlocks()) {
                int key = block.getKeyIndexId();
                Integer translation = propertyKeyTranslation.get(key);
                if (translation == null) continue;
                block.setKeyIndexId(translation);
            }
            propertyStore.setHighId(propertyRecord.getId() + 1L);
            propertyStore.updateRecord(propertyRecord);
            for (long id = lastInUseId + 1L; id < propertyRecord.getId(); ++id) {
                propertyStore.freeId(id);
            }
            lastInUseId = propertyRecord.getId();
        }
    }

    private StoreFile20[] allExcept(StoreFile20 ... exceptions) {
        ArrayList<StoreFile20> result = new ArrayList<StoreFile20>();
        result.addAll(Arrays.asList(StoreFile20.values()));
        for (StoreFile20 except : exceptions) {
            result.remove((Object)except);
        }
        return result.toArray(new StoreFile20[result.size()]);
    }

    private Iterable<InputRelationship> legacyRelationshipsAsInput(LegacyStore legacyStore) {
        final LegacyRelationshipStoreReader reader = legacyStore.getRelStoreReader();
        return new Iterable<InputRelationship>(){

            @Override
            public Iterator<InputRelationship> iterator() {
                Iterator<RelationshipRecord> source;
                try {
                    source = reader.iterator(0L);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                return new IteratorWrapper<InputRelationship, RelationshipRecord>(source){

                    @Override
                    protected InputRelationship underlyingObjectToObject(RelationshipRecord record) {
                        return new InputRelationship(record.getId(), NO_PROPERTIES, record.getNextProp(), record.getFirstNode(), record.getSecondNode(), null, record.getType());
                    }
                };
            }
        };
    }

    private Iterable<InputNode> legacyNodesAsInput(LegacyStore legacyStore) {
        final LegacyNodeStoreReader reader = legacyStore.getNodeStoreReader();
        final String[] NO_LABELS = new String[]{};
        return new Iterable<InputNode>(){

            @Override
            public Iterator<InputNode> iterator() {
                Iterator<NodeRecord> source;
                try {
                    source = reader.iterator();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                return new IteratorWrapper<InputNode, NodeRecord>(source){

                    @Override
                    protected InputNode underlyingObjectToObject(NodeRecord record) {
                        return new InputNode(record.getId(), NO_PROPERTIES, record.getNextProp(), NO_LABELS, record.getLabelField());
                    }
                };
            }
        };
    }

    @Override
    public void moveMigratedFiles(FileSystemAbstraction fs, File migrationDir, File storeDir) throws IOException {
        StoreFile20.deleteIdFile(fs, migrationDir, this.allExcept(StoreFile20.RELATIONSHIP_GROUP_STORE));
        List<StoreFile20> filesToMove = this.versionToUpgradeFrom(fs, storeDir).equals("v0.A.0") ? Arrays.asList(StoreFile20.NODE_STORE, StoreFile20.RELATIONSHIP_STORE, StoreFile20.RELATIONSHIP_GROUP_STORE, StoreFile20.LABEL_TOKEN_STORE, StoreFile20.NODE_LABEL_STORE, StoreFile20.LABEL_TOKEN_NAMES_STORE, StoreFile20.PROPERTY_STORE, StoreFile20.PROPERTY_KEY_TOKEN_STORE, StoreFile20.PROPERTY_KEY_TOKEN_NAMES_STORE, StoreFile20.SCHEMA_STORE) : Arrays.asList(StoreFile20.NODE_STORE, StoreFile20.RELATIONSHIP_STORE, StoreFile20.RELATIONSHIP_GROUP_STORE);
        StoreFile20.move(fs, migrationDir, storeDir, filesToMove, true, true, StoreFileType.values());
        StoreFile20.ensureStoreVersion(fs, storeDir, StoreFile20.currentStoreFiles());
        this.legacyLogFiles.moveRewrittenNeoLogs(migrationDir, storeDir);
        this.legacyLogFiles.moveRewrittenLuceneLogs(migrationDir, storeDir);
    }

    @Override
    public void cleanup(FileSystemAbstraction fileSystem, File migrationDir) throws IOException {
        fileSystem.deleteRecursively(migrationDir);
    }

    public String toString() {
        return "Kernel StoreMigrator";
    }
}

