/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.cache.idmapping;

import org.neo4j.unsafe.impl.batchimport.cache.idmapping.IdGenerator;

public class IdGenerators {
    public static IdGenerator fromInput() {
        return new FromInput();
    }

    private static class FromInput
    implements IdGenerator {
        private long lastSeenId;

        private FromInput() {
        }

        @Override
        public long generate(Object inputId) {
            assert (inputId instanceof Long);
            long inputLongId = (Long)inputId;
            if (this.lastSeenId != -1L && inputLongId < this.lastSeenId) {
                throw new IllegalArgumentException("Cannot go backwards in node id sequence, last seen was " + this.lastSeenId + ", given id is " + inputLongId);
            }
            this.lastSeenId = inputLongId;
            return inputLongId;
        }
    }
}

