/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.store;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.neo4j.helpers.Factory;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.nioneo.store.Buffer;
import org.neo4j.kernel.impl.nioneo.store.OperationType;
import org.neo4j.kernel.impl.nioneo.store.PersistenceWindow;
import org.neo4j.kernel.impl.nioneo.store.StoreChannel;
import org.neo4j.kernel.impl.nioneo.store.WindowPoolStats;
import org.neo4j.kernel.impl.nioneo.store.windowpool.WindowPool;
import org.neo4j.kernel.impl.nioneo.store.windowpool.WindowPoolFactory;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.unsafe.impl.batchimport.store.io.Monitor;
import org.neo4j.unsafe.impl.batchimport.store.io.SimplePool;

public class BatchingWindowPoolFactory
implements WindowPoolFactory {
    private static final ByteBuffer ZEROS = ByteBuffer.allocateDirect(4096);
    public static final WriterFactory SYNCHRONOUS = new WriterFactory(){

        @Override
        public Writer create(final StoreChannel channel, final Monitor monitor) {
            return new Writer(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void write(ByteBuffer data, long position, SimplePool<ByteBuffer> pool) throws IOException {
                    try {
                        int written = channel.write(data, position);
                        monitor.dataWritten(written);
                    }
                    finally {
                        pool.release(data);
                    }
                }
            };
        }

        @Override
        public void awaitEverythingWritten() {
        }

        @Override
        public void shutdown() {
        }
    };
    private final int windowTargetSize;
    private final Monitor monitor;
    private Mode mode;
    private final WriterFactory writerFactory;

    public BatchingWindowPoolFactory(int windowTargetSize, Monitor monitor, Mode mode, WriterFactory writerFactory) {
        this.windowTargetSize = windowTargetSize;
        this.monitor = monitor;
        this.mode = mode;
        this.writerFactory = writerFactory;
    }

    void setMode(Mode mode) {
        this.mode = mode;
    }

    @Override
    public WindowPool create(File storageFileName, int recordSize, StoreChannel fileChannel, Config configuration, StringLogger log, int numberOfReservedLowIds) {
        return new SingleWindowPool(storageFileName, recordSize, fileChannel);
    }

    protected SingleWindow createSingleWindow(File storageFileName, int recordSize, StoreChannel channel) {
        return new SingleWindow(storageFileName, recordSize, channel);
    }

    protected class SingleWindow
    implements PersistenceWindow {
        private final File storageFileName;
        private final int recordSize;
        private final StoreChannel channel;
        private SimplePool<ByteBuffer> bufferPool;
        private Buffer currentBuffer;
        private int maxRecordsInBuffer;
        protected long firstIdInWindow;
        protected long lastIdInWindow;
        private final Writer writer;
        private long currentWindowIndex = -1L;

        protected SingleWindow(File storageFileName, int recordSize, StoreChannel channel) {
            this.storageFileName = storageFileName;
            this.recordSize = recordSize;
            this.channel = channel;
            this.writer = BatchingWindowPoolFactory.this.writerFactory.create(channel, BatchingWindowPoolFactory.this.monitor);
        }

        public String toString() {
            return "Batch friendly " + this.getClass().getSimpleName() + " for " + this.storageFileName;
        }

        protected void allocateBuffer() {
            final int capacity = this.roundedToNearestRecordSize(BatchingWindowPoolFactory.this.windowTargetSize);
            this.maxRecordsInBuffer = capacity / this.recordSize;
            this.bufferPool = new SimplePool<ByteBuffer>(2, new Factory<ByteBuffer>(){

                @Override
                public ByteBuffer newInstance() {
                    return ByteBuffer.allocateDirect(capacity);
                }
            });
            this.currentBuffer = new Buffer(this, this.bufferPool.acquire());
        }

        private int roundedToNearestRecordSize(int targetSize) {
            int rest = targetSize % this.recordSize;
            return targetSize - rest;
        }

        protected PersistenceWindow acquire(long id, OperationType operationType) {
            assert (operationType == OperationType.WRITE || operationType == OperationType.READ && BatchingWindowPoolFactory.this.mode.canReadFrom(this.windowIndex(id)));
            boolean isInCurrentWindow = this.idIsWithinCurrentWindow(id);
            if (!isInCurrentWindow) {
                this.writeBufferToChannel();
                this.placeWindowFor(id);
            }
            return this;
        }

        private void placeWindowFor(long id) {
            long windowIndex = this.windowIndex(id);
            this.firstIdInWindow = windowIndex * (long)this.maxRecordsInBuffer;
            this.lastIdInWindow = this.firstIdInWindow + (long)this.maxRecordsInBuffer - 1L;
            if (BatchingWindowPoolFactory.this.mode.canReadFrom(windowIndex)) {
                this.readBufferFromChannel();
            } else {
                this.zeroBuffer();
            }
            this.currentWindowIndex = windowIndex;
        }

        private void zeroBuffer() {
            ByteBuffer zeros = ZEROS.duplicate();
            this.currentBuffer.reset();
            ByteBuffer buffer = this.currentBuffer.getBuffer();
            while (buffer.hasRemaining()) {
                int chunkSize = Math.min(buffer.remaining(), zeros.capacity());
                zeros.clear();
                zeros.limit(chunkSize);
                buffer.put(zeros);
            }
        }

        private long windowIndex(long id) {
            return id / (long)this.maxRecordsInBuffer;
        }

        private boolean idIsWithinCurrentWindow(long id) {
            return this.windowIndex(id) == this.currentWindowIndex;
        }

        @Override
        public Buffer getBuffer() {
            throw new UnsupportedOperationException("Not really needed");
        }

        @Override
        public Buffer getOffsettedBuffer(long id) {
            assert (this.idIsWithinCurrentWindow(id)) : "Quite surprisingly the id " + id + " is outside the current window. At this point acquire should have been called previously" + " with the same id. First id in window " + this.firstIdInWindow + ", last " + this.lastIdInWindow;
            this.currentBuffer.setOffset((int)((id - this.firstIdInWindow) * (long)this.recordSize));
            return this.currentBuffer;
        }

        @Override
        public int getRecordSize() {
            return this.recordSize;
        }

        @Override
        public long position() {
            try {
                return this.channel.position();
            }
            catch (IOException e) {
                throw this.handleIoException(e);
            }
        }

        private RuntimeException handleIoException(IOException e) {
            throw new RuntimeException(e);
        }

        @Override
        public int size() {
            throw new UnsupportedOperationException("Not needed");
        }

        @Override
        public void force() {
            this.writeBufferToChannel();
        }

        private void writeBufferToChannel() {
            if (this.currentWindowIndex == -1L) {
                return;
            }
            try {
                this.writer.write(this.prepared(this.currentBuffer.getBuffer()), this.firstIdInWindow * (long)this.recordSize, this.bufferPool);
                this.currentBuffer = new Buffer(this, this.bufferPool.acquire());
                this.currentBuffer.reset();
                this.currentWindowIndex = -1L;
            }
            catch (IOException e) {
                throw this.handleIoException(e);
            }
        }

        private void readBufferFromChannel() {
            try {
                this.channel.read(this.prepared(this.currentBuffer.getBuffer()), this.firstIdInWindow * (long)this.recordSize);
            }
            catch (IOException e) {
                throw this.handleIoException(e);
            }
        }

        private ByteBuffer prepared(ByteBuffer buffer) {
            buffer.flip();
            buffer.limit((int)((this.lastIdInWindow - this.firstIdInWindow + 1L) * (long)this.recordSize));
            return buffer;
        }

        @Override
        public void close() {
            this.force();
        }
    }

    private class SingleWindowPool
    implements WindowPool {
        private final SingleWindow window;
        private final File storageFileName;

        public SingleWindowPool(File storageFileName, int recordSize, StoreChannel channel) {
            this.storageFileName = storageFileName;
            this.window = BatchingWindowPoolFactory.this.createSingleWindow(storageFileName, recordSize, channel);
            this.window.allocateBuffer();
            this.window.placeWindowFor(0L);
        }

        public String toString() {
            return this.storageFileName.getName();
        }

        @Override
        public PersistenceWindow acquire(long position, OperationType operationType) {
            return this.window.acquire(position, operationType);
        }

        @Override
        public void release(PersistenceWindow window) {
        }

        @Override
        public void flushAll() {
            this.window.force();
        }

        @Override
        public void close() {
            this.window.close();
        }

        @Override
        public WindowPoolStats getStats() {
            return null;
        }
    }

    public static enum Mode {
        APPEND_ONLY{

            @Override
            boolean canReadFrom(long windowIndex) {
                return windowIndex == 0L;
            }
        }
        ,
        UPDATE{

            @Override
            boolean canReadFrom(long windowIndex) {
                return true;
            }
        };


        abstract boolean canReadFrom(long var1);
    }

    public static interface Writer {
        public void write(ByteBuffer var1, long var2, SimplePool<ByteBuffer> var4) throws IOException;
    }

    public static interface WriterFactory {
        public Writer create(StoreChannel var1, Monitor var2);

        public void awaitEverythingWritten();

        public void shutdown();
    }
}

