/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.store.io;

import java.io.IOException;
import java.util.LinkedList;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import org.neo4j.unsafe.impl.batchimport.store.io.JobMonitor;
import org.neo4j.unsafe.impl.batchimport.store.io.WriteJob;

class WriteQueue
implements Callable<Void> {
    private final LinkedList<WriteJob> queue = new LinkedList();
    private final ExecutorService executor;
    private final JobMonitor jobMonitor;

    public WriteQueue(ExecutorService executor, JobMonitor jobMonitor) {
        this.executor = executor;
        this.jobMonitor = jobMonitor;
    }

    synchronized void offer(WriteJob job) {
        boolean wasEmpty = this.queue.isEmpty();
        this.queue.addLast(job);
        if (wasEmpty) {
            this.executor.submit(this);
            this.jobMonitor.jobQueued();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void call() throws IOException {
        try {
            for (WriteJob job : this.drain()) {
                job.execute();
            }
            Void void_ = null;
            return void_;
        }
        finally {
            this.jobMonitor.jobExecuted();
        }
    }

    synchronized WriteJob[] drain() {
        WriteJob[] result = new WriteJob[this.queue.size()];
        this.queue.toArray(result);
        this.queue.clear();
        return result;
    }
}

