/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb.factory;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.graphdb.security.URLAccessRule;
import org.neo4j.helpers.Service;
import org.neo4j.kernel.GraphDatabaseDependencies;
import org.neo4j.kernel.extension.KernelExtensionFactory;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacadeFactory;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.logging.LogProvider;

public class GraphDatabaseFactoryState {
    private final List<Class<?>> settingsClasses;
    private final List<KernelExtensionFactory<?>> kernelExtensions;
    private Monitors monitors;
    private LogProvider userLogProvider;
    private Map<String, URLAccessRule> urlAccessRules;

    public GraphDatabaseFactoryState() {
        this.settingsClasses = new ArrayList();
        this.settingsClasses.add(GraphDatabaseSettings.class);
        this.kernelExtensions = new ArrayList();
        for (KernelExtensionFactory factory : Service.load(KernelExtensionFactory.class)) {
            this.kernelExtensions.add(factory);
        }
        this.urlAccessRules = new HashMap<String, URLAccessRule>();
    }

    public GraphDatabaseFactoryState(GraphDatabaseFactoryState previous) {
        this.settingsClasses = new ArrayList(previous.settingsClasses);
        this.kernelExtensions = new ArrayList(previous.kernelExtensions);
        this.urlAccessRules = new HashMap<String, URLAccessRule>(previous.urlAccessRules);
        this.monitors = previous.monitors;
        this.monitors = previous.monitors;
        this.userLogProvider = previous.userLogProvider;
    }

    public Iterable<KernelExtensionFactory<?>> getKernelExtension() {
        return this.kernelExtensions;
    }

    public void setKernelExtensions(Iterable<KernelExtensionFactory<?>> newKernelExtensions) {
        this.kernelExtensions.clear();
        this.addKernelExtensions(newKernelExtensions);
    }

    public void addKernelExtensions(Iterable<KernelExtensionFactory<?>> newKernelExtensions) {
        for (KernelExtensionFactory<?> newKernelExtension : newKernelExtensions) {
            this.kernelExtensions.add(newKernelExtension);
        }
    }

    public void addURLAccessRule(String protocol, URLAccessRule rule) {
        this.urlAccessRules.put(protocol, rule);
    }

    public void setUserLogProvider(LogProvider userLogProvider) {
        this.userLogProvider = userLogProvider;
    }

    public void setMonitors(Monitors monitors) {
        this.monitors = monitors;
    }

    public GraphDatabaseFacadeFactory.Dependencies databaseDependencies() {
        return GraphDatabaseDependencies.newDependencies().monitors(this.monitors).userLogProvider(this.userLogProvider).settingsClasses(this.settingsClasses).urlAccessRules(this.urlAccessRules).kernelExtensions(this.kernelExtensions);
    }
}

