/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.store;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import org.neo4j.helpers.UTF8;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.kernel.impl.store.AbstractDynamicStore;
import org.neo4j.kernel.impl.store.DynamicArrayStore;
import org.neo4j.kernel.impl.store.DynamicStringStore;
import org.neo4j.kernel.impl.store.LongerShortString;
import org.neo4j.kernel.impl.store.PropertyType;
import org.neo4j.kernel.impl.store.ShortArray;
import org.neo4j.kernel.impl.store.UnderlyingStorageException;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.PropertyBlock;
import org.neo4j.kernel.impl.util.Bits;

class StorePropertyPayloadCursor {
    static final int MAX_NUMBER_OF_PAYLOAD_LONG_ARRAY = 4;
    private static final long PROPERTY_KEY_ID_BITMASK = 0xFFFFFFL;
    private static final int MAX_BYTES_IN_SHORT_STRING_OR_SHORT_ARRAY = 32;
    private static final int INTERNAL_BYTE_ARRAY_SIZE = 4096;
    private static final int INITIAL_POSITION = -1;
    private final ByteBuffer cachedBuffer;
    private final DynamicStringStore stringStore;
    private final DynamicArrayStore arrayStore;
    private AbstractDynamicStore.DynamicRecordCursor recordCursor;
    private ByteBuffer buffer;
    private final long[] data;
    private int position;

    StorePropertyPayloadCursor(DynamicStringStore stringStore, DynamicArrayStore arrayStore) {
        this.buffer = this.cachedBuffer = ByteBuffer.allocate(4096);
        this.data = new long[4];
        this.position = -1;
        this.stringStore = stringStore;
        this.arrayStore = arrayStore;
    }

    void init(PageCursor cursor) {
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i] = cursor.getLong();
        }
    }

    void clear() {
        this.position = -1;
        this.buffer = this.cachedBuffer;
        Arrays.fill(this.data, 0L);
    }

    boolean next() {
        this.position = this.position == -1 ? 0 : (this.position += this.currentBlocksUsed());
        if (this.position >= this.data.length) {
            return false;
        }
        return this.type() != null;
    }

    PropertyType type() {
        return PropertyType.getPropertyType(this.currentHeader(), true);
    }

    int propertyKeyId() {
        return (int)(this.currentHeader() & 0xFFFFFFL);
    }

    boolean booleanValue() {
        this.assertOfType(PropertyType.BOOL);
        return PropertyBlock.fetchByte(this.currentHeader()) == 1;
    }

    byte byteValue() {
        this.assertOfType(PropertyType.BYTE);
        return PropertyBlock.fetchByte(this.currentHeader());
    }

    short shortValue() {
        this.assertOfType(PropertyType.SHORT);
        return PropertyBlock.fetchShort(this.currentHeader());
    }

    char charValue() {
        this.assertOfType(PropertyType.CHAR);
        return (char)PropertyBlock.fetchShort(this.currentHeader());
    }

    int intValue() {
        this.assertOfType(PropertyType.INT);
        return PropertyBlock.fetchInt(this.currentHeader());
    }

    float floatValue() {
        this.assertOfType(PropertyType.FLOAT);
        return Float.intBitsToFloat(PropertyBlock.fetchInt(this.currentHeader()));
    }

    long longValue() {
        this.assertOfType(PropertyType.LONG);
        if (PropertyBlock.valueIsInlined(this.currentHeader())) {
            return PropertyBlock.fetchLong(this.currentHeader()) >>> 1;
        }
        return this.data[this.position + 1];
    }

    double doubleValue() {
        this.assertOfType(PropertyType.DOUBLE);
        return Double.longBitsToDouble(this.data[this.position + 1]);
    }

    String shortStringValue() {
        this.assertOfType(PropertyType.SHORT_STRING);
        Bits bits = this.valueAsBits();
        return LongerShortString.decode(bits);
    }

    String stringValue() {
        this.assertOfType(PropertyType.STRING);
        try {
            this.readFromStore(this.stringStore);
        }
        catch (IOException e) {
            throw new UnderlyingStorageException(e);
        }
        this.buffer.flip();
        return UTF8.decode(this.buffer.array(), 0, this.buffer.limit());
    }

    Object shortArrayValue() {
        this.assertOfType(PropertyType.SHORT_ARRAY);
        Bits bits = this.valueAsBits();
        return ShortArray.decode(bits);
    }

    Object arrayValue() {
        this.assertOfType(PropertyType.ARRAY);
        try {
            this.readFromStore(this.arrayStore);
        }
        catch (IOException e) {
            throw new UnderlyingStorageException(e);
        }
        this.buffer.flip();
        return StorePropertyPayloadCursor.readArrayFromBuffer(this.buffer);
    }

    private long currentHeader() {
        return this.data[this.position];
    }

    private int currentBlocksUsed() {
        return this.type().calculateNumberOfBlocksUsed(this.currentHeader());
    }

    private Bits valueAsBits() {
        Bits bits = Bits.bits(32);
        for (int i = 0; i < this.currentBlocksUsed(); ++i) {
            bits.put(this.data[this.position + i]);
        }
        return bits;
    }

    private void readFromStore(AbstractDynamicStore store) throws IOException {
        if (this.recordCursor == null) {
            this.recordCursor = store.newDynamicRecordCursor();
        }
        this.buffer.clear();
        long startBlockId = PropertyBlock.fetchLong(this.currentHeader());
        try (AbstractDynamicStore.DynamicRecordCursor records = store.getRecordsCursor(startBlockId, true, this.recordCursor);){
            while (records.next()) {
                DynamicRecord dynamicRecord = (DynamicRecord)records.get();
                byte[] data = dynamicRecord.getData();
                if (this.buffer.remaining() < data.length) {
                    this.buffer.flip();
                    ByteBuffer newBuffer = this.newBiggerBuffer(data.length);
                    newBuffer.put(this.buffer);
                    this.buffer = newBuffer;
                }
                this.buffer.put(data, 0, data.length);
            }
        }
    }

    private ByteBuffer newBiggerBuffer(int requiredCapacity) {
        int newCapacity;
        while ((newCapacity = this.buffer.capacity() * 2) - this.buffer.limit() < requiredCapacity) {
        }
        return ByteBuffer.allocate(newCapacity).order(ByteOrder.LITTLE_ENDIAN);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object readArrayFromBuffer(ByteBuffer buffer) {
        if (buffer.limit() <= 0) {
            throw new IllegalStateException("Given buffer is empty");
        }
        byte typeId = buffer.get();
        buffer.order(ByteOrder.BIG_ENDIAN);
        try {
            Object result;
            if (typeId == PropertyType.STRING.intValue()) {
                int arrayLength = buffer.getInt();
                String[] result2 = new String[arrayLength];
                for (int i = 0; i < arrayLength; ++i) {
                    int byteLength = buffer.getInt();
                    result2[i] = UTF8.decode(buffer.array(), buffer.position(), byteLength);
                    buffer.position(buffer.position() + byteLength);
                }
                String[] i = result2;
                return i;
            }
            ShortArray type = ShortArray.typeOf(typeId);
            byte bitsUsedInLastByte = buffer.get();
            byte requiredBits = buffer.get();
            if (requiredBits == 0) {
                Object byteLength = type.createEmptyArray();
                return byteLength;
            }
            if (type == ShortArray.BYTE && requiredBits == 8) {
                byte[] byteArray = new byte[buffer.limit() - buffer.position()];
                buffer.get(byteArray);
                result = byteArray;
            } else {
                Bits bits = Bits.bitsFromBytes(buffer.array(), buffer.position());
                int length = ((buffer.limit() - buffer.position()) * 8 - (8 - bitsUsedInLastByte)) / requiredBits;
                result = type.createArray(length, bits, requiredBits);
            }
            byte[] byArray = result;
            return byArray;
        }
        finally {
            buffer.order(ByteOrder.LITTLE_ENDIAN);
        }
    }

    private void assertOfType(PropertyType expected) {
        if (this.type() != expected) {
            throw new IllegalStateException("Expected type " + (Object)((Object)expected) + " but was " + (Object)((Object)this.type()));
        }
    }
}

