/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.query;

import org.neo4j.helpers.Service;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.kernel.impl.query.NoQueryEngine;
import org.neo4j.kernel.impl.query.QueryExecutionEngine;
import org.neo4j.kernel.impl.query.QuerySession;

public abstract class QueryEngineProvider
extends Service {
    public QueryEngineProvider(String name) {
        super(name, new String[0]);
    }

    protected abstract QueryExecutionEngine createEngine(GraphDatabaseAPI var1);

    public static QueryExecutionEngine initialize(GraphDatabaseAPI graphAPI, Iterable<QueryEngineProvider> providers) {
        QueryEngineProvider provider = null;
        for (QueryEngineProvider candidate : providers) {
            if (provider == null) {
                provider = candidate;
                continue;
            }
            throw new IllegalStateException("Too many query engines.");
        }
        if (provider == null) {
            return NoQueryEngine.INSTANCE;
        }
        return provider.createEngine(graphAPI);
    }

    public static QueryExecutionEngine noEngine() {
        return NoQueryEngine.INSTANCE;
    }

    public static QuerySession embeddedSession() {
        final Thread thread = Thread.currentThread();
        return new QuerySession(){

            @Override
            public String toString() {
                return String.format("EmbeddedSession{thread=%s}", thread.getName());
            }
        };
    }
}

