/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.index.util;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.kernel.api.index.util.FolderLayout;

public class FailureStorage {
    public static final int MAX_FAILURE_SIZE = 16384;
    public static final String DEFAULT_FAILURE_FILE_NAME = "failure-message";
    private final FileSystemAbstraction fs;
    private final FolderLayout folderLayout;
    private final String failureFileName;

    public FailureStorage(FileSystemAbstraction fs, FolderLayout folderLayout, String failureFileName) {
        this.fs = fs;
        this.folderLayout = folderLayout;
        this.failureFileName = failureFileName;
    }

    public FailureStorage(FileSystemAbstraction fs, FolderLayout folderLayout) {
        this(fs, folderLayout, DEFAULT_FAILURE_FILE_NAME);
    }

    public synchronized void reserveForIndex(long indexId) throws IOException {
        this.fs.mkdirs(this.folderLayout.getFolder(indexId));
        File failureFile = this.failureFile(indexId);
        try (StoreChannel channel = this.fs.create(failureFile);){
            channel.write(ByteBuffer.wrap(new byte[16384]));
            channel.force(true);
            channel.close();
        }
    }

    public synchronized void clearForIndex(long indexId) {
        this.fs.deleteFile(this.failureFile(indexId));
    }

    public synchronized String loadIndexFailure(long indexId) {
        File failureFile = this.failureFile(indexId);
        try {
            if (!this.fs.fileExists(failureFile) || !this.isFailed(failureFile)) {
                return null;
            }
            return this.readFailure(failureFile);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public synchronized void storeIndexFailure(long indexId, String failure) throws IOException {
        File failureFile = this.failureFile(indexId);
        try (StoreChannel channel = this.fs.open(failureFile, "rw");){
            byte[] data = failure.getBytes("utf-8");
            channel.write(ByteBuffer.wrap(data, 0, Math.min(data.length, 16384)));
            channel.force(true);
            channel.close();
        }
    }

    File failureFile(long indexId) {
        File folder = this.folderLayout.getFolder(indexId);
        return new File(folder, this.failureFileName);
    }

    private String readFailure(File failureFile) throws IOException {
        try (StoreChannel channel = this.fs.open(failureFile, "r");){
            byte[] data = new byte[(int)channel.size()];
            int readData = channel.read(ByteBuffer.wrap(data));
            channel.close();
            String string = readData <= 0 ? "" : new String(this.withoutZeros(data), "utf-8");
            return string;
        }
    }

    private byte[] withoutZeros(byte[] data) {
        byte[] result = new byte[this.lengthOf(data)];
        System.arraycopy(data, 0, result, 0, result.length);
        return result;
    }

    private int lengthOf(byte[] data) {
        for (int i = 0; i < data.length; ++i) {
            if (0 != data[i]) continue;
            return i;
        }
        return data.length;
    }

    private boolean isFailed(File failureFile) throws IOException {
        try (StoreChannel channel = this.fs.open(failureFile, "r");){
            byte[] data = new byte[(int)channel.size()];
            channel.read(ByteBuffer.wrap(data));
            channel.close();
            boolean bl = !this.allZero(data);
            return bl;
        }
    }

    private boolean allZero(byte[] data) {
        for (byte b : data) {
            if (b == 0) continue;
            return false;
        }
        return true;
    }
}

