/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb;

import java.util.Arrays;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicLong;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.helpers.ArrayUtil;
import org.neo4j.test.DatabaseRule;
import org.neo4j.test.EmbeddedDatabaseRule;
import org.neo4j.test.Race;

public class ConsistentPropertyReadsTest {
    @Rule
    public DatabaseRule db = new EmbeddedDatabaseRule(this.getClass());

    @Test
    public void shouldReadConsistentPropertyValues() throws Throwable {
        int i;
        final Node[] nodes = new Node[10];
        final String[] keys = new String[]{"1", "2", "3"};
        final String[] values = new String[]{this.longString('a'), this.longString('b'), this.longString('c')};
        try (Transaction tx = this.db.beginTx();){
            for (int i2 = 0; i2 < nodes.length; ++i2) {
                nodes[i2] = this.db.createNode();
                for (int j = 0; j < keys.length; ++j) {
                    nodes[i2].setProperty(keys[j], (Object)values[0]);
                }
            }
            tx.success();
        }
        int updaters = 10;
        final AtomicLong updatersDone = new AtomicLong(updaters);
        Race race = new Race();
        for (i = 0; i < updaters; ++i) {
            race.addContestant(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        ThreadLocalRandom random = ThreadLocalRandom.current();
                        for (int j = 0; j < 100; ++j) {
                            Node node = nodes[random.nextInt(nodes.length)];
                            String key = keys[random.nextInt(keys.length)];
                            try (Transaction tx = ConsistentPropertyReadsTest.this.db.beginTx();){
                                node.removeProperty(key);
                                tx.success();
                            }
                            tx = ConsistentPropertyReadsTest.this.db.beginTx();
                            var6_6 = null;
                            try {
                                node.setProperty(key, (Object)values[random.nextInt(values.length)]);
                                tx.success();
                                continue;
                            }
                            catch (Throwable throwable) {
                                var6_6 = throwable;
                                throw throwable;
                            }
                            finally {
                                if (tx != null) {
                                    if (var6_6 != null) {
                                        try {
                                            tx.close();
                                        }
                                        catch (Throwable x2) {
                                            var6_6.addSuppressed(x2);
                                        }
                                    } else {
                                        tx.close();
                                    }
                                }
                            }
                        }
                    }
                    finally {
                        updatersDone.decrementAndGet();
                    }
                }
            });
        }
        for (i = 0; i < 100; ++i) {
            race.addContestant(new Runnable(){

                @Override
                public void run() {
                    ThreadLocalRandom random = ThreadLocalRandom.current();
                    while (updatersDone.get() > 0L) {
                        Transaction tx = ConsistentPropertyReadsTest.this.db.beginTx();
                        Throwable throwable = null;
                        try {
                            String value = (String)nodes[random.nextInt(nodes.length)].getProperty(keys[random.nextInt(keys.length)], null);
                            Assert.assertTrue((String)value, (value == null || ArrayUtil.contains((Object[])values, (Object)value) ? 1 : 0) != 0);
                            tx.success();
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (tx == null) continue;
                            if (throwable != null) {
                                try {
                                    tx.close();
                                }
                                catch (Throwable x2) {
                                    throwable.addSuppressed(x2);
                                }
                                continue;
                            }
                            tx.close();
                        }
                    }
                }
            });
        }
        race.go();
    }

    private String longString(char c) {
        char[] chars = new char[ThreadLocalRandom.current().nextInt(800, 1000)];
        Arrays.fill(chars, c);
        return new String(chars);
    }
}

