/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb;

import org.junit.Test;
import org.neo4j.graphdb.AbstractMandatoryTransactionsTest;
import org.neo4j.graphdb.DynamicLabel;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.IndexDefinitionFacadeMethods;
import org.neo4j.graphdb.schema.IndexDefinition;

public class MandatoryTransactionsForIndexDefinitionTests
extends AbstractMandatoryTransactionsTest<IndexDefinition> {
    @Test
    public void shouldRequireTransactionsWhenCallingMethodsOnIndexDefinitions() throws Exception {
        MandatoryTransactionsForIndexDefinitionTests.assertFacadeMethodsThrowNotInTransaction(this.obtainEntity(), IndexDefinitionFacadeMethods.ALL_INDEX_DEFINITION_FACADE_METHODS);
    }

    @Test
    public void shouldTerminateWhenCallingMethodsOnIndexDefinitions() throws Exception {
        this.assertFacadeMethodsThrowAfterTerminate(IndexDefinitionFacadeMethods.ALL_INDEX_DEFINITION_FACADE_METHODS);
    }

    @Override
    protected IndexDefinition obtainEntityInTransaction(GraphDatabaseService graphDatabaseService) {
        return graphDatabaseService.schema().indexFor(DynamicLabel.label((String)"Label")).on("property").create();
    }
}

