/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb;

import java.io.File;
import java.io.IOException;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.TransactionFailureException;
import org.neo4j.helpers.Exceptions;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.impl.store.MetaDataStore;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.test.CleanupRule;
import org.neo4j.test.LimitedFileSystemGraphDatabase;
import org.neo4j.test.PageCacheRule;
import org.neo4j.test.TargetDirectory;

public class RunOutOfDiskSpaceIT {
    @Rule
    public final CleanupRule cleanup = new CleanupRule();
    @Rule
    public final TargetDirectory.TestDirectory testDirectory = TargetDirectory.testDirForTest(this.getClass());
    @Rule
    public final PageCacheRule pageCacheRule = new PageCacheRule();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldPropagateIOExceptions() throws Exception {
        TransactionFailureException exceptionThrown = null;
        String storeDir = this.testDirectory.absolutePath();
        LimitedFileSystemGraphDatabase db = new LimitedFileSystemGraphDatabase(storeDir);
        try (Transaction tx = db.beginTx();){
            db.createNode();
            tx.success();
        }
        long logVersion = ((NeoStores)db.getDependencyResolver().resolveDependency(NeoStores.class)).getMetaDataStore().getCurrentLogVersion();
        db.runOutOfDiskSpaceNao();
        try (Transaction tx = db.beginTx();){
            db.createNode();
            tx.success();
        }
        catch (TransactionFailureException e) {
            try {
                exceptionThrown = e;
            }
            catch (Throwable throwable) {
                Assert.assertNotNull((String)"Expected tx finish to throw TransactionFailureException when filesystem is full.", (Object)((Object)exceptionThrown));
                Assert.assertTrue((boolean)Exceptions.contains((Throwable)exceptionThrown, (Class[])new Class[]{IOException.class}));
                throw throwable;
            }
            Assert.assertNotNull((String)"Expected tx finish to throw TransactionFailureException when filesystem is full.", (Object)((Object)exceptionThrown));
            Assert.assertTrue((boolean)Exceptions.contains((Throwable)exceptionThrown, (Class[])new Class[]{IOException.class}));
        }
        Assert.assertNotNull((String)"Expected tx finish to throw TransactionFailureException when filesystem is full.", (Object)((Object)exceptionThrown));
        Assert.assertTrue((boolean)Exceptions.contains((Throwable)exceptionThrown, (Class[])new Class[]{IOException.class}));
        db.somehowGainMoreDiskSpace();
        db.shutdown();
        PageCache pageCache = this.pageCacheRule.getPageCache((FileSystemAbstraction)db.getFileSystem());
        File neoStore = new File(storeDir, "neostore");
        Assert.assertEquals((long)logVersion, (long)MetaDataStore.getRecord((PageCache)pageCache, (File)neoStore, (MetaDataStore.Position)MetaDataStore.Position.LOG_VERSION));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldStopDatabaseWhenOutOfDiskSpace() throws Exception {
        Throwable throwable;
        TransactionFailureException expectedCommitException = null;
        TransactionFailureException expectedStartException = null;
        String storeDir = this.testDirectory.absolutePath();
        LimitedFileSystemGraphDatabase db = this.cleanup.add(new LimitedFileSystemGraphDatabase(storeDir));
        try (Transaction tx = db.beginTx();){
            db.createNode();
            tx.success();
        }
        long logVersion = ((NeoStores)db.getDependencyResolver().resolveDependency(NeoStores.class)).getMetaDataStore().getCurrentLogVersion();
        db.runOutOfDiskSpaceNao();
        try {
            throwable = null;
            try (Transaction tx = db.beginTx();){
                db.createNode();
                tx.success();
            }
            catch (Throwable x2) {
                throwable = x2;
                throw x2;
            }
        }
        catch (TransactionFailureException e) {
            expectedCommitException = e;
        }
        finally {
            Assert.assertNotNull((String)"Expected tx finish to throw TransactionFailureException when filesystem is full.", (Object)((Object)expectedCommitException));
        }
        try {
            throwable = null;
            try (Transaction transaction = db.beginTx();){
                Assert.fail((String)"Expected tx begin to throw TransactionFailureException when tx manager breaks.");
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (TransactionFailureException e) {
            expectedStartException = e;
        }
        finally {
            Assert.assertNotNull((String)"Expected tx begin to throw TransactionFailureException when tx manager breaks.", (Object)((Object)expectedStartException));
        }
        db.somehowGainMoreDiskSpace();
        db.shutdown();
        PageCache pageCache = this.pageCacheRule.getPageCache((FileSystemAbstraction)db.getFileSystem());
        File neoStore = new File(storeDir, "neostore");
        Assert.assertEquals((long)logVersion, (long)MetaDataStore.getRecord((PageCache)pageCache, (File)neoStore, (MetaDataStore.Position)MetaDataStore.Position.LOG_VERSION));
    }
}

