/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.helpers;

import org.junit.Assert;
import org.junit.Test;
import org.neo4j.function.Predicate;
import org.neo4j.function.Predicates;
import org.neo4j.helpers.Exceptions;

public class TestExceptions {
    @Test
    public void canPeelExceptions() throws Exception {
        LevelThreeException expected = new LevelThreeException("include", new LevelFourException(""));
        LevelOneException exception = new LevelOneException("", new LevelTwoException("", new LevelThreeException("", expected)));
        Throwable peeled = Exceptions.peel((Throwable)exception, (Predicate)new Predicate<Throwable>(){

            public boolean test(Throwable item) {
                return !(item instanceof LevelThreeException) || !item.getMessage().contains("include");
            }
        });
        Assert.assertEquals((Object)expected, (Object)peeled);
    }

    @Test
    public void canPeelUsingConveniencePredicate() throws Exception {
        LevelThreeException expected = new LevelThreeException("", new LevelFourException(""));
        ARuntimeException exception = new ARuntimeException(new AnotherRuntimeException(new LevelFourException("", expected)));
        Throwable peeled = Exceptions.peel((Throwable)exception, (Predicate)Predicates.instanceOfAny((Class[])new Class[]{RuntimeException.class, LevelFourException.class}));
        Assert.assertEquals((Object)expected, (Object)peeled);
    }

    @Test
    public void shouldDetectContainsOneOfSome() throws Exception {
        ARuntimeException cause = new ARuntimeException(new AnotherRuntimeException(new NullPointerException("Some words")));
        Assert.assertTrue((boolean)Exceptions.contains((Throwable)cause, (Class[])new Class[]{NullPointerException.class}));
        Assert.assertTrue((boolean)Exceptions.contains((Throwable)cause, (String)"words", (Class[])new Class[]{NullPointerException.class}));
        Assert.assertFalse((boolean)Exceptions.contains((Throwable)cause, (String)"not", (Class[])new Class[]{NullPointerException.class}));
    }

    @Test
    public void shouldSetMessage() throws Exception {
        String initialMessage = "Initial message";
        LevelOneException exception = new LevelOneException(initialMessage);
        String prependedMessage = "Prepend this: " + exception.getMessage();
        Exceptions.withMessage((Throwable)exception, (String)prependedMessage);
        Assert.assertEquals((Object)prependedMessage, (Object)exception.getMessage());
    }

    @Test
    public void shouldAddSuppressedExceptions() {
        RuntimeException exception = new RuntimeException();
        RuntimeException suppressed1 = new RuntimeException();
        RuntimeException suppressed2 = new RuntimeException();
        RuntimeException result = (RuntimeException)Exceptions.withSuppressed((Throwable)exception, (Throwable[])new Throwable[]{suppressed1, suppressed2});
        Assert.assertSame((Object)exception, (Object)result);
        Assert.assertArrayEquals((Object[])new Throwable[]{suppressed1, suppressed2}, (Object[])result.getSuppressed());
    }

    private static class AnotherRuntimeException
    extends RuntimeException {
        public AnotherRuntimeException(Throwable cause) {
            super(cause);
        }
    }

    private static class ARuntimeException
    extends RuntimeException {
        public ARuntimeException(Throwable cause) {
            super(cause);
        }
    }

    private static class LevelFourException
    extends LevelThreeException {
        public LevelFourException(String message) {
            super(message);
        }

        public LevelFourException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    private static class LevelThreeException
    extends LevelTwoException {
        public LevelThreeException(String message) {
            super(message);
        }

        public LevelThreeException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    private static class LevelTwoException
    extends LevelOneException {
        public LevelTwoException(String message) {
            super(message);
        }

        public LevelTwoException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    private static class LevelOneException
    extends Exception {
        public LevelOneException(String message) {
            super(message);
        }

        public LevelOneException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

