/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.neo4j.kernel.CommunityIdTypeConfigurationProvider;
import org.neo4j.kernel.IdType;
import org.neo4j.kernel.IdTypeConfiguration;
import org.neo4j.kernel.IdTypeConfigurationProvider;

@RunWith(value=Parameterized.class)
public class CommunityIdTypeConfigurationProviderTest {
    private IdType reusableType;

    @Parameterized.Parameters
    public static List<Object[]> data() {
        return Arrays.asList({IdType.PROPERTY}, {IdType.STRING_BLOCK}, {IdType.ARRAY_BLOCK}, {IdType.NODE_LABELS});
    }

    public CommunityIdTypeConfigurationProviderTest(IdType reusableType) {
        this.reusableType = reusableType;
    }

    @Test
    public void nonReusableTypeConfiguration() {
        IdTypeConfigurationProvider provider = this.createIdTypeProvider();
        IdTypeConfiguration typeConfiguration = provider.getIdTypeConfiguration(IdType.RELATIONSHIP);
        Assert.assertFalse((String)"Relationship ids are not reusable.", (boolean)typeConfiguration.allowAggressiveReuse());
        Assert.assertEquals((String)"Relationship ids are not reusable.", (long)1024L, (long)typeConfiguration.getGrabSize());
    }

    @Test
    public void reusableTypeConfiguration() {
        IdTypeConfigurationProvider provider = this.createIdTypeProvider();
        IdTypeConfiguration typeConfiguration = provider.getIdTypeConfiguration(this.reusableType);
        Assert.assertTrue((boolean)typeConfiguration.allowAggressiveReuse());
        Assert.assertEquals((long)50000L, (long)typeConfiguration.getGrabSize());
    }

    private IdTypeConfigurationProvider createIdTypeProvider() {
        return new CommunityIdTypeConfigurationProvider();
    }
}

