/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.InOrder;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.neo4j.function.Consumer;
import org.neo4j.helpers.Pair;
import org.neo4j.helpers.collection.Visitor;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.RecoveryLabelScanWriterProvider;
import org.neo4j.kernel.impl.api.RecoveryLegacyIndexApplierLookup;
import org.neo4j.kernel.impl.api.TransactionRepresentationStoreApplier;
import org.neo4j.kernel.impl.api.index.RecoveryIndexingUpdatesValidator;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.transaction.CommittedTransactionRepresentation;
import org.neo4j.kernel.impl.transaction.DeadSimpleLogVersionRepository;
import org.neo4j.kernel.impl.transaction.DeadSimpleTransactionIdStore;
import org.neo4j.kernel.impl.transaction.command.CommandHandler;
import org.neo4j.kernel.impl.transaction.log.LogFile;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.LogPositionMarker;
import org.neo4j.kernel.impl.transaction.log.LogVersionRepository;
import org.neo4j.kernel.impl.transaction.log.LogVersionedStoreChannel;
import org.neo4j.kernel.impl.transaction.log.LogicalTransactionStore;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogFile;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogFiles;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogVersionedStoreChannel;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogicalTransactionStore;
import org.neo4j.kernel.impl.transaction.log.PhysicalWritableLogChannel;
import org.neo4j.kernel.impl.transaction.log.TransactionIdStore;
import org.neo4j.kernel.impl.transaction.log.TransactionMetadataCache;
import org.neo4j.kernel.impl.transaction.log.WritableLogChannel;
import org.neo4j.kernel.impl.transaction.log.entry.CheckPoint;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntry;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryReader;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryStart;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryVersion;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryWriter;
import org.neo4j.kernel.impl.transaction.log.entry.LogHeaderWriter;
import org.neo4j.kernel.impl.transaction.log.entry.OnePhaseCommit;
import org.neo4j.kernel.impl.transaction.log.entry.VersionAwareLogEntryReader;
import org.neo4j.kernel.impl.transaction.log.rotation.StoreFlusher;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.recovery.DefaultRecoverySPI;
import org.neo4j.kernel.recovery.LatestCheckPointFinder;
import org.neo4j.kernel.recovery.Recovery;
import org.neo4j.test.TargetDirectory;

public class RecoveryTest {
    private final FileSystemAbstraction fs = new DefaultFileSystemAbstraction();
    @Rule
    public final TargetDirectory.TestDirectory directory = TargetDirectory.testDirForTest(this.getClass());
    private final LogVersionRepository logVersionRepository = new DeadSimpleLogVersionRepository(1L);
    private final TransactionIdStore transactionIdStore = new DeadSimpleTransactionIdStore(5L, 0L, 0L, 0L, 0L);
    private final int logVersion = 0;
    private LogEntry lastCommittedTxStartEntry;
    private LogEntry lastCommittedTxCommitEntry;
    private LogEntry expectedStartEntry;
    private LogEntry expectedCommitEntry;
    private LogEntry expectedCheckPointEntry;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldRecoverExistingData() throws Exception {
        PhysicalLogFiles logFiles = new PhysicalLogFiles(this.directory.directory(), "log", this.fs);
        File file = logFiles.getLogFileForVersion(0L);
        this.writeSomeData(file, new Visitor<Pair<LogEntryWriter, Consumer<LogPositionMarker>>, IOException>(){

            public boolean visit(Pair<LogEntryWriter, Consumer<LogPositionMarker>> pair) throws IOException {
                LogEntryWriter writer = (LogEntryWriter)pair.first();
                Consumer consumer = (Consumer)pair.other();
                LogPositionMarker marker = new LogPositionMarker();
                consumer.accept((Object)marker);
                LogPosition lastCommittedTxPosition = marker.newPosition();
                writer.writeStartEntry(0, 1, 2L, 3L, new byte[0]);
                RecoveryTest.this.lastCommittedTxStartEntry = (LogEntry)new LogEntryStart(0, 1, 2L, 3L, new byte[0], lastCommittedTxPosition);
                writer.writeCommitEntry(4L, 5L);
                RecoveryTest.this.lastCommittedTxCommitEntry = (LogEntry)new OnePhaseCommit(4L, 5L);
                writer.writeCheckPointEntry(lastCommittedTxPosition);
                RecoveryTest.this.expectedCheckPointEntry = (LogEntry)new CheckPoint(lastCommittedTxPosition);
                consumer.accept((Object)marker);
                writer.writeStartEntry(0, 1, 6L, 4L, new byte[0]);
                RecoveryTest.this.expectedStartEntry = (LogEntry)new LogEntryStart(0, 1, 6L, 4L, new byte[0], marker.newPosition());
                writer.writeCommitEntry(5L, 7L);
                RecoveryTest.this.expectedCommitEntry = (LogEntry)new OnePhaseCommit(5L, 7L);
                return true;
            }
        });
        LifeSupport life = new LifeSupport();
        Recovery.Monitor monitor = (Recovery.Monitor)Mockito.mock(Recovery.Monitor.class);
        final AtomicBoolean recoveryRequired = new AtomicBoolean();
        try {
            RecoveryLabelScanWriterProvider provider = (RecoveryLabelScanWriterProvider)Mockito.mock(RecoveryLabelScanWriterProvider.class);
            RecoveryLegacyIndexApplierLookup lookup = (RecoveryLegacyIndexApplierLookup)Mockito.mock(RecoveryLegacyIndexApplierLookup.class);
            RecoveryIndexingUpdatesValidator validator = (RecoveryIndexingUpdatesValidator)Mockito.mock(RecoveryIndexingUpdatesValidator.class);
            StoreFlusher flusher = (StoreFlusher)Mockito.mock(StoreFlusher.class);
            VersionAwareLogEntryReader reader = new VersionAwareLogEntryReader(LogEntryVersion.CURRENT.byteCode());
            LatestCheckPointFinder finder = new LatestCheckPointFinder(logFiles, this.fs, (LogEntryReader)reader);
            TransactionMetadataCache metadataCache = new TransactionMetadataCache(10, 100);
            LogFile logFile = (LogFile)life.add((Lifecycle)new PhysicalLogFile(this.fs, logFiles, 50L, this.transactionIdStore, this.logVersionRepository, (PhysicalLogFile.Monitor)Mockito.mock(PhysicalLogFile.Monitor.class), metadataCache));
            PhysicalLogicalTransactionStore txStore = new PhysicalLogicalTransactionStore(logFile, metadataCache);
            TransactionRepresentationStoreApplier storeApplier = (TransactionRepresentationStoreApplier)Mockito.mock(TransactionRepresentationStoreApplier.class);
            life.add((Lifecycle)new Recovery((Recovery.SPI)new DefaultRecoverySPI(provider, lookup, flusher, (NeoStores)Mockito.mock(NeoStores.class), logFiles, this.fs, this.logVersionRepository, finder, validator, this.transactionIdStore, (LogicalTransactionStore)txStore, storeApplier){
                private int nr;
                {
                    super(x0, x1, x2, x3, x4, x5, x6, x7, x8, x9, x10, x11);
                    this.nr = 0;
                }

                public Visitor<CommittedTransactionRepresentation, Exception> startRecovery() {
                    recoveryRequired.set(true);
                    final Visitor actual = super.startRecovery();
                    return new Visitor<CommittedTransactionRepresentation, Exception>(){

                        public boolean visit(CommittedTransactionRepresentation tx) throws Exception {
                            actual.visit((Object)tx);
                            switch (nr++) {
                                case 0: {
                                    Assert.assertEquals((Object)RecoveryTest.this.lastCommittedTxStartEntry, (Object)tx.getStartEntry());
                                    Assert.assertEquals((Object)RecoveryTest.this.lastCommittedTxCommitEntry, (Object)tx.getCommitEntry());
                                    break;
                                }
                                case 1: {
                                    Assert.assertEquals((Object)RecoveryTest.this.expectedStartEntry, (Object)tx.getStartEntry());
                                    Assert.assertEquals((Object)RecoveryTest.this.expectedCommitEntry, (Object)tx.getCommitEntry());
                                    break;
                                }
                                default: {
                                    Assert.fail((String)"Too many recovered transactions");
                                }
                            }
                            return false;
                        }
                    };
                }
            }, monitor));
            life.start();
            InOrder order = Mockito.inOrder((Object[])new Object[]{monitor});
            ((Recovery.Monitor)order.verify((Object)monitor, Mockito.times((int)1))).recoveryRequired((LogPosition)Matchers.any(LogPosition.class));
            ((Recovery.Monitor)order.verify((Object)monitor, Mockito.times((int)1))).recoveryCompleted(2);
            Assert.assertTrue((boolean)recoveryRequired.get());
        }
        finally {
            life.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldSeeThatACleanDatabaseShouldNotRequireRecovery() throws Exception {
        PhysicalLogFiles logFiles = new PhysicalLogFiles(this.directory.directory(), "log", this.fs);
        File file = logFiles.getLogFileForVersion(0L);
        this.writeSomeData(file, new Visitor<Pair<LogEntryWriter, Consumer<LogPositionMarker>>, IOException>(){

            public boolean visit(Pair<LogEntryWriter, Consumer<LogPositionMarker>> pair) throws IOException {
                LogEntryWriter writer = (LogEntryWriter)pair.first();
                Consumer consumer = (Consumer)pair.other();
                LogPositionMarker marker = new LogPositionMarker();
                consumer.accept((Object)marker);
                writer.writeStartEntry(0, 1, 2L, 3L, new byte[0]);
                writer.writeCommitEntry(4L, 5L);
                consumer.accept((Object)marker);
                writer.writeCheckPointEntry(marker.newPosition());
                return true;
            }
        });
        LifeSupport life = new LifeSupport();
        Recovery.Monitor monitor = (Recovery.Monitor)Mockito.mock(Recovery.Monitor.class);
        try {
            RecoveryLabelScanWriterProvider provider = (RecoveryLabelScanWriterProvider)Mockito.mock(RecoveryLabelScanWriterProvider.class);
            RecoveryLegacyIndexApplierLookup lookup = (RecoveryLegacyIndexApplierLookup)Mockito.mock(RecoveryLegacyIndexApplierLookup.class);
            RecoveryIndexingUpdatesValidator validator = (RecoveryIndexingUpdatesValidator)Mockito.mock(RecoveryIndexingUpdatesValidator.class);
            StoreFlusher flusher = (StoreFlusher)Mockito.mock(StoreFlusher.class);
            VersionAwareLogEntryReader reader = new VersionAwareLogEntryReader(LogEntryVersion.CURRENT.byteCode());
            LatestCheckPointFinder finder = new LatestCheckPointFinder(logFiles, this.fs, (LogEntryReader)reader);
            TransactionMetadataCache metadataCache = new TransactionMetadataCache(10, 100);
            LogFile logFile = (LogFile)life.add((Lifecycle)new PhysicalLogFile(this.fs, logFiles, 50L, this.transactionIdStore, this.logVersionRepository, (PhysicalLogFile.Monitor)Mockito.mock(PhysicalLogFile.Monitor.class), metadataCache));
            PhysicalLogicalTransactionStore txStore = new PhysicalLogicalTransactionStore(logFile, metadataCache);
            TransactionRepresentationStoreApplier storeApplier = (TransactionRepresentationStoreApplier)Mockito.mock(TransactionRepresentationStoreApplier.class);
            life.add((Lifecycle)new Recovery((Recovery.SPI)new DefaultRecoverySPI(provider, lookup, flusher, (NeoStores)Mockito.mock(NeoStores.class), logFiles, this.fs, this.logVersionRepository, finder, validator, this.transactionIdStore, (LogicalTransactionStore)txStore, storeApplier){

                public Visitor<CommittedTransactionRepresentation, Exception> startRecovery() {
                    Assert.fail((String)"Recovery should not be required");
                    return null;
                }
            }, monitor));
            life.start();
            Mockito.verifyZeroInteractions((Object[])new Object[]{monitor});
        }
        finally {
            life.shutdown();
        }
    }

    @Test
    public void shouldTruncateLogAfterLastCompleteTransactionAfterSuccessfullRecovery() throws Exception {
        PhysicalLogFiles logFiles = new PhysicalLogFiles(this.directory.directory(), "log", this.fs);
        File file = logFiles.getLogFileForVersion(0L);
        final LogPositionMarker marker = new LogPositionMarker();
        this.writeSomeData(file, new Visitor<Pair<LogEntryWriter, Consumer<LogPositionMarker>>, IOException>(){

            public boolean visit(Pair<LogEntryWriter, Consumer<LogPositionMarker>> pair) throws IOException {
                LogEntryWriter writer = (LogEntryWriter)pair.first();
                Consumer consumer = (Consumer)pair.other();
                writer.writeStartEntry(0, 1, 2L, 3L, new byte[0]);
                writer.writeCommitEntry(4L, 5L);
                consumer.accept((Object)marker);
                writer.writeStartEntry(0, 1, 5L, 4L, new byte[0]);
                return true;
            }
        });
        boolean recoveryRequired = this.recover(logFiles);
        Assert.assertTrue((boolean)recoveryRequired);
        Assert.assertEquals((long)marker.getByteOffset(), (long)file.length());
    }

    @Test
    public void shouldTellTransactionIdStoreAfterSuccessfullRecovery() throws Exception {
        PhysicalLogFiles logFiles = new PhysicalLogFiles(this.directory.directory(), "log", this.fs);
        File file = logFiles.getLogFileForVersion(0L);
        final LogPositionMarker marker = new LogPositionMarker();
        final byte[] additionalHeaderData = new byte[]{};
        boolean masterId = false;
        boolean authorId = true;
        long transactionId = 4L;
        long commitTimestamp = 5L;
        this.writeSomeData(file, new Visitor<Pair<LogEntryWriter, Consumer<LogPositionMarker>>, IOException>(){

            public boolean visit(Pair<LogEntryWriter, Consumer<LogPositionMarker>> pair) throws IOException {
                LogEntryWriter writer = (LogEntryWriter)pair.first();
                Consumer consumer = (Consumer)pair.other();
                writer.writeStartEntry(0, 1, 2L, 3L, additionalHeaderData);
                writer.writeCommitEntry(4L, 5L);
                consumer.accept((Object)marker);
                return true;
            }
        });
        boolean recoveryRequired = this.recover(logFiles);
        Assert.assertTrue((boolean)recoveryRequired);
        long[] lastClosedTransaction = this.transactionIdStore.getLastClosedTransaction();
        Assert.assertEquals((long)4L, (long)lastClosedTransaction[0]);
        Assert.assertEquals((long)LogEntryStart.checksum((byte[])additionalHeaderData, (int)0, (int)1), (long)this.transactionIdStore.getLastCommittedTransaction().checksum());
        Assert.assertEquals((long)5L, (long)this.transactionIdStore.getLastCommittedTransaction().commitTimestamp());
        Assert.assertEquals((long)0L, (long)lastClosedTransaction[1]);
        Assert.assertEquals((long)marker.getByteOffset(), (long)lastClosedTransaction[2]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean recover(PhysicalLogFiles logFiles) {
        LifeSupport life = new LifeSupport();
        Recovery.Monitor monitor = (Recovery.Monitor)Mockito.mock(Recovery.Monitor.class);
        final AtomicBoolean recoveryRequired = new AtomicBoolean();
        try {
            RecoveryLabelScanWriterProvider provider = (RecoveryLabelScanWriterProvider)Mockito.mock(RecoveryLabelScanWriterProvider.class);
            RecoveryLegacyIndexApplierLookup lookup = (RecoveryLegacyIndexApplierLookup)Mockito.mock(RecoveryLegacyIndexApplierLookup.class);
            RecoveryIndexingUpdatesValidator validator = (RecoveryIndexingUpdatesValidator)Mockito.mock(RecoveryIndexingUpdatesValidator.class);
            StoreFlusher flusher = (StoreFlusher)Mockito.mock(StoreFlusher.class);
            VersionAwareLogEntryReader reader = new VersionAwareLogEntryReader(LogEntryVersion.CURRENT.byteCode());
            LatestCheckPointFinder finder = new LatestCheckPointFinder(logFiles, this.fs, (LogEntryReader)reader);
            TransactionMetadataCache metadataCache = new TransactionMetadataCache(10, 100);
            LogFile logFile = (LogFile)life.add((Lifecycle)new PhysicalLogFile(this.fs, logFiles, 50L, this.transactionIdStore, this.logVersionRepository, (PhysicalLogFile.Monitor)Mockito.mock(PhysicalLogFile.Monitor.class), metadataCache));
            PhysicalLogicalTransactionStore txStore = new PhysicalLogicalTransactionStore(logFile, metadataCache);
            TransactionRepresentationStoreApplier storeApplier = (TransactionRepresentationStoreApplier)Mockito.mock(TransactionRepresentationStoreApplier.class);
            life.add((Lifecycle)new Recovery((Recovery.SPI)new DefaultRecoverySPI(provider, lookup, flusher, (NeoStores)Mockito.mock(NeoStores.class), logFiles, this.fs, this.logVersionRepository, finder, validator, this.transactionIdStore, (LogicalTransactionStore)txStore, storeApplier){

                public Visitor<CommittedTransactionRepresentation, Exception> startRecovery() {
                    recoveryRequired.set(true);
                    return super.startRecovery();
                }
            }, monitor));
            life.start();
        }
        finally {
            life.shutdown();
        }
        return recoveryRequired.get();
    }

    private void writeSomeData(File file, Visitor<Pair<LogEntryWriter, Consumer<LogPositionMarker>>, IOException> visitor) throws IOException {
        try (PhysicalLogVersionedStoreChannel versionedStoreChannel = new PhysicalLogVersionedStoreChannel(this.fs.open(file, "rw"), 0L, 6);
             final PhysicalWritableLogChannel writableLogChannel = new PhysicalWritableLogChannel((LogVersionedStoreChannel)versionedStoreChannel);){
            LogHeaderWriter.writeLogHeader((WritableLogChannel)writableLogChannel, (long)0L, (long)2L);
            Consumer<LogPositionMarker> consumer = new Consumer<LogPositionMarker>(){

                public void accept(LogPositionMarker marker) {
                    try {
                        writableLogChannel.getCurrentPosition(marker);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            };
            LogEntryWriter first = new LogEntryWriter((WritableLogChannel)writableLogChannel, CommandHandler.EMPTY);
            visitor.visit((Object)Pair.of((Object)first, (Object)consumer));
        }
    }
}

