/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import com.google.common.collect.Iterators;
import java.util.Collection;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.neo4j.function.Predicate;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.traversal.Evaluation;
import org.neo4j.graphdb.traversal.Evaluator;
import org.neo4j.graphdb.traversal.TraversalBranch;
import org.neo4j.kernel.StandardBranchCollisionDetector;

public class StandardBranchCollisionDetectorTest {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Test
    public void testFilteredPathEvaluation() {
        PropertyContainer endNode = (PropertyContainer)Mockito.mock(Node.class);
        final PropertyContainer alternativeEndNode = (PropertyContainer)Mockito.mock(Node.class);
        final Node startNode = (Node)Mockito.mock(Node.class);
        Evaluator evaluator = (Evaluator)Mockito.mock(Evaluator.class);
        TraversalBranch branch = (TraversalBranch)Mockito.mock(TraversalBranch.class);
        TraversalBranch alternativeBranch = (TraversalBranch)Mockito.mock(TraversalBranch.class);
        Mockito.when((Object)branch.iterator()).thenAnswer((Answer)new IteratorAnswer(endNode));
        Mockito.when((Object)alternativeBranch.iterator()).thenAnswer((Answer)new IteratorAnswer(alternativeEndNode));
        Mockito.when((Object)alternativeBranch.startNode()).thenReturn((Object)startNode);
        Mockito.when((Object)evaluator.evaluate((Path)Mockito.any(Path.class))).thenReturn((Object)Evaluation.INCLUDE_AND_CONTINUE);
        StandardBranchCollisionDetector collisionDetector = new StandardBranchCollisionDetector(evaluator, (Predicate)new Predicate<Path>(){

            public boolean test(Path path) {
                return alternativeEndNode.equals(path.endNode()) && startNode.equals(path.startNode());
            }
        });
        Collection incoming = collisionDetector.evaluate(branch, Direction.INCOMING);
        Collection outgoing = collisionDetector.evaluate(branch, Direction.OUTGOING);
        Collection alternativeIncoming = collisionDetector.evaluate(alternativeBranch, Direction.INCOMING);
        Collection alternativeOutgoing = collisionDetector.evaluate(alternativeBranch, Direction.OUTGOING);
        Assert.assertThat((Object)incoming, (Matcher)Matchers.nullValue());
        Assert.assertThat((Object)outgoing, (Matcher)Matchers.nullValue());
        Assert.assertThat((Object)alternativeIncoming, (Matcher)Matchers.nullValue());
        Assert.assertThat((Object)alternativeOutgoing, (Matcher)Matchers.hasSize((int)1));
    }

    private static class IteratorAnswer
    implements Answer<Object> {
        private final PropertyContainer endNode;

        public IteratorAnswer(PropertyContainer endNode) {
            this.endNode = endNode;
        }

        public Object answer(InvocationOnMock invocation) throws Throwable {
            return Iterators.singletonIterator((Object)this.endNode);
        }
    }
}

