/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.index;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.kernel.api.exceptions.index.IndexCapacityExceededException;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.api.index.IndexConfiguration;
import org.neo4j.kernel.api.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.index.IndexProviderCompatibilityTestSuite;
import org.neo4j.kernel.api.index.IndexReader;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.api.index.NodePropertyUpdate;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.api.index.IndexUpdateMode;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingConfig;

public abstract class IndexAccessorCompatibility
extends IndexProviderCompatibilityTestSuite.Compatibility {
    protected IndexAccessor accessor;
    private static final int PROPERTY_KEY_ID = 100;
    private boolean isUnique = true;

    public IndexAccessorCompatibility(IndexProviderCompatibilityTestSuite testSuite, boolean isUnique) {
        super(testSuite);
        this.isUnique = isUnique;
    }

    @Before
    public void before() throws Exception {
        IndexConfiguration indexConfig = new IndexConfiguration(this.isUnique);
        IndexSamplingConfig indexSamplingConfig = new IndexSamplingConfig(new Config());
        IndexPopulator populator = this.indexProvider.getPopulator(17L, this.descriptor, indexConfig, indexSamplingConfig);
        populator.create();
        populator.close(true);
        this.accessor = this.indexProvider.getOnlineAccessor(17L, indexConfig, indexSamplingConfig);
    }

    @After
    public void after() throws IOException {
        this.accessor.drop();
        this.accessor.close();
    }

    @Test
    public void testIndexSeekByNumber() throws Exception {
        this.updateAndCommit(Arrays.asList(NodePropertyUpdate.add((long)1L, (int)100, (Object)-5, (long[])new long[]{1000L}), NodePropertyUpdate.add((long)2L, (int)100, (Object)0, (long[])new long[]{1000L}), NodePropertyUpdate.add((long)3L, (int)100, (Object)5.5, (long[])new long[]{1000L}), NodePropertyUpdate.add((long)4L, (int)100, (Object)10.0, (long[])new long[]{1000L}), NodePropertyUpdate.add((long)5L, (int)100, (Object)100.0, (long[])new long[]{1000L})));
        Assert.assertThat(this.getAllNodesFromInclusiveIndexSeekByNumber(0, 10), (Matcher)Matchers.equalTo(Arrays.asList(2L, 3L, 4L)));
        Assert.assertThat(this.getAllNodesFromInclusiveIndexSeekByNumber(10, null), (Matcher)Matchers.equalTo(Arrays.asList(4L, 5L)));
        Assert.assertThat(this.getAllNodesFromInclusiveIndexSeekByNumber(100, 0), (Matcher)Matchers.equalTo((Object)Collections.EMPTY_LIST));
        Assert.assertThat(this.getAllNodesFromInclusiveIndexSeekByNumber(null, 5.5), (Matcher)Matchers.equalTo(Arrays.asList(1L, 2L, 3L)));
        Assert.assertThat(this.getAllNodesFromInclusiveIndexSeekByNumber(null, null), (Matcher)Matchers.equalTo(Arrays.asList(1L, 2L, 3L, 4L, 5L)));
        Assert.assertThat(this.getAllNodesFromInclusiveIndexSeekByNumber(-5, 0), (Matcher)Matchers.equalTo(Arrays.asList(1L, 2L)));
        Assert.assertThat(this.getAllNodesFromInclusiveIndexSeekByNumber(-5, 5.5), (Matcher)Matchers.equalTo(Arrays.asList(1L, 2L, 3L)));
    }

    @Test
    public void testIndexSeekByString() throws Exception {
        this.updateAndCommit(Arrays.asList(NodePropertyUpdate.add((long)1L, (int)100, (Object)"Anabelle", (long[])new long[]{1000L}), NodePropertyUpdate.add((long)2L, (int)100, (Object)"Anna", (long[])new long[]{1000L}), NodePropertyUpdate.add((long)3L, (int)100, (Object)"Bob", (long[])new long[]{1000L}), NodePropertyUpdate.add((long)4L, (int)100, (Object)"Harriet", (long[])new long[]{1000L}), NodePropertyUpdate.add((long)5L, (int)100, (Object)"William", (long[])new long[]{1000L})));
        Assert.assertThat(this.getAllNodesFromIndexSeekByString("Anna", true, "Harriet", false), (Matcher)Matchers.equalTo(Arrays.asList(2L, 3L)));
        Assert.assertThat(this.getAllNodesFromIndexSeekByString("Harriet", true, null, false), (Matcher)Matchers.equalTo(Arrays.asList(4L, 5L)));
        Assert.assertThat(this.getAllNodesFromIndexSeekByString("Harriet", false, null, true), (Matcher)Matchers.equalTo(Collections.singletonList(5L)));
        Assert.assertThat(this.getAllNodesFromIndexSeekByString("William", false, "Anna", true), (Matcher)Matchers.equalTo((Object)Collections.EMPTY_LIST));
        Assert.assertThat(this.getAllNodesFromIndexSeekByString(null, false, "Bob", false), (Matcher)Matchers.equalTo(Arrays.asList(1L, 2L)));
        Assert.assertThat(this.getAllNodesFromIndexSeekByString(null, true, "Bob", true), (Matcher)Matchers.equalTo(Arrays.asList(1L, 2L, 3L)));
        Assert.assertThat(this.getAllNodesFromIndexSeekByString(null, true, null, true), (Matcher)Matchers.equalTo(Arrays.asList(1L, 2L, 3L, 4L, 5L)));
        Assert.assertThat(this.getAllNodesFromIndexSeekByString("Anabelle", false, "Anna", true), (Matcher)Matchers.equalTo(Collections.singletonList(2L)));
        Assert.assertThat(this.getAllNodesFromIndexSeekByString("Anabelle", false, "Bob", false), (Matcher)Matchers.equalTo(Collections.singletonList(2L)));
    }

    @Test
    public void testIndexSeekByPrefix() throws Exception {
        this.updateAndCommit(Arrays.asList(NodePropertyUpdate.add((long)1L, (int)100, (Object)"a", (long[])new long[]{1000L}), NodePropertyUpdate.add((long)2L, (int)100, (Object)"A", (long[])new long[]{1000L}), NodePropertyUpdate.add((long)3L, (int)100, (Object)"apa", (long[])new long[]{1000L}), NodePropertyUpdate.add((long)4L, (int)100, (Object)"apA", (long[])new long[]{1000L}), NodePropertyUpdate.add((long)5L, (int)100, (Object)"b", (long[])new long[]{1000L})));
        Assert.assertThat(this.getAllNodesFromIndexSeekByPrefix("a"), (Matcher)Matchers.equalTo(Arrays.asList(1L, 3L, 4L)));
        Assert.assertThat(this.getAllNodesFromIndexSeekByPrefix("A"), (Matcher)Matchers.equalTo(Arrays.asList(2L)));
        Assert.assertThat(this.getAllNodesFromIndexSeekByPrefix("ba"), (Matcher)Matchers.equalTo((Object)Collections.EMPTY_LIST));
        Assert.assertThat(this.getAllNodesFromIndexSeekByPrefix(""), (Matcher)Matchers.equalTo(Arrays.asList(1L, 2L, 3L, 4L, 5L)));
    }

    @Test
    public void testIndexSeekByPrefixOnNonStrings() throws Exception {
        this.updateAndCommit(Arrays.asList(NodePropertyUpdate.add((long)1L, (int)100, (Object)"a", (long[])new long[]{1000L}), NodePropertyUpdate.add((long)2L, (int)100, (Object)2L, (long[])new long[]{1000L})));
        Assert.assertThat(this.getAllNodesFromIndexSeekByPrefix("2"), (Matcher)Matchers.equalTo((Object)Collections.EMPTY_LIST));
    }

    protected List<Long> getAllNodesWithProperty(String propertyValue) throws IOException {
        try (IndexReader reader = this.accessor.newReader();){
            LinkedList<Long> list = new LinkedList<Long>();
            PrimitiveLongIterator iterator = reader.seek((Object)propertyValue);
            while (iterator.hasNext()) {
                list.add(iterator.next());
            }
            Collections.sort(list);
            LinkedList<Long> linkedList = list;
            return linkedList;
        }
    }

    protected List<Long> getAllNodesFromInclusiveIndexSeekByNumber(Number lower, Number upper) throws IOException {
        try (IndexReader reader = this.accessor.newReader();){
            LinkedList<Long> list = new LinkedList<Long>();
            PrimitiveLongIterator iterator = reader.rangeSeekByNumberInclusive(lower, upper);
            while (iterator.hasNext()) {
                list.add(iterator.next());
            }
            Collections.sort(list);
            LinkedList<Long> linkedList = list;
            return linkedList;
        }
    }

    protected List<Long> getAllNodesFromIndexSeekByString(String lower, boolean includeLower, String upper, boolean includeUpper) throws IOException {
        try (IndexReader reader = this.accessor.newReader();){
            LinkedList<Long> list = new LinkedList<Long>();
            PrimitiveLongIterator iterator = reader.rangeSeekByString(lower, includeLower, upper, includeUpper);
            while (iterator.hasNext()) {
                list.add(iterator.next());
            }
            Collections.sort(list);
            LinkedList<Long> linkedList = list;
            return linkedList;
        }
    }

    protected List<Long> getAllNodesFromIndexSeekByPrefix(String prefix) throws IOException {
        try (IndexReader reader = this.accessor.newReader();){
            LinkedList<Long> list = new LinkedList<Long>();
            PrimitiveLongIterator iterator = reader.rangeSeekByPrefix(prefix);
            while (iterator.hasNext()) {
                list.add(iterator.next());
            }
            Collections.sort(list);
            LinkedList<Long> linkedList = list;
            return linkedList;
        }
    }

    protected List<Long> getAllNodes() throws IOException {
        try (IndexReader reader = this.accessor.newReader();){
            LinkedList<Long> list = new LinkedList<Long>();
            PrimitiveLongIterator iterator = reader.scan();
            while (iterator.hasNext()) {
                list.add(iterator.next());
            }
            Collections.sort(list);
            LinkedList<Long> linkedList = list;
            return linkedList;
        }
    }

    protected void updateAndCommit(List<NodePropertyUpdate> updates) throws IOException, IndexEntryConflictException, IndexCapacityExceededException {
        try (IndexUpdater updater = this.accessor.newUpdater(IndexUpdateMode.ONLINE);){
            for (NodePropertyUpdate update : updates) {
                updater.process(update);
            }
        }
    }
}

