/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.configuration;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.graphdb.config.InvalidSettingException;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.helpers.Function;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.configuration.BaseConfigurationMigrator;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.configuration.ConfigurationChange;
import org.neo4j.kernel.configuration.ConfigurationChangeListener;
import org.neo4j.kernel.configuration.ConfigurationMigrator;
import org.neo4j.kernel.configuration.Migrator;
import org.neo4j.kernel.configuration.Settings;

public class TestConfig {
    private <T> Set<T> setOf(T ... objs) {
        HashSet set = new HashSet();
        Collections.addAll(set, objs);
        return set;
    }

    @Test
    public void shouldApplyDefaults() {
        Config config = new Config(new HashMap(), new Class[]{MySettingsWithDefaults.class});
        Assert.assertThat((Object)config.get(MySettingsWithDefaults.hello), (Matcher)CoreMatchers.is((Object)"Hello, World!"));
    }

    @Test
    public void shouldApplyMigrations() {
        Config config = new Config(MapUtil.stringMap((String[])new String[]{"old", "hello!"}), new Class[]{MyMigratingSettings.class});
        Assert.assertThat((Object)config.get(MyMigratingSettings.newer), (Matcher)CoreMatchers.is((Object)"hello!"));
    }

    @Test(expected=InvalidSettingException.class)
    public void shouldNotAllowSettingInvalidValues() {
        Config config = new Config(new HashMap(), new Class[]{MySettingsWithDefaults.class});
        Map params = config.getParams();
        params.put(MySettingsWithDefaults.boolSetting.name(), "asd");
        config.applyChanges(params);
        Assert.fail((String)"Expected validation to fail.");
    }

    @Test(expected=InvalidSettingException.class)
    public void shouldNotAllowInvalidValuesInConstructor() {
        new Config(MapUtil.stringMap((String[])new String[]{MySettingsWithDefaults.boolSetting.name(), "asd"}), new Class[]{MySettingsWithDefaults.class});
        Assert.fail((String)"Expected validation to fail.");
    }

    @Test
    public void shouldNotifyChangeListenersWhenNewSettingsAreApplied() {
        Config config = new Config(MapUtil.stringMap((String[])new String[]{"setting", "old"}), new Class[]{MyMigratingSettings.class});
        ChangeCaptureListener listener = new ChangeCaptureListener();
        config.addConfigurationChangeListener((ConfigurationChangeListener)listener);
        config.applyChanges(MapUtil.stringMap((String[])new String[]{"setting", "new"}));
        Assert.assertThat((Object)listener.lastChangeSet, (Matcher)CoreMatchers.is(this.setOf(new ConfigurationChange("setting", "old", "new"))));
    }

    @Test
    public void shouldNotNotifyChangeListenerWhenNothingChanged() {
        Config config = new Config(MapUtil.stringMap((String[])new String[]{"setting", "old"}), new Class[]{MyMigratingSettings.class});
        ChangeCaptureListener listener = new ChangeCaptureListener();
        config.addConfigurationChangeListener((ConfigurationChangeListener)listener);
        config.applyChanges(MapUtil.stringMap((String[])new String[]{"setting", "old"}));
        Assert.assertThat((Object)listener.lastChangeSet, (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void settingNewPropertyMustNotAlterExistingSettings() {
        Config config = new Config(MapUtil.stringMap((String[])new String[]{"a", "1"}));
        config.setProperty("b", (Object)"2");
        Assert.assertThat((Object)config.getParams(), (Matcher)CoreMatchers.is((Object)MapUtil.stringMap((String[])new String[]{"a", "1", "b", "2"})));
    }

    @Test
    public void shouldBeAbleToRegisterSettingsClassesAfterInstantiation() throws Exception {
        Config config = new Config(MapUtil.stringMap((String[])new String[]{"old", "hello!"}));
        config.registerSettingsClasses(Arrays.asList(MySettingsWithDefaults.class, MyMigratingSettings.class));
        Assert.assertThat((Object)config.get(MyMigratingSettings.newer), (Matcher)Matchers.equalTo((Object)"hello!"));
        Assert.assertThat((Object)config.get(MySettingsWithDefaults.hello), (Matcher)Matchers.equalTo((Object)"Hello, World!"));
    }

    @Test
    public void shouldBeAbleToAgumentConfig() throws Exception {
        Config config = new Config(MapUtil.stringMap((String[])new String[]{"newer", "old", "non-overlapping", "huzzah"}));
        config.augment(MapUtil.stringMap((String[])new String[]{"newer", "new", "unrelated", "hello"}));
        Assert.assertThat((Object)config.get(Settings.setting((String)"newer", (Function)Settings.STRING, (String)"")), (Matcher)Matchers.equalTo((Object)"new"));
        Assert.assertThat((Object)config.get(Settings.setting((String)"non-overlapping", (Function)Settings.STRING, (String)"")), (Matcher)Matchers.equalTo((Object)"huzzah"));
        Assert.assertThat((Object)config.get(Settings.setting((String)"unrelated", (Function)Settings.STRING, (String)"")), (Matcher)Matchers.equalTo((Object)"hello"));
    }

    private class ChangeCaptureListener
    implements ConfigurationChangeListener {
        private Set<ConfigurationChange> lastChangeSet;

        private ChangeCaptureListener() {
        }

        public void notifyConfigurationChanges(Iterable<ConfigurationChange> change) {
            this.lastChangeSet = new HashSet<ConfigurationChange>();
            for (ConfigurationChange ch : change) {
                this.lastChangeSet.add(ch);
            }
        }
    }

    public static class MySettingsWithDefaults {
        public static Setting<String> hello = Settings.setting((String)"hello", (Function)Settings.STRING, (String)"Hello, World!");
        public static Setting<Boolean> boolSetting = Settings.setting((String)"bool_setting", (Function)Settings.BOOLEAN, (String)"true");
    }

    public static class MyMigratingSettings {
        @Migrator
        public static ConfigurationMigrator migrator = new BaseConfigurationMigrator(){
            {
                this.add((BaseConfigurationMigrator.Migration)new BaseConfigurationMigrator.SpecificPropertyMigration("old", "Old has been replaced by newer!"){

                    public void setValueWithOldSetting(String value, Map<String, String> rawConfiguration) {
                        rawConfiguration.put(newer.name(), value);
                    }
                });
            }
        };
        public static Setting<String> newer = Settings.setting((String)"newer", (Function)Settings.STRING, (String)"");
    }
}

