/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.util.Iterator;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsInstanceOf;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.exceptions.schema.AlreadyConstrainedException;
import org.neo4j.kernel.api.exceptions.schema.AlreadyIndexedException;
import org.neo4j.kernel.api.exceptions.schema.DropIndexFailureException;
import org.neo4j.kernel.api.exceptions.schema.IllegalTokenNameException;
import org.neo4j.kernel.api.exceptions.schema.IndexBelongsToConstraintException;
import org.neo4j.kernel.api.exceptions.schema.NoSuchIndexException;
import org.neo4j.kernel.api.exceptions.schema.ProcedureConstraintViolation;
import org.neo4j.kernel.api.exceptions.schema.SchemaKernelException;
import org.neo4j.kernel.api.index.IndexDescriptor;
import org.neo4j.kernel.api.procedures.ProcedureDescriptor;
import org.neo4j.kernel.api.procedures.ProcedureSignature;
import org.neo4j.kernel.impl.api.DataIntegrityValidatingStatementOperations;
import org.neo4j.kernel.impl.api.KernelStatement;
import org.neo4j.kernel.impl.api.StatementOperationsTestHelper;
import org.neo4j.kernel.impl.api.operations.KeyWriteOperations;
import org.neo4j.kernel.impl.api.operations.SchemaReadOperations;
import org.neo4j.kernel.impl.api.operations.SchemaWriteOperations;

public class DataIntegrityValidatingStatementOperationsTest {
    @Rule
    public ExpectedException exception = ExpectedException.none();
    private final KernelStatement state = StatementOperationsTestHelper.mockedState();

    @Test
    public void shouldDisallowReAddingIndex() throws Exception {
        int label = 0;
        int propertyKey = 7;
        IndexDescriptor rule = new IndexDescriptor(label, propertyKey);
        SchemaReadOperations innerRead = (SchemaReadOperations)Mockito.mock(SchemaReadOperations.class);
        SchemaWriteOperations innerWrite = (SchemaWriteOperations)Mockito.mock(SchemaWriteOperations.class);
        DataIntegrityValidatingStatementOperations ctx = new DataIntegrityValidatingStatementOperations(null, innerRead, innerWrite);
        Mockito.when((Object)innerRead.indexesGetForLabel(this.state, rule.getLabelId())).thenAnswer(DataIntegrityValidatingStatementOperationsTest.withIterator(rule));
        try {
            ctx.indexCreate(this.state, label, propertyKey);
            Assert.fail((String)"Should have thrown exception.");
        }
        catch (AlreadyIndexedException alreadyIndexedException) {
            // empty catch block
        }
        ((SchemaWriteOperations)Mockito.verify((Object)innerWrite, (VerificationMode)Mockito.never())).indexCreate((KernelStatement)Matchers.eq((Object)this.state), Matchers.anyInt(), Matchers.anyInt());
    }

    @Test
    public void shouldDisallowAddingIndexWhenConstraintIndexExists() throws Exception {
        int label = 0;
        int propertyKey = 7;
        IndexDescriptor rule = new IndexDescriptor(label, propertyKey);
        SchemaReadOperations innerRead = (SchemaReadOperations)Mockito.mock(SchemaReadOperations.class);
        SchemaWriteOperations innerWrite = (SchemaWriteOperations)Mockito.mock(SchemaWriteOperations.class);
        DataIntegrityValidatingStatementOperations ctx = new DataIntegrityValidatingStatementOperations(null, innerRead, innerWrite);
        Mockito.when((Object)innerRead.indexesGetForLabel(this.state, rule.getLabelId())).thenAnswer(DataIntegrityValidatingStatementOperationsTest.withIterator(new Object[0]));
        Mockito.when((Object)innerRead.uniqueIndexesGetForLabel(this.state, rule.getLabelId())).thenAnswer(DataIntegrityValidatingStatementOperationsTest.withIterator(rule));
        try {
            ctx.indexCreate(this.state, label, propertyKey);
            Assert.fail((String)"Should have thrown exception.");
        }
        catch (AlreadyConstrainedException alreadyConstrainedException) {
            // empty catch block
        }
        ((SchemaWriteOperations)Mockito.verify((Object)innerWrite, (VerificationMode)Mockito.never())).indexCreate((KernelStatement)Matchers.eq((Object)this.state), Matchers.anyInt(), Matchers.anyInt());
    }

    @Test
    public void shouldDisallowDroppingIndexThatDoesNotExist() throws Exception {
        int label = 0;
        int propertyKey = 7;
        IndexDescriptor indexDescriptor = new IndexDescriptor(label, propertyKey);
        SchemaReadOperations innerRead = (SchemaReadOperations)Mockito.mock(SchemaReadOperations.class);
        SchemaWriteOperations innerWrite = (SchemaWriteOperations)Mockito.mock(SchemaWriteOperations.class);
        DataIntegrityValidatingStatementOperations ctx = new DataIntegrityValidatingStatementOperations(null, innerRead, innerWrite);
        Mockito.when((Object)innerRead.uniqueIndexesGetForLabel(this.state, indexDescriptor.getLabelId())).thenAnswer(DataIntegrityValidatingStatementOperationsTest.withIterator(new Object[0]));
        Mockito.when((Object)innerRead.indexesGetForLabel(this.state, indexDescriptor.getLabelId())).thenAnswer(DataIntegrityValidatingStatementOperationsTest.withIterator(new Object[0]));
        try {
            ctx.indexDrop(this.state, indexDescriptor);
            Assert.fail((String)"Should have thrown exception.");
        }
        catch (DropIndexFailureException e) {
            Assert.assertThat((Object)e.getCause(), (Matcher)IsInstanceOf.instanceOf(NoSuchIndexException.class));
        }
        ((SchemaWriteOperations)Mockito.verify((Object)innerWrite, (VerificationMode)Mockito.never())).indexCreate((KernelStatement)Matchers.eq((Object)this.state), Matchers.anyInt(), Matchers.anyInt());
    }

    @Test
    public void shouldDisallowDroppingIndexWhenConstraintIndexExists() throws Exception {
        int label = 0;
        int propertyKey = 7;
        IndexDescriptor indexDescriptor = new IndexDescriptor(label, propertyKey);
        SchemaReadOperations innerRead = (SchemaReadOperations)Mockito.mock(SchemaReadOperations.class);
        SchemaWriteOperations innerWrite = (SchemaWriteOperations)Mockito.mock(SchemaWriteOperations.class);
        DataIntegrityValidatingStatementOperations ctx = new DataIntegrityValidatingStatementOperations(null, innerRead, innerWrite);
        Mockito.when((Object)innerRead.uniqueIndexesGetForLabel(this.state, indexDescriptor.getLabelId())).thenAnswer(DataIntegrityValidatingStatementOperationsTest.withIterator(indexDescriptor));
        Mockito.when((Object)innerRead.indexesGetForLabel(this.state, indexDescriptor.getLabelId())).thenAnswer(DataIntegrityValidatingStatementOperationsTest.withIterator(new Object[0]));
        try {
            ctx.indexDrop(this.state, new IndexDescriptor(label, propertyKey));
            Assert.fail((String)"Should have thrown exception.");
        }
        catch (DropIndexFailureException e) {
            Assert.assertThat((Object)e.getCause(), (Matcher)IsInstanceOf.instanceOf(IndexBelongsToConstraintException.class));
        }
        ((SchemaWriteOperations)Mockito.verify((Object)innerWrite, (VerificationMode)Mockito.never())).indexCreate((KernelStatement)Matchers.eq((Object)this.state), Matchers.anyInt(), Matchers.anyInt());
    }

    @Test
    public void shouldDisallowDroppingConstraintIndexThatDoesNotExists() throws Exception {
        int label = 0;
        int propertyKey = 7;
        IndexDescriptor indexDescriptor = new IndexDescriptor(label, propertyKey);
        SchemaReadOperations innerRead = (SchemaReadOperations)Mockito.mock(SchemaReadOperations.class);
        SchemaWriteOperations innerWrite = (SchemaWriteOperations)Mockito.mock(SchemaWriteOperations.class);
        DataIntegrityValidatingStatementOperations ctx = new DataIntegrityValidatingStatementOperations(null, innerRead, innerWrite);
        Mockito.when((Object)innerRead.uniqueIndexesGetForLabel(this.state, indexDescriptor.getLabelId())).thenAnswer(DataIntegrityValidatingStatementOperationsTest.withIterator(indexDescriptor));
        Mockito.when((Object)innerRead.indexesGetForLabel(this.state, indexDescriptor.getLabelId())).thenAnswer(DataIntegrityValidatingStatementOperationsTest.withIterator(new Object[0]));
        try {
            ctx.indexDrop(this.state, new IndexDescriptor(label, propertyKey));
            Assert.fail((String)"Should have thrown exception.");
        }
        catch (DropIndexFailureException e) {
            Assert.assertThat((Object)e.getCause(), (Matcher)IsInstanceOf.instanceOf(IndexBelongsToConstraintException.class));
        }
        ((SchemaWriteOperations)Mockito.verify((Object)innerWrite, (VerificationMode)Mockito.never())).indexCreate((KernelStatement)Matchers.eq((Object)this.state), Matchers.anyInt(), Matchers.anyInt());
    }

    @Test
    public void shouldDisallowDroppingConstraintIndexThatIsReallyJustRegularIndex() throws Exception {
        int label = 0;
        int propertyKey = 7;
        IndexDescriptor indexDescriptor = new IndexDescriptor(label, propertyKey);
        SchemaReadOperations innerRead = (SchemaReadOperations)Mockito.mock(SchemaReadOperations.class);
        SchemaWriteOperations innerWrite = (SchemaWriteOperations)Mockito.mock(SchemaWriteOperations.class);
        DataIntegrityValidatingStatementOperations ctx = new DataIntegrityValidatingStatementOperations(null, innerRead, innerWrite);
        Mockito.when((Object)innerRead.uniqueIndexesGetForLabel(this.state, indexDescriptor.getLabelId())).thenAnswer(DataIntegrityValidatingStatementOperationsTest.withIterator(indexDescriptor));
        Mockito.when((Object)innerRead.indexesGetForLabel(this.state, indexDescriptor.getLabelId())).thenAnswer(DataIntegrityValidatingStatementOperationsTest.withIterator(new Object[0]));
        try {
            ctx.indexDrop(this.state, new IndexDescriptor(label, propertyKey));
            Assert.fail((String)"Should have thrown exception.");
        }
        catch (DropIndexFailureException e) {
            Assert.assertThat((Object)e.getCause(), (Matcher)IsInstanceOf.instanceOf(IndexBelongsToConstraintException.class));
        }
        ((SchemaWriteOperations)Mockito.verify((Object)innerWrite, (VerificationMode)Mockito.never())).indexCreate((KernelStatement)Matchers.eq((Object)this.state), Matchers.anyInt(), Matchers.anyInt());
    }

    @Test
    public void shouldDisallowNullOrEmptyPropertyKey() throws Exception {
        KeyWriteOperations inner = (KeyWriteOperations)Mockito.mock(KeyWriteOperations.class);
        DataIntegrityValidatingStatementOperations ctx = new DataIntegrityValidatingStatementOperations(inner, null, null);
        try {
            ctx.propertyKeyGetOrCreateForName((Statement)this.state, null);
            Assert.fail((String)"Should not be able to create null property key");
        }
        catch (IllegalTokenNameException illegalTokenNameException) {
            // empty catch block
        }
        try {
            ctx.propertyKeyGetOrCreateForName((Statement)this.state, "");
            Assert.fail((String)"Should not be able to create empty property key");
        }
        catch (IllegalTokenNameException illegalTokenNameException) {
            // empty catch block
        }
    }

    @Test
    public void shouldDisallowNullOrEmptyLabelName() throws Exception {
        KeyWriteOperations inner = (KeyWriteOperations)Mockito.mock(KeyWriteOperations.class);
        DataIntegrityValidatingStatementOperations ctx = new DataIntegrityValidatingStatementOperations(inner, null, null);
        try {
            ctx.labelGetOrCreateForName((Statement)this.state, null);
            Assert.fail((String)"Should not be able to create null label");
        }
        catch (IllegalTokenNameException illegalTokenNameException) {
            // empty catch block
        }
        try {
            ctx.labelGetOrCreateForName((Statement)this.state, "");
            Assert.fail((String)"Should not be able to create empty label");
        }
        catch (IllegalTokenNameException illegalTokenNameException) {
            // empty catch block
        }
    }

    @Test(expected=SchemaKernelException.class)
    public void shouldFailInvalidLabelNames() throws Exception {
        DataIntegrityValidatingStatementOperations ctx = new DataIntegrityValidatingStatementOperations(null, null, null);
        ctx.labelGetOrCreateForName((Statement)this.state, "");
    }

    @Test(expected=SchemaKernelException.class)
    public void shouldFailOnNullLabel() throws Exception {
        DataIntegrityValidatingStatementOperations ctx = new DataIntegrityValidatingStatementOperations(null, null, null);
        ctx.labelGetOrCreateForName((Statement)this.state, null);
    }

    @Test
    public void shouldNotAllowCreatingProcedureWithConflictingName() throws Throwable {
        ProcedureSignature signature = ProcedureSignature.procedureSignature((String[])new String[]{"my.procedure"}).build();
        SchemaReadOperations readOps = (SchemaReadOperations)Mockito.mock(SchemaReadOperations.class);
        Mockito.when((Object)readOps.procedureGet(this.state, signature.name())).thenReturn(Mockito.mock(ProcedureDescriptor.class));
        DataIntegrityValidatingStatementOperations ops = new DataIntegrityValidatingStatementOperations(null, readOps, null);
        this.exception.expect(ProcedureConstraintViolation.class);
        ops.procedureCreate(this.state, signature, "jakescript", "woo");
    }

    @SafeVarargs
    private static <T> Answer<Iterator<T>> withIterator(final T ... content) {
        return new Answer<Iterator<T>>(){

            public Iterator<T> answer(InvocationOnMock invocationOnMock) throws Throwable {
                return IteratorUtil.iterator((Object[])content);
            }
        };
    }
}

