/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.concurrent.locks.LockSupport;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.neo4j.helpers.Clock;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.api.KernelTransactions;
import org.neo4j.kernel.impl.api.KernelTransactionsSnapshot;
import org.neo4j.kernel.impl.api.TransactionApplicationMode;
import org.neo4j.kernel.impl.api.TransactionCommitProcess;
import org.neo4j.kernel.impl.api.TransactionHooks;
import org.neo4j.kernel.impl.api.store.ProcedureCache;
import org.neo4j.kernel.impl.api.store.StoreReadLayer;
import org.neo4j.kernel.impl.api.store.StoreStatement;
import org.neo4j.kernel.impl.constraints.ConstraintSemantics;
import org.neo4j.kernel.impl.locking.LockGroup;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.impl.locking.SimpleStatementLocksFactory;
import org.neo4j.kernel.impl.locking.StatementLocksFactory;
import org.neo4j.kernel.impl.store.MetaDataStore;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.TransactionId;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.transaction.TransactionHeaderInformationFactory;
import org.neo4j.kernel.impl.transaction.TransactionMonitor;
import org.neo4j.kernel.impl.transaction.TransactionRepresentation;
import org.neo4j.kernel.impl.transaction.state.IntegrityValidator;
import org.neo4j.kernel.impl.transaction.state.NeoStoreTransactionContext;
import org.neo4j.kernel.impl.transaction.state.NeoStoreTransactionContextFactory;
import org.neo4j.kernel.impl.transaction.state.RecordAccess;
import org.neo4j.kernel.impl.transaction.tracing.CommitEvent;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.monitoring.tracing.Tracers;
import org.neo4j.logging.Log;
import org.neo4j.logging.NullLog;
import org.neo4j.test.Race;

public class KernelTransactionsTest {
    @Test
    public void shouldListActiveTransactions() throws Exception {
        KernelTransactions registry = KernelTransactionsTest.newKernelTransactions();
        KernelTransaction first = registry.newInstance();
        KernelTransaction second = registry.newInstance();
        KernelTransaction third = registry.newInstance();
        first.close();
        Assert.assertThat((Object)IteratorUtil.asUniqueSet((Iterable)registry.activeTransactions()), (Matcher)CoreMatchers.equalTo((Object)IteratorUtil.asSet((Object[])new KernelTransaction[]{second, third})));
    }

    @Test
    public void shouldDisposeTransactionsWhenAsked() throws Exception {
        KernelTransactions registry = KernelTransactionsTest.newKernelTransactions();
        registry.disposeAll();
        KernelTransaction first = registry.newInstance();
        KernelTransaction second = registry.newInstance();
        KernelTransaction leftOpen = registry.newInstance();
        first.close();
        second.close();
        registry.disposeAll();
        KernelTransaction postDispose = registry.newInstance();
        Assert.assertThat((Object)postDispose, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)first)));
        Assert.assertThat((Object)postDispose, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)second)));
        Assert.assertTrue((leftOpen.getReasonIfTerminated() != null ? 1 : 0) != 0);
    }

    @Test
    public void shouldIncludeRandomBytesInAdditionalHeader() throws TransactionFailureException {
        TransactionRepresentation[] transactionRepresentation = new TransactionRepresentation[1];
        KernelTransactions registry = KernelTransactionsTest.newKernelTransactions(KernelTransactionsTest.newRememberingCommitProcess(transactionRepresentation), KernelTransactionsTest.newMockContextFactoryWithChanges());
        KernelTransaction transaction = registry.newInstance();
        transaction.success();
        transaction.close();
        byte[] additionalHeader = transactionRepresentation[0].additionalHeader();
        Assert.assertNotNull((Object)additionalHeader);
        Assert.assertTrue((additionalHeader.length > 0 ? 1 : 0) != 0);
    }

    @Test
    public void shouldReuseClosedTransactionObjects() throws Exception {
        KernelTransactions transactions = KernelTransactionsTest.newKernelTransactions();
        KernelTransaction a = transactions.newInstance();
        a.close();
        KernelTransaction b = transactions.newInstance();
        Assert.assertSame((Object)a, (Object)b);
    }

    @Test
    public void shouldTellWhenTransactionsFromSnapshotHaveBeenClosed() throws Exception {
        KernelTransactions transactions = KernelTransactionsTest.newKernelTransactions();
        KernelTransaction a = transactions.newInstance();
        KernelTransaction b = transactions.newInstance();
        KernelTransaction c = transactions.newInstance();
        KernelTransactionsSnapshot snapshot = transactions.get();
        Assert.assertFalse((boolean)snapshot.allClosed());
        a.close();
        Assert.assertFalse((boolean)snapshot.allClosed());
        c.close();
        KernelTransaction d = transactions.newInstance();
        Assert.assertFalse((boolean)snapshot.allClosed());
        b.close();
        Assert.assertTrue((boolean)snapshot.allClosed());
    }

    @Test
    public void shouldBeAbleToSnapshotDuringHeavyLoad() throws Throwable {
        final KernelTransactions transactions = KernelTransactionsTest.newKernelTransactions();
        Race race = new Race();
        int threads = 50;
        final AtomicBoolean end = new AtomicBoolean();
        final AtomicReferenceArray snapshots = new AtomicReferenceArray(50);
        int i = 0;
        while (i < 50) {
            final int threadIndex = i++;
            race.addContestant(new Runnable(){

                @Override
                public void run() {
                    ThreadLocalRandom random = ThreadLocalRandom.current();
                    while (!end.get()) {
                        try {
                            KernelTransaction transaction = transactions.newInstance();
                            Throwable throwable = null;
                            try {
                                LockSupport.parkNanos(TimeUnit.MILLISECONDS.toNanos(random.nextInt(3)));
                                if (snapshots.get(threadIndex) != null) continue;
                                snapshots.set(threadIndex, transactions.get());
                                LockSupport.parkNanos(TimeUnit.MILLISECONDS.toNanos(random.nextInt(3)));
                            }
                            catch (Throwable throwable2) {
                                throwable = throwable2;
                                throw throwable2;
                            }
                            finally {
                                if (transaction == null) continue;
                                if (throwable != null) {
                                    try {
                                        transaction.close();
                                    }
                                    catch (Throwable x2) {
                                        throwable.addSuppressed(x2);
                                    }
                                    continue;
                                }
                                transaction.close();
                            }
                        }
                        catch (TransactionFailureException e) {
                            throw new RuntimeException(e);
                        }
                    }
                }
            });
        }
        race.addContestant(new Runnable(){

            @Override
            public void run() {
                ThreadLocalRandom random = ThreadLocalRandom.current();
                int snapshotsLeft = 1000;
                while (snapshotsLeft > 0) {
                    int threadIndex = random.nextInt(50);
                    KernelTransactionsSnapshot snapshot = (KernelTransactionsSnapshot)snapshots.get(threadIndex);
                    if (snapshot == null || !snapshot.allClosed()) continue;
                    --snapshotsLeft;
                    snapshots.set(threadIndex, null);
                }
                end.set(true);
            }
        });
        race.go();
    }

    @Test
    public void threadThatBlocksNewTxsCantStartNewTxs() throws Exception {
        KernelTransactions kernelTransactions = KernelTransactionsTest.newKernelTransactions();
        kernelTransactions.blockNewTransactions();
        try {
            kernelTransactions.newInstance();
            Assert.fail((String)"Exception expected");
        }
        catch (Exception e) {
            Assert.assertThat((Object)e, (Matcher)CoreMatchers.instanceOf(IllegalStateException.class));
        }
    }

    @Test
    public void blockNewTransactions() throws Exception {
        KernelTransactions kernelTransactions = KernelTransactionsTest.newKernelTransactions();
        kernelTransactions.blockNewTransactions();
        CountDownLatch aboutToStartTx = new CountDownLatch(1);
        Future<KernelTransaction> txOpener = KernelTransactionsTest.startTxInSeparateThread(kernelTransactions, aboutToStartTx);
        this.await(aboutToStartTx);
        KernelTransactionsTest.assertNotDone(txOpener);
        kernelTransactions.unblockNewTransactions();
        Assert.assertNotNull((Object)txOpener.get(2L, TimeUnit.SECONDS));
    }

    @Test
    public void unblockNewTransactionsFromWrongThreadThrows() throws Exception {
        KernelTransactions kernelTransactions = KernelTransactionsTest.newKernelTransactions();
        kernelTransactions.blockNewTransactions();
        CountDownLatch aboutToStartTx = new CountDownLatch(1);
        Future<KernelTransaction> txOpener = KernelTransactionsTest.startTxInSeparateThread(kernelTransactions, aboutToStartTx);
        this.await(aboutToStartTx);
        KernelTransactionsTest.assertNotDone(txOpener);
        Future<?> wrongUnblocker = KernelTransactionsTest.unblockTxsInSeparateThread(kernelTransactions);
        try {
            wrongUnblocker.get(2L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            Assert.assertThat((Object)e, (Matcher)CoreMatchers.instanceOf(ExecutionException.class));
            Assert.assertThat((Object)e.getCause(), (Matcher)CoreMatchers.instanceOf(IllegalStateException.class));
        }
        KernelTransactionsTest.assertNotDone(txOpener);
        kernelTransactions.unblockNewTransactions();
        Assert.assertNotNull((Object)txOpener.get(2L, TimeUnit.SECONDS));
    }

    private static KernelTransactions newKernelTransactions() {
        return KernelTransactionsTest.newKernelTransactions((TransactionCommitProcess)Mockito.mock(TransactionCommitProcess.class), KernelTransactionsTest.newMockContextFactory());
    }

    private static KernelTransactions newKernelTransactions(TransactionCommitProcess commitProcess, NeoStoreTransactionContextFactory contextSupplier) {
        LifeSupport life = new LifeSupport();
        life.start();
        Locks locks = (Locks)Mockito.mock(Locks.class);
        Mockito.when((Object)locks.newClient()).thenReturn(Mockito.mock(Locks.Client.class));
        StoreReadLayer readLayer = (StoreReadLayer)Mockito.mock(StoreReadLayer.class);
        Mockito.when((Object)readLayer.acquireStatement()).thenReturn(Mockito.mock(StoreStatement.class));
        NeoStores neoStores = (NeoStores)Mockito.mock(NeoStores.class);
        MetaDataStore metaDataStore = (MetaDataStore)Mockito.mock(MetaDataStore.class);
        Mockito.when((Object)metaDataStore.getLastCommittedTransaction()).thenReturn((Object)new TransactionId(2L, 3L, 4L));
        Mockito.when((Object)neoStores.getMetaDataStore()).thenReturn((Object)metaDataStore);
        return new KernelTransactions(contextSupplier, neoStores, (StatementLocksFactory)new SimpleStatementLocksFactory(locks), (IntegrityValidator)Mockito.mock(IntegrityValidator.class), null, null, null, null, null, null, null, TransactionHeaderInformationFactory.DEFAULT, readLayer, commitProcess, null, null, new TransactionHooks(), (ConstraintSemantics)Mockito.mock(ConstraintSemantics.class), (TransactionMonitor)Mockito.mock(TransactionMonitor.class), life, new ProcedureCache(), new Config(), new Tracers("null", (Log)NullLog.getInstance()), Clock.SYSTEM_CLOCK);
    }

    private static TransactionCommitProcess newRememberingCommitProcess(final TransactionRepresentation[] slot) throws TransactionFailureException {
        TransactionCommitProcess commitProcess = (TransactionCommitProcess)Mockito.mock(TransactionCommitProcess.class);
        Mockito.when((Object)commitProcess.commit((TransactionRepresentation)Matchers.any(TransactionRepresentation.class), (LockGroup)Matchers.any(LockGroup.class), (CommitEvent)Matchers.any(CommitEvent.class), (TransactionApplicationMode)Matchers.any(TransactionApplicationMode.class))).then((Answer)new Answer<Long>(){

            public Long answer(InvocationOnMock invocation) throws Throwable {
                slot[0] = (TransactionRepresentation)invocation.getArguments()[0];
                return 1L;
            }
        });
        return commitProcess;
    }

    private static NeoStoreTransactionContextFactory newMockContextFactory() {
        NeoStoreTransactionContextFactory factory = (NeoStoreTransactionContextFactory)Mockito.mock(NeoStoreTransactionContextFactory.class);
        NeoStoreTransactionContext context = (NeoStoreTransactionContext)Mockito.mock(NeoStoreTransactionContext.class, (Answer)Mockito.RETURNS_MOCKS);
        Mockito.when((Object)factory.newInstance()).thenReturn((Object)context);
        return factory;
    }

    private static NeoStoreTransactionContextFactory newMockContextFactoryWithChanges() {
        NeoStoreTransactionContextFactory factory = (NeoStoreTransactionContextFactory)Mockito.mock(NeoStoreTransactionContextFactory.class);
        NeoStoreTransactionContext context = (NeoStoreTransactionContext)Mockito.mock(NeoStoreTransactionContext.class, (Answer)Mockito.RETURNS_MOCKS);
        Mockito.when((Object)context.hasChanges()).thenReturn((Object)true);
        RecordAccess recordChanges = (RecordAccess)Mockito.mock(RecordAccess.class);
        Mockito.when((Object)recordChanges.changeSize()).thenReturn((Object)1);
        RecordAccess.RecordProxy recordChange = (RecordAccess.RecordProxy)Mockito.mock(RecordAccess.RecordProxy.class);
        Mockito.when((Object)recordChange.forReadingLinkage()).thenReturn((Object)new NodeRecord(1L, false, 1L, 1L));
        Mockito.when((Object)recordChanges.changes()).thenReturn((Object)Iterables.option((Object)recordChange));
        Mockito.when((Object)context.getNodeRecords()).thenReturn((Object)recordChanges);
        Mockito.when((Object)factory.newInstance()).thenReturn((Object)context);
        return factory;
    }

    private static Future<KernelTransaction> startTxInSeparateThread(final KernelTransactions kernelTransactions, final CountDownLatch aboutToStartTx) {
        return Executors.newSingleThreadExecutor().submit(new Callable<KernelTransaction>(){

            @Override
            public KernelTransaction call() {
                aboutToStartTx.countDown();
                return kernelTransactions.newInstance();
            }
        });
    }

    private static Future<?> unblockTxsInSeparateThread(final KernelTransactions kernelTransactions) {
        return Executors.newSingleThreadExecutor().submit(new Runnable(){

            @Override
            public void run() {
                kernelTransactions.unblockNewTransactions();
            }
        });
    }

    private void await(CountDownLatch latch) throws InterruptedException {
        Assert.assertTrue((boolean)latch.await(1L, TimeUnit.MINUTES));
    }

    private static void assertNotDone(Future<?> future) {
        try {
            future.get(2L, TimeUnit.SECONDS);
            Assert.fail((String)"Exception expected");
        }
        catch (Exception e) {
            Assert.assertThat((Object)e, (Matcher)CoreMatchers.instanceOf(TimeoutException.class));
        }
    }
}

