/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.util.Collections;
import java.util.Iterator;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.InOrder;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.neo4j.function.Function;
import org.neo4j.function.Functions;
import org.neo4j.graphdb.Direction;
import org.neo4j.kernel.api.constraints.NodePropertyConstraint;
import org.neo4j.kernel.api.constraints.UniquenessConstraint;
import org.neo4j.kernel.api.cursor.NodeItem;
import org.neo4j.kernel.api.cursor.RelationshipItem;
import org.neo4j.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.kernel.api.exceptions.KernelException;
import org.neo4j.kernel.api.index.IndexDescriptor;
import org.neo4j.kernel.api.properties.DefinedProperty;
import org.neo4j.kernel.api.properties.Property;
import org.neo4j.kernel.api.txstate.LegacyIndexTransactionState;
import org.neo4j.kernel.api.txstate.TransactionState;
import org.neo4j.kernel.api.txstate.TxStateHolder;
import org.neo4j.kernel.impl.api.KernelStatement;
import org.neo4j.kernel.impl.api.KernelTransactionImplementation;
import org.neo4j.kernel.impl.api.LockingStatementOperations;
import org.neo4j.kernel.impl.api.RelationshipVisitor;
import org.neo4j.kernel.impl.api.operations.EntityReadOperations;
import org.neo4j.kernel.impl.api.operations.EntityWriteOperations;
import org.neo4j.kernel.impl.api.operations.SchemaReadOperations;
import org.neo4j.kernel.impl.api.operations.SchemaStateOperations;
import org.neo4j.kernel.impl.api.operations.SchemaWriteOperations;
import org.neo4j.kernel.impl.api.state.StubCursors;
import org.neo4j.kernel.impl.api.state.TxState;
import org.neo4j.kernel.impl.api.store.CursorRelationshipIterator;
import org.neo4j.kernel.impl.api.store.RelationshipIterator;
import org.neo4j.kernel.impl.api.store.StoreSingleNodeCursor;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.impl.locking.ResourceTypes;
import org.neo4j.kernel.impl.locking.SimpleStatementLocks;
import org.neo4j.kernel.impl.locking.StatementLocks;
import org.neo4j.kernel.impl.util.Cursors;

public class LockingStatementOperationsTest {
    private final LockingStatementOperations lockingOps;
    private final EntityReadOperations entityReadOps;
    private final EntityWriteOperations entityWriteOps;
    private final SchemaReadOperations schemaReadOps;
    private final SchemaWriteOperations schemaWriteOps;
    private final Locks.Client locks = (Locks.Client)Mockito.mock(Locks.Client.class);
    private final InOrder order;
    private final KernelTransactionImplementation transaction = (KernelTransactionImplementation)Mockito.mock(KernelTransactionImplementation.class);
    private final TxState txState = new TxState();
    private final KernelStatement state = new KernelStatement(this.transaction, null, null, (TxStateHolder)new SimpleTxStateHolder(this.txState), (StatementLocks)new SimpleStatementLocks(this.locks), null, null);
    private final SchemaStateOperations schemaStateOps;

    public LockingStatementOperationsTest() {
        this.entityReadOps = (EntityReadOperations)Mockito.mock(EntityReadOperations.class);
        this.entityWriteOps = (EntityWriteOperations)Mockito.mock(EntityWriteOperations.class);
        this.schemaReadOps = (SchemaReadOperations)Mockito.mock(SchemaReadOperations.class);
        this.schemaWriteOps = (SchemaWriteOperations)Mockito.mock(SchemaWriteOperations.class);
        this.schemaStateOps = (SchemaStateOperations)Mockito.mock(SchemaStateOperations.class);
        this.order = Mockito.inOrder((Object[])new Object[]{this.locks, this.entityWriteOps, this.schemaReadOps, this.schemaWriteOps, this.schemaStateOps});
        this.lockingOps = new LockingStatementOperations(this.entityReadOps, this.entityWriteOps, this.schemaReadOps, this.schemaWriteOps, this.schemaStateOps);
    }

    @Test
    public void shouldAcquireEntityWriteLockBeforeAddingLabelToNode() throws Exception {
        this.lockingOps.nodeAddLabel(this.state, 123L, 456);
        ((Locks.Client)this.order.verify((Object)this.locks)).acquireExclusive((Locks.ResourceType)ResourceTypes.NODE, new long[]{123L});
        ((EntityWriteOperations)this.order.verify((Object)this.entityWriteOps)).nodeAddLabel(this.state, 123L, 456);
    }

    @Test
    public void shouldNotAcquireEntityWriteLockBeforeAddingLabelToJustCreatedNode() throws Exception {
        this.txState.nodeDoCreate(123L);
        this.lockingOps.nodeAddLabel(this.state, 123L, 456);
        ((Locks.Client)this.order.verify((Object)this.locks, Mockito.never())).acquireExclusive((Locks.ResourceType)ResourceTypes.NODE, new long[]{123L});
        ((EntityWriteOperations)this.order.verify((Object)this.entityWriteOps)).nodeAddLabel(this.state, 123L, 456);
    }

    @Test
    public void shouldAcquireSchemaReadLockBeforeAddingLabelToNode() throws Exception {
        this.lockingOps.nodeAddLabel(this.state, 123L, 456);
        ((Locks.Client)this.order.verify((Object)this.locks)).acquireShared((Locks.ResourceType)ResourceTypes.SCHEMA, new long[]{ResourceTypes.schemaResource()});
        ((EntityWriteOperations)this.order.verify((Object)this.entityWriteOps)).nodeAddLabel(this.state, 123L, 456);
    }

    @Test
    public void shouldAcquireEntityWriteLockBeforeSettingPropertyOnNode() throws Exception {
        DefinedProperty property = Property.property((int)8, (Object)9);
        this.lockingOps.nodeSetProperty(this.state, 123L, property);
        ((Locks.Client)this.order.verify((Object)this.locks)).acquireExclusive((Locks.ResourceType)ResourceTypes.NODE, new long[]{123L});
        ((EntityWriteOperations)this.order.verify((Object)this.entityWriteOps)).nodeSetProperty(this.state, 123L, property);
    }

    @Test
    public void shouldNotAcquireEntityWriteLockBeforeSettingPropertyOnJustCreatedNode() throws Exception {
        this.txState.nodeDoCreate(123L);
        DefinedProperty property = Property.property((int)8, (Object)9);
        this.lockingOps.nodeSetProperty(this.state, 123L, property);
        ((Locks.Client)this.order.verify((Object)this.locks, Mockito.never())).acquireExclusive((Locks.ResourceType)ResourceTypes.NODE, new long[]{123L});
        ((EntityWriteOperations)this.order.verify((Object)this.entityWriteOps)).nodeSetProperty(this.state, 123L, property);
    }

    @Test
    public void shouldAcquireSchemaReadLockBeforeSettingPropertyOnNode() throws Exception {
        DefinedProperty property = Property.property((int)8, (Object)9);
        this.lockingOps.nodeSetProperty(this.state, 123L, property);
        ((Locks.Client)this.order.verify((Object)this.locks)).acquireShared((Locks.ResourceType)ResourceTypes.SCHEMA, new long[]{ResourceTypes.schemaResource()});
        ((EntityWriteOperations)this.order.verify((Object)this.entityWriteOps)).nodeSetProperty(this.state, 123L, property);
    }

    @Test
    public void shouldAcquireEntityWriteLockBeforeDeletingNode() throws EntityNotFoundException {
        this.lockingOps.nodeDelete(this.state, 123L);
        ((Locks.Client)this.order.verify((Object)this.locks)).acquireExclusive((Locks.ResourceType)ResourceTypes.NODE, new long[]{123L});
        ((EntityWriteOperations)this.order.verify((Object)this.entityWriteOps)).nodeDelete(this.state, 123L);
    }

    @Test
    public void shouldNotAcquireEntityWriteLockBeforeDeletingJustCreatedNode() throws EntityNotFoundException {
        this.txState.nodeDoCreate(123L);
        this.lockingOps.nodeDelete(this.state, 123L);
        ((Locks.Client)this.order.verify((Object)this.locks, Mockito.never())).acquireExclusive((Locks.ResourceType)ResourceTypes.NODE, new long[]{123L});
        ((EntityWriteOperations)this.order.verify((Object)this.entityWriteOps)).nodeDelete(this.state, 123L);
    }

    @Test
    public void shouldAcquireSchemaWriteLockBeforeAddingIndexRule() throws Exception {
        IndexDescriptor rule = (IndexDescriptor)Mockito.mock(IndexDescriptor.class);
        Mockito.when((Object)this.schemaWriteOps.indexCreate(this.state, 123, 456)).thenReturn((Object)rule);
        IndexDescriptor result = this.lockingOps.indexCreate(this.state, 123, 456);
        Assert.assertSame((Object)rule, (Object)result);
        ((Locks.Client)this.order.verify((Object)this.locks)).acquireExclusive((Locks.ResourceType)ResourceTypes.SCHEMA, new long[]{ResourceTypes.schemaResource()});
        ((SchemaWriteOperations)this.order.verify((Object)this.schemaWriteOps)).indexCreate(this.state, 123, 456);
    }

    @Test
    public void shouldAcquireSchemaWriteLockBeforeRemovingIndexRule() throws Exception {
        IndexDescriptor rule = new IndexDescriptor(0, 0);
        this.lockingOps.indexDrop(this.state, rule);
        ((Locks.Client)this.order.verify((Object)this.locks)).acquireExclusive((Locks.ResourceType)ResourceTypes.SCHEMA, new long[]{ResourceTypes.schemaResource()});
        ((SchemaWriteOperations)this.order.verify((Object)this.schemaWriteOps)).indexDrop(this.state, rule);
    }

    @Test
    public void shouldAcquireSchemaReadLockBeforeGettingIndexRules() throws Exception {
        Iterator rules = Collections.emptyIterator();
        Mockito.when((Object)this.schemaReadOps.indexesGetAll(this.state)).thenReturn(rules);
        Iterator result = this.lockingOps.indexesGetAll(this.state);
        Assert.assertSame(rules, (Object)result);
        ((Locks.Client)this.order.verify((Object)this.locks)).acquireShared((Locks.ResourceType)ResourceTypes.SCHEMA, new long[]{ResourceTypes.schemaResource()});
        ((SchemaReadOperations)this.order.verify((Object)this.schemaReadOps)).indexesGetAll(this.state);
    }

    @Test
    public void shouldAcquireSchemaWriteLockBeforeCreatingUniquenessConstraint() throws Exception {
        UniquenessConstraint constraint = new UniquenessConstraint(0, 0);
        Mockito.when((Object)this.schemaWriteOps.uniquePropertyConstraintCreate(this.state, 123, 456)).thenReturn((Object)constraint);
        UniquenessConstraint result = this.lockingOps.uniquePropertyConstraintCreate(this.state, 123, 456);
        Assert.assertSame((Object)constraint, (Object)result);
        ((Locks.Client)this.order.verify((Object)this.locks)).acquireExclusive((Locks.ResourceType)ResourceTypes.SCHEMA, new long[]{ResourceTypes.schemaResource()});
        ((SchemaWriteOperations)this.order.verify((Object)this.schemaWriteOps)).uniquePropertyConstraintCreate(this.state, 123, 456);
    }

    @Test
    public void shouldAcquireSchemaWriteLockBeforeDroppingConstraint() throws Exception {
        UniquenessConstraint constraint = new UniquenessConstraint(1, 2);
        this.lockingOps.constraintDrop(this.state, (NodePropertyConstraint)constraint);
        ((Locks.Client)this.order.verify((Object)this.locks)).acquireExclusive((Locks.ResourceType)ResourceTypes.SCHEMA, new long[]{ResourceTypes.schemaResource()});
        ((SchemaWriteOperations)this.order.verify((Object)this.schemaWriteOps)).constraintDrop(this.state, (NodePropertyConstraint)constraint);
    }

    @Test
    public void shouldAcquireSchemaReadLockBeforeGettingConstraintsByLabelAndProperty() throws Exception {
        Iterator constraints = Collections.emptyIterator();
        Mockito.when((Object)this.schemaReadOps.constraintsGetForLabelAndPropertyKey(this.state, 123, 456)).thenReturn(constraints);
        Iterator result = this.lockingOps.constraintsGetForLabelAndPropertyKey(this.state, 123, 456);
        Assert.assertSame(constraints, (Object)result);
        ((Locks.Client)this.order.verify((Object)this.locks)).acquireShared((Locks.ResourceType)ResourceTypes.SCHEMA, new long[]{ResourceTypes.schemaResource()});
        ((SchemaReadOperations)this.order.verify((Object)this.schemaReadOps)).constraintsGetForLabelAndPropertyKey(this.state, 123, 456);
    }

    @Test
    public void shouldAcquireSchemaReadLockBeforeGettingConstraintsByLabel() throws Exception {
        Iterator constraints = Collections.emptyIterator();
        Mockito.when((Object)this.schemaReadOps.constraintsGetForLabel(this.state, 123)).thenReturn(constraints);
        Iterator result = this.lockingOps.constraintsGetForLabel(this.state, 123);
        Assert.assertSame(constraints, (Object)result);
        ((Locks.Client)this.order.verify((Object)this.locks)).acquireShared((Locks.ResourceType)ResourceTypes.SCHEMA, new long[]{ResourceTypes.schemaResource()});
        ((SchemaReadOperations)this.order.verify((Object)this.schemaReadOps)).constraintsGetForLabel(this.state, 123);
    }

    @Test
    public void shouldAcquireSchemaReadLockBeforeGettingAllConstraints() throws Exception {
        Iterator constraints = Collections.emptyIterator();
        Mockito.when((Object)this.schemaReadOps.constraintsGetAll(this.state)).thenReturn(constraints);
        Iterator result = this.lockingOps.constraintsGetAll(this.state);
        Assert.assertSame(constraints, (Object)result);
        ((Locks.Client)this.order.verify((Object)this.locks)).acquireShared((Locks.ResourceType)ResourceTypes.SCHEMA, new long[]{ResourceTypes.schemaResource()});
        ((SchemaReadOperations)this.order.verify((Object)this.schemaReadOps)).constraintsGetAll(this.state);
    }

    @Test
    public void shouldAcquireSchemaReadLockBeforeUpdatingSchemaState() throws Exception {
        Function creator = Functions.constant(null);
        this.lockingOps.schemaStateGetOrCreate(this.state, null, creator);
        ((Locks.Client)this.order.verify((Object)this.locks)).acquireShared((Locks.ResourceType)ResourceTypes.SCHEMA, new long[]{ResourceTypes.schemaResource()});
        ((SchemaStateOperations)this.order.verify((Object)this.schemaStateOps)).schemaStateGetOrCreate(this.state, null, creator);
    }

    @Test
    public void shouldAcquireSchemaReadLockBeforeCheckingSchemaState() throws Exception {
        this.lockingOps.schemaStateContains(this.state, null);
        ((Locks.Client)this.order.verify((Object)this.locks)).acquireShared((Locks.ResourceType)ResourceTypes.SCHEMA, new long[]{ResourceTypes.schemaResource()});
        ((SchemaStateOperations)this.order.verify((Object)this.schemaStateOps)).schemaStateContains(this.state, null);
    }

    @Test
    public void shouldAcquireSchemaReadLockBeforeFlushingSchemaState() throws Exception {
        this.lockingOps.schemaStateFlush(this.state);
        ((Locks.Client)this.order.verify((Object)this.locks)).acquireShared((Locks.ResourceType)ResourceTypes.SCHEMA, new long[]{ResourceTypes.schemaResource()});
        ((SchemaStateOperations)this.order.verify((Object)this.schemaStateOps)).schemaStateFlush(this.state);
    }

    @Test
    public void shouldAcquireEntityWriteLockCreatingRelationship() throws Exception {
        this.lockingOps.relationshipCreate(this.state, 1, 2L, 3L);
        ((Locks.Client)this.order.verify((Object)this.locks)).acquireExclusive((Locks.ResourceType)ResourceTypes.NODE, new long[]{2L});
        ((Locks.Client)this.order.verify((Object)this.locks)).acquireExclusive((Locks.ResourceType)ResourceTypes.NODE, new long[]{3L});
        ((EntityWriteOperations)this.order.verify((Object)this.entityWriteOps)).relationshipCreate(this.state, 1, 2L, 3L);
    }

    @Test
    public void shouldAcquireNodeLocksWhenCreatingRelationshipInOrderOfAscendingId() throws Exception {
        long lowId = 3L;
        long highId = 5L;
        this.lockingOps.relationshipCreate(this.state, 0, lowId, highId);
        InOrder lockingOrder = Mockito.inOrder((Object[])new Object[]{this.locks});
        ((Locks.Client)lockingOrder.verify((Object)this.locks)).acquireExclusive((Locks.ResourceType)ResourceTypes.NODE, new long[]{lowId});
        ((Locks.Client)lockingOrder.verify((Object)this.locks)).acquireExclusive((Locks.ResourceType)ResourceTypes.NODE, new long[]{highId});
        lockingOrder.verifyNoMoreInteractions();
        Mockito.reset((Object[])new Locks.Client[]{this.locks});
        this.lockingOps.relationshipCreate(this.state, 0, highId, lowId);
        lockingOrder = Mockito.inOrder((Object[])new Object[]{this.locks});
        ((Locks.Client)lockingOrder.verify((Object)this.locks)).acquireExclusive((Locks.ResourceType)ResourceTypes.NODE, new long[]{lowId});
        ((Locks.Client)lockingOrder.verify((Object)this.locks)).acquireExclusive((Locks.ResourceType)ResourceTypes.NODE, new long[]{highId});
        lockingOrder.verifyNoMoreInteractions();
    }

    @Test
    public void shouldAcquireNodeLocksWhenDeletingRelationshipInOrderOfAscendingId() throws Exception {
        long relationshipId = 10L;
        long lowId = 3L;
        long highId = 5L;
        ((EntityReadOperations)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocation) throws Throwable {
                RelationshipVisitor visitor = (RelationshipVisitor)invocation.getArguments()[2];
                visitor.visit(10L, 0, 3L, 5L);
                return null;
            }
        }).when((Object)this.entityReadOps)).relationshipVisit((KernelStatement)Matchers.any(KernelStatement.class), Matchers.anyLong(), (RelationshipVisitor)Matchers.any(RelationshipVisitor.class));
        this.lockingOps.relationshipDelete(this.state, 10L);
        InOrder lockingOrder = Mockito.inOrder((Object[])new Object[]{this.locks});
        ((Locks.Client)lockingOrder.verify((Object)this.locks)).acquireExclusive((Locks.ResourceType)ResourceTypes.NODE, new long[]{3L});
        ((Locks.Client)lockingOrder.verify((Object)this.locks)).acquireExclusive((Locks.ResourceType)ResourceTypes.NODE, new long[]{5L});
        ((Locks.Client)lockingOrder.verify((Object)this.locks)).acquireExclusive((Locks.ResourceType)ResourceTypes.RELATIONSHIP, new long[]{10L});
        lockingOrder.verifyNoMoreInteractions();
        Mockito.reset((Object[])new Locks.Client[]{this.locks});
        ((EntityReadOperations)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocation) throws Throwable {
                RelationshipVisitor visitor = (RelationshipVisitor)invocation.getArguments()[2];
                visitor.visit(10L, 0, 5L, 3L);
                return null;
            }
        }).when((Object)this.entityReadOps)).relationshipVisit((KernelStatement)Matchers.any(KernelStatement.class), Matchers.anyLong(), (RelationshipVisitor)Matchers.any(RelationshipVisitor.class));
        this.lockingOps.relationshipDelete(this.state, 10L);
        lockingOrder = Mockito.inOrder((Object[])new Object[]{this.locks});
        ((Locks.Client)lockingOrder.verify((Object)this.locks)).acquireExclusive((Locks.ResourceType)ResourceTypes.NODE, new long[]{3L});
        ((Locks.Client)lockingOrder.verify((Object)this.locks)).acquireExclusive((Locks.ResourceType)ResourceTypes.NODE, new long[]{5L});
        ((Locks.Client)lockingOrder.verify((Object)this.locks)).acquireExclusive((Locks.ResourceType)ResourceTypes.RELATIONSHIP, new long[]{10L});
        lockingOrder.verifyNoMoreInteractions();
    }

    @Test
    public void shouldAcquireEntityWriteLockBeforeSettingPropertyOnRelationship() throws Exception {
        DefinedProperty property = Property.property((int)8, (Object)9);
        this.lockingOps.relationshipSetProperty(this.state, 123L, property);
        ((Locks.Client)this.order.verify((Object)this.locks)).acquireExclusive((Locks.ResourceType)ResourceTypes.RELATIONSHIP, new long[]{123L});
        ((EntityWriteOperations)this.order.verify((Object)this.entityWriteOps)).relationshipSetProperty(this.state, 123L, property);
    }

    @Test
    public void shouldNotAcquireEntityWriteLockBeforeSettingPropertyOnJustCreatedRelationship() throws Exception {
        this.txState.relationshipDoCreate(123L, 1, 2L, 3L);
        DefinedProperty property = Property.property((int)8, (Object)9);
        this.lockingOps.relationshipSetProperty(this.state, 123L, property);
        ((Locks.Client)this.order.verify((Object)this.locks, Mockito.never())).acquireExclusive((Locks.ResourceType)ResourceTypes.RELATIONSHIP, new long[]{123L});
        ((EntityWriteOperations)this.order.verify((Object)this.entityWriteOps)).relationshipSetProperty(this.state, 123L, property);
    }

    @Test
    public void detachDeleteNodeWithoutRelationshipsExclusivelyLockNode() throws KernelException {
        long nodeId = 1L;
        NodeItem nodeItem = (NodeItem)Mockito.mock(NodeItem.class);
        Mockito.when((Object)nodeItem.getRelationships(Direction.BOTH)).thenReturn((Object)RelationshipIterator.EMPTY);
        StoreSingleNodeCursor nodeCursor = (StoreSingleNodeCursor)Mockito.mock(StoreSingleNodeCursor.class);
        Mockito.when((Object)nodeCursor.get()).thenReturn((Object)nodeItem);
        Mockito.when((Object)this.entityReadOps.nodeCursorById(this.state, nodeId)).thenReturn((Object)nodeCursor);
        this.lockingOps.nodeDetachDelete(this.state, nodeId);
        ((Locks.Client)this.order.verify((Object)this.locks)).acquireExclusive((Locks.ResourceType)ResourceTypes.NODE, new long[]{nodeId});
        ((Locks.Client)this.order.verify((Object)this.locks, Mockito.times((int)0))).releaseExclusive((Locks.ResourceType)ResourceTypes.NODE, nodeId);
        ((EntityWriteOperations)this.order.verify((Object)this.entityWriteOps)).nodeDetachDelete(this.state, nodeId);
    }

    @Test
    public void detachDeleteNodeExclusivelyLockNodes() throws Exception {
        long startNodeId = 1L;
        long endNodeId = 2L;
        final RelationshipItem relationshipItem = StubCursors.asRelationship(1L, 0, startNodeId, endNodeId, null);
        CursorRelationshipIterator relationshipIterator = new CursorRelationshipIterator(Cursors.cursor((Object[])new RelationshipItem[]{relationshipItem}));
        NodeItem nodeItem = (NodeItem)Mockito.mock(NodeItem.class);
        Mockito.when((Object)nodeItem.getRelationships(Direction.BOTH)).thenReturn((Object)relationshipIterator);
        StoreSingleNodeCursor nodeCursor = (StoreSingleNodeCursor)Mockito.mock(StoreSingleNodeCursor.class);
        Mockito.when((Object)nodeCursor.get()).thenReturn((Object)nodeItem);
        Mockito.when((Object)this.entityReadOps.nodeCursorById(this.state, startNodeId)).thenReturn((Object)nodeCursor);
        ((EntityReadOperations)Mockito.doAnswer((Answer)new Answer(){

            public Object answer(InvocationOnMock invocation) throws Throwable {
                RelationshipVisitor visitor = (RelationshipVisitor)invocation.getArguments()[2];
                visitor.visit(relationshipItem.id(), relationshipItem.type(), relationshipItem.startNode(), relationshipItem.endNode());
                return null;
            }
        }).when((Object)this.entityReadOps)).relationshipVisit((KernelStatement)Matchers.eq((Object)this.state), Matchers.anyLong(), (RelationshipVisitor)Matchers.any(RelationshipVisitor.class));
        this.lockingOps.nodeDetachDelete(this.state, startNodeId);
        ((Locks.Client)this.order.verify((Object)this.locks)).acquireExclusive((Locks.ResourceType)ResourceTypes.NODE, new long[]{startNodeId});
        ((Locks.Client)this.order.verify((Object)this.locks)).acquireExclusive((Locks.ResourceType)ResourceTypes.NODE, new long[]{endNodeId});
        ((Locks.Client)this.order.verify((Object)this.locks, Mockito.times((int)0))).releaseExclusive((Locks.ResourceType)ResourceTypes.NODE, startNodeId);
        ((Locks.Client)this.order.verify((Object)this.locks, Mockito.times((int)0))).releaseExclusive((Locks.ResourceType)ResourceTypes.NODE, endNodeId);
        ((EntityWriteOperations)this.order.verify((Object)this.entityWriteOps)).nodeDetachDelete(this.state, startNodeId);
    }

    private static class SimpleTxStateHolder
    implements TxStateHolder {
        private final TxState txState;

        private SimpleTxStateHolder(TxState txState) {
            this.txState = txState;
        }

        public TransactionState txState() {
            return this.txState;
        }

        public LegacyIndexTransactionState legacyIndexTxState() {
            return null;
        }

        public boolean hasTxStateWithChanges() {
            return false;
        }
    }
}

