/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.util.Arrays;
import java.util.Iterator;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.collection.primitive.PrimitiveLongCollections;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.graphdb.Neo4jMatchers;
import org.neo4j.kernel.impl.util.diffsets.DiffSets;

public class LongDiffSetsTest {
    @Test
    public void shouldContainSourceForEmptyDiffSets() throws Exception {
        DiffSets diffSets = new DiffSets();
        Iterator expected = diffSets.apply(LongDiffSetsTest.iteratorSource(1L, 2L));
        PrimitiveLongIterator actual = diffSets.augment(PrimitiveLongCollections.iterator((long[])new long[]{1L, 2L}));
        Assert.assertThat((Object)expected, Neo4jMatchers.hasSamePrimitiveItems(actual));
    }

    @Test
    public void shouldContainFilteredSourceForDiffSetsWithRemovedElements() throws Exception {
        DiffSets diffSets = new DiffSets();
        diffSets.remove((Object)17L);
        diffSets.remove((Object)18L);
        Iterator expected = diffSets.apply(LongDiffSetsTest.iteratorSource(1L, 17L, 3L));
        PrimitiveLongIterator actual = diffSets.augment(PrimitiveLongCollections.iterator((long[])new long[]{1L, 17L, 3L}));
        Assert.assertThat((Object)expected, Neo4jMatchers.hasSamePrimitiveItems(actual));
    }

    @Test
    public void shouldContainFilteredSourceForDiffSetsWithAddedElements() throws Exception {
        DiffSets diffSets = new DiffSets();
        diffSets.add((Object)17L);
        diffSets.add((Object)18L);
        Iterator expected = diffSets.apply(LongDiffSetsTest.iteratorSource(1L, 17L, 3L));
        PrimitiveLongIterator actual = diffSets.augment(PrimitiveLongCollections.iterator((long[])new long[]{1L, 17L, 3L}));
        Assert.assertThat((Object)expected, Neo4jMatchers.hasSamePrimitiveItems(actual));
    }

    @Test
    public void shouldContainAddedElementsForDiffSetsWithAddedElements() throws Exception {
        DiffSets diffSets = new DiffSets();
        diffSets.add((Object)19L);
        diffSets.add((Object)20L);
        Iterator expected = diffSets.apply(LongDiffSetsTest.iteratorSource(19L));
        PrimitiveLongIterator actual = diffSets.augment(PrimitiveLongCollections.iterator((long[])new long[]{19L}));
        Assert.assertThat((Object)expected, Neo4jMatchers.hasSamePrimitiveItems(actual));
    }

    private static Iterator<Long> iteratorSource(Long ... values) {
        return Arrays.asList(values).iterator();
    }
}

