/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.impl.api.IndexReaderFactory;
import org.neo4j.kernel.impl.api.KernelStatement;
import org.neo4j.kernel.impl.api.KernelTransactionImplementation;

public class StatementLifecycleTest {
    @Test
    public void shouldReleaseItselfWhenClosed() throws Exception {
        KernelTransactionImplementation transaction = (KernelTransactionImplementation)Mockito.mock(KernelTransactionImplementation.class);
        KernelStatement statement = new KernelStatement(transaction, (IndexReaderFactory)Mockito.mock(IndexReaderFactory.class), null, null, null, null, null);
        statement.acquire();
        statement.close();
        ((KernelTransactionImplementation)Mockito.verify((Object)transaction)).releaseStatement((Statement)statement);
    }

    @Test
    public void shouldReleaseWhenAllNestedStatementsClosed() throws Exception {
        KernelTransactionImplementation transaction = (KernelTransactionImplementation)Mockito.mock(KernelTransactionImplementation.class);
        KernelStatement statement = new KernelStatement(transaction, (IndexReaderFactory)Mockito.mock(IndexReaderFactory.class), null, null, null, null, null);
        statement.acquire();
        statement.acquire();
        statement.close();
        statement.close();
        ((KernelTransactionImplementation)Mockito.verify((Object)transaction)).releaseStatement((Statement)statement);
    }
}

