/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.io.IOException;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.helpers.Exceptions;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.kernel.api.exceptions.index.IndexCapacityExceededException;
import org.neo4j.kernel.impl.api.TransactionApplicationMode;
import org.neo4j.kernel.impl.api.TransactionRepresentationCommitProcess;
import org.neo4j.kernel.impl.api.TransactionRepresentationStoreApplier;
import org.neo4j.kernel.impl.api.index.IndexUpdatesValidator;
import org.neo4j.kernel.impl.api.index.ValidatedIndexUpdates;
import org.neo4j.kernel.impl.locking.LockGroup;
import org.neo4j.kernel.impl.store.UnderlyingStorageException;
import org.neo4j.kernel.impl.transaction.TransactionRepresentation;
import org.neo4j.kernel.impl.transaction.log.FakeCommitment;
import org.neo4j.kernel.impl.transaction.log.TransactionAppender;
import org.neo4j.kernel.impl.transaction.log.TransactionIdStore;
import org.neo4j.kernel.impl.transaction.tracing.CommitEvent;
import org.neo4j.kernel.impl.transaction.tracing.LogAppendEvent;

public class TransactionRepresentationCommitProcessTest {
    private final CommitEvent commitEvent = CommitEvent.NULL;

    @Test
    public void shouldNotIncrementLastCommittedTxIdIfAppendFails() throws Exception {
        TransactionAppender appender = (TransactionAppender)Mockito.mock(TransactionAppender.class);
        long txId = 11L;
        IOException rootCause = new IOException("Mock exception");
        ((TransactionAppender)Mockito.doThrow((Throwable)new IOException(rootCause)).when((Object)appender)).append((TransactionRepresentation)Matchers.any(TransactionRepresentation.class), (LogAppendEvent)Matchers.any(LogAppendEvent.class));
        TransactionIdStore transactionIdStore = (TransactionIdStore)Mockito.mock(TransactionIdStore.class);
        TransactionRepresentationStoreApplier storeApplier = (TransactionRepresentationStoreApplier)Mockito.mock(TransactionRepresentationStoreApplier.class);
        TransactionRepresentationCommitProcess commitProcess = new TransactionRepresentationCommitProcess(appender, storeApplier, TransactionRepresentationCommitProcessTest.mockedIndexUpdatesValidator());
        try (LockGroup locks = new LockGroup();){
            commitProcess.commit(this.mockedTransaction(), locks, this.commitEvent, TransactionApplicationMode.INTERNAL);
            Assert.fail((String)"Should have failed, something is wrong with the mocking in this test");
        }
        catch (TransactionFailureException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"Could not append transaction representation to log"));
            Assert.assertTrue((boolean)Exceptions.contains((Throwable)e, (String)rootCause.getMessage(), (Class[])new Class[]{rootCause.getClass()}));
        }
        ((TransactionIdStore)Mockito.verify((Object)transactionIdStore, (VerificationMode)Mockito.times((int)0))).transactionCommitted(txId, 0L, 0L);
    }

    @Test
    public void shouldCloseTransactionRegardlessOfWhetherOrNotItAppliedCorrectly() throws Exception {
        TransactionIdStore transactionIdStore = (TransactionIdStore)Mockito.mock(TransactionIdStore.class);
        TransactionAppender appender = (TransactionAppender)Mockito.mock(TransactionAppender.class);
        long txId = 11L;
        Mockito.when((Object)appender.append((TransactionRepresentation)Matchers.any(TransactionRepresentation.class), (LogAppendEvent)Matchers.any(LogAppendEvent.class))).thenReturn((Object)new FakeCommitment(txId, transactionIdStore));
        IOException rootCause = new IOException("Mock exception");
        TransactionRepresentationStoreApplier storeApplier = (TransactionRepresentationStoreApplier)Mockito.mock(TransactionRepresentationStoreApplier.class);
        ((TransactionRepresentationStoreApplier)Mockito.doThrow((Throwable)new IOException(rootCause)).when((Object)storeApplier)).apply((TransactionRepresentation)Matchers.any(TransactionRepresentation.class), (ValidatedIndexUpdates)Matchers.any(ValidatedIndexUpdates.class), (LockGroup)Matchers.any(LockGroup.class), Matchers.eq((long)txId), (TransactionApplicationMode)Matchers.eq((Object)TransactionApplicationMode.INTERNAL));
        TransactionRepresentationCommitProcess commitProcess = new TransactionRepresentationCommitProcess(appender, storeApplier, TransactionRepresentationCommitProcessTest.mockedIndexUpdatesValidator());
        TransactionRepresentation transaction = this.mockedTransaction();
        try (LockGroup locks = new LockGroup();){
            commitProcess.commit(transaction, locks, this.commitEvent, TransactionApplicationMode.INTERNAL);
        }
        catch (TransactionFailureException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"Could not apply the transaction to the store"));
            Assert.assertTrue((boolean)Exceptions.contains((Throwable)e, (String)rootCause.getMessage(), (Class[])new Class[]{rootCause.getClass()}));
        }
        ((TransactionIdStore)Mockito.verify((Object)transactionIdStore, (VerificationMode)Mockito.times((int)1))).transactionClosed(Matchers.eq((long)txId), Matchers.anyLong(), Matchers.anyLong());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{transactionIdStore});
    }

    @Test
    public void shouldThrowWhenIndexUpdatesValidationFails() throws IOException {
        IndexUpdatesValidator indexUpdatesValidator = (IndexUpdatesValidator)Mockito.mock(IndexUpdatesValidator.class);
        UnderlyingStorageException error = new UnderlyingStorageException((Throwable)new IndexCapacityExceededException(10L, 10L));
        Mockito.when((Object)indexUpdatesValidator.validate((TransactionRepresentation)Matchers.any(TransactionRepresentation.class))).thenThrow(new Throwable[]{error});
        TransactionRepresentationCommitProcess commitProcess = new TransactionRepresentationCommitProcess((TransactionAppender)Mockito.mock(TransactionAppender.class), (TransactionRepresentationStoreApplier)Mockito.mock(TransactionRepresentationStoreApplier.class), indexUpdatesValidator);
        try (LockGroup lockGroup = new LockGroup();){
            commitProcess.commit((TransactionRepresentation)Mockito.mock(TransactionRepresentation.class), lockGroup, CommitEvent.NULL, TransactionApplicationMode.INTERNAL);
            Assert.fail((String)("Should have thrown " + TransactionFailureException.class.getSimpleName()));
        }
        catch (TransactionFailureException e) {
            Assert.assertEquals((Object)Status.Transaction.ValidationFailed, (Object)e.status());
        }
    }

    private TransactionRepresentation mockedTransaction() {
        TransactionRepresentation transaction = (TransactionRepresentation)Mockito.mock(TransactionRepresentation.class);
        Mockito.when((Object)transaction.additionalHeader()).thenReturn((Object)new byte[0]);
        return transaction;
    }

    private static IndexUpdatesValidator mockedIndexUpdatesValidator() throws IOException {
        IndexUpdatesValidator validator = (IndexUpdatesValidator)Mockito.mock(IndexUpdatesValidator.class);
        Mockito.when((Object)validator.validate((TransactionRepresentation)Matchers.any(TransactionRepresentation.class))).thenReturn((Object)ValidatedIndexUpdates.NONE);
        return validator;
    }
}

