/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.util.HashSet;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.commons.lang3.NotImplementedException;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.InOrder;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.neo4j.cursor.Cursor;
import org.neo4j.function.Consumer;
import org.neo4j.graphdb.Direction;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.kernel.api.cursor.NodeItem;
import org.neo4j.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.kernel.impl.api.KernelStatement;
import org.neo4j.kernel.impl.api.RelationshipVisitor;
import org.neo4j.kernel.impl.api.TwoPhaseNodeForRelationshipLocking;
import org.neo4j.kernel.impl.api.operations.EntityReadOperations;
import org.neo4j.kernel.impl.api.store.RelationshipIterator;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.impl.locking.ResourceTypes;
import org.neo4j.kernel.impl.locking.SimpleStatementLocks;

public class TwoPhaseNodeForRelationshipLockingTest {
    private final EntityReadOperations ops = (EntityReadOperations)Mockito.mock(EntityReadOperations.class);
    private final KernelStatement state = (KernelStatement)Mockito.mock(KernelStatement.class);
    private final Locks.Client locks = (Locks.Client)Mockito.mock(Locks.Client.class);
    private final long nodeId = 42L;

    public TwoPhaseNodeForRelationshipLockingTest() {
        Mockito.when((Object)this.state.locks()).thenReturn((Object)new SimpleStatementLocks(this.locks));
    }

    @Test
    public void shouldLockNodesInOrderAndConsumeTheRelationships() throws Throwable {
        Collector collector = new Collector();
        TwoPhaseNodeForRelationshipLocking locking = new TwoPhaseNodeForRelationshipLocking(this.ops, (Consumer)collector);
        this.returnRelationships(42L, false, 21L, 22L, 23L);
        this.returnNodesForRelationship(21L, 42L, 43L);
        this.returnNodesForRelationship(22L, 40L, 42L);
        this.returnNodesForRelationship(23L, 42L, 41L);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.locks});
        locking.lockAllNodesAndConsumeRelationships(42L, this.state);
        ((Locks.Client)inOrder.verify((Object)this.locks)).acquireExclusive((Locks.ResourceType)ResourceTypes.NODE, new long[]{40L});
        ((Locks.Client)inOrder.verify((Object)this.locks)).acquireExclusive((Locks.ResourceType)ResourceTypes.NODE, new long[]{41L});
        ((Locks.Client)inOrder.verify((Object)this.locks)).acquireExclusive((Locks.ResourceType)ResourceTypes.NODE, new long[]{42L});
        ((Locks.Client)inOrder.verify((Object)this.locks)).acquireExclusive((Locks.ResourceType)ResourceTypes.NODE, new long[]{43L});
        Assert.assertEquals((Object)IteratorUtil.set((Object[])new Long[]{21L, 22L, 23L}), collector.set);
    }

    @Test
    public void shouldLockNodesInOrderAndConsumeTheRelationshipsAndRetryIfTheNewRelationshipsAreCreated() throws Throwable {
        Collector collector = new Collector();
        TwoPhaseNodeForRelationshipLocking locking = new TwoPhaseNodeForRelationshipLocking(this.ops, (Consumer)collector);
        this.returnRelationships(42L, true, 21L, 22L, 23L);
        this.returnNodesForRelationship(21L, 42L, 43L);
        this.returnNodesForRelationship(22L, 40L, 42L);
        this.returnNodesForRelationship(23L, 42L, 41L);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.locks});
        locking.lockAllNodesAndConsumeRelationships(42L, this.state);
        ((Locks.Client)inOrder.verify((Object)this.locks)).acquireExclusive((Locks.ResourceType)ResourceTypes.NODE, new long[]{40L});
        ((Locks.Client)inOrder.verify((Object)this.locks)).acquireExclusive((Locks.ResourceType)ResourceTypes.NODE, new long[]{41L});
        ((Locks.Client)inOrder.verify((Object)this.locks)).acquireExclusive((Locks.ResourceType)ResourceTypes.NODE, new long[]{42L});
        ((Locks.Client)inOrder.verify((Object)this.locks)).releaseExclusive((Locks.ResourceType)ResourceTypes.NODE, 40L);
        ((Locks.Client)inOrder.verify((Object)this.locks)).releaseExclusive((Locks.ResourceType)ResourceTypes.NODE, 41L);
        ((Locks.Client)inOrder.verify((Object)this.locks)).releaseExclusive((Locks.ResourceType)ResourceTypes.NODE, 42L);
        ((Locks.Client)inOrder.verify((Object)this.locks)).acquireExclusive((Locks.ResourceType)ResourceTypes.NODE, new long[]{40L});
        ((Locks.Client)inOrder.verify((Object)this.locks)).acquireExclusive((Locks.ResourceType)ResourceTypes.NODE, new long[]{41L});
        ((Locks.Client)inOrder.verify((Object)this.locks)).acquireExclusive((Locks.ResourceType)ResourceTypes.NODE, new long[]{42L});
        ((Locks.Client)inOrder.verify((Object)this.locks)).acquireExclusive((Locks.ResourceType)ResourceTypes.NODE, new long[]{43L});
        Assert.assertEquals((Object)IteratorUtil.set((Object[])new Long[]{21L, 22L, 23L}), collector.set);
    }

    @Test
    public void lockNodeWithoutRelationships() throws Exception {
        Collector collector = new Collector();
        TwoPhaseNodeForRelationshipLocking locking = new TwoPhaseNodeForRelationshipLocking(this.ops, (Consumer)collector);
        this.returnRelationships(42L, false, new long[0]);
        locking.lockAllNodesAndConsumeRelationships(42L, this.state);
        ((Locks.Client)Mockito.verify((Object)this.locks)).acquireExclusive((Locks.ResourceType)ResourceTypes.NODE, new long[]{42L});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.locks});
    }

    private void returnNodesForRelationship(final long relId, final long startNodeId, final long endNodeId) throws Exception {
        ((EntityReadOperations)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocation) throws Throwable {
                RelationshipVisitor visitor = (RelationshipVisitor)invocation.getArguments()[2];
                visitor.visit(relId, 6, startNodeId, endNodeId);
                return null;
            }
        }).when((Object)this.ops)).relationshipVisit((KernelStatement)Matchers.eq((Object)this.state), Matchers.eq((long)relId), (RelationshipVisitor)Matchers.any(RelationshipVisitor.class));
    }

    private void returnRelationships(long nodeId, final boolean skipFirst, final long ... relIds) throws EntityNotFoundException {
        Cursor cursor = (Cursor)Mockito.mock(Cursor.class);
        Mockito.when((Object)this.ops.nodeCursorById(this.state, nodeId)).thenReturn((Object)cursor);
        NodeItem nodeItem = (NodeItem)Mockito.mock(NodeItem.class);
        Mockito.when((Object)cursor.get()).thenReturn((Object)nodeItem);
        Mockito.when((Object)nodeItem.getRelationships(Direction.BOTH)).thenAnswer((Answer)new Answer<RelationshipIterator>(){
            private boolean first;
            {
                this.first = skipFirst;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public RelationshipIterator answer(InvocationOnMock invocation) throws Throwable {
                try {
                    RelationshipIterator relationshipIterator = new RelationshipIterator(){
                        private int i;
                        {
                            this.i = first ? 1 : 0;
                        }

                        public <EXCEPTION extends Exception> boolean relationshipVisit(long relationshipId, RelationshipVisitor<EXCEPTION> visitor) {
                            throw new NotImplementedException("don't call this!");
                        }

                        public boolean hasNext() {
                            return this.i < relIds.length;
                        }

                        public long next() {
                            if (!this.hasNext()) {
                                throw new NoSuchElementException();
                            }
                            return relIds[this.i++];
                        }
                    };
                    return relationshipIterator;
                }
                finally {
                    this.first = false;
                }
            }
        });
    }

    private static class Collector
    implements Consumer<Long> {
        public final Set<Long> set = new HashSet<Long>();

        private Collector() {
        }

        public void accept(Long input) {
            Assert.assertNotNull((Object)input);
            this.set.add(input);
        }
    }
}

