/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import java.io.IOException;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.kernel.api.index.IndexConfiguration;
import org.neo4j.kernel.api.index.IndexDescriptor;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.index.SchemaIndexProvider;
import org.neo4j.kernel.impl.api.index.FailedIndexProxy;
import org.neo4j.kernel.impl.api.index.IndexCountsRemover;
import org.neo4j.kernel.impl.api.index.IndexPopulationFailure;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;

public class FailedIndexProxyTest {
    private final IndexDescriptor descriptor = new IndexDescriptor(1, 2);
    private final IndexConfiguration config = new IndexConfiguration(false);
    private final SchemaIndexProvider.Descriptor providerDescriptor = (SchemaIndexProvider.Descriptor)Mockito.mock(SchemaIndexProvider.Descriptor.class);
    private final String userDescription = "description";
    private final IndexPopulator indexPopulator = (IndexPopulator)Mockito.mock(IndexPopulator.class);
    private final IndexPopulationFailure indexPopulationFailure = (IndexPopulationFailure)Mockito.mock(IndexPopulationFailure.class);
    private final IndexCountsRemover indexCountsRemover = (IndexCountsRemover)Mockito.mock(IndexCountsRemover.class);

    @Test
    public void shouldRemoveIndexCountsWhenTheIndexItselfIsDropped() throws IOException {
        FailedIndexProxy index = new FailedIndexProxy(this.descriptor, this.config, this.providerDescriptor, "description", this.indexPopulator, this.indexPopulationFailure, this.indexCountsRemover, (LogProvider)NullLogProvider.getInstance());
        index.drop();
        ((IndexPopulator)Mockito.verify((Object)this.indexPopulator)).drop();
        ((IndexCountsRemover)Mockito.verify((Object)this.indexCountsRemover)).remove();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.indexPopulator, this.indexCountsRemover});
    }

    @Test
    public void shouldLogReasonForDroppingIndex() throws IOException {
        AssertableLogProvider logProvider = new AssertableLogProvider();
        new FailedIndexProxy(new IndexDescriptor(0, 0), this.config, new SchemaIndexProvider.Descriptor("foo", "bar"), "foo", (IndexPopulator)Mockito.mock(IndexPopulator.class), IndexPopulationFailure.failure((String)"it broke"), this.indexCountsRemover, (LogProvider)logProvider).drop();
        logProvider.assertAtLeastOnce(new AssertableLogProvider.LogMatcher[]{AssertableLogProvider.inLog(FailedIndexProxy.class).info("FailedIndexProxy#drop index on foo dropped due to:\nit broke")});
    }
}

