/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index.inmemory;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.collection.primitive.PrimitiveLongSet;
import org.neo4j.collection.primitive.PrimitiveLongVisitor;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.kernel.api.direct.BoundedIterable;
import org.neo4j.kernel.api.exceptions.index.IndexNotFoundKernelException;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.api.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.index.IndexReader;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.api.index.InternalIndexState;
import org.neo4j.kernel.api.index.NodePropertyUpdate;
import org.neo4j.kernel.api.index.PropertyAccessor;
import org.neo4j.kernel.api.index.Reservation;
import org.neo4j.kernel.impl.api.index.IndexUpdateMode;
import org.neo4j.kernel.impl.api.index.inmemory.HashBasedIndex;
import org.neo4j.kernel.impl.api.index.inmemory.InMemoryIndexImplementation;
import org.neo4j.register.Register;

class InMemoryIndex {
    protected final InMemoryIndexImplementation indexData;
    private InternalIndexState state = InternalIndexState.POPULATING;
    String failure;
    private final PrimitiveLongVisitor<RuntimeException> removeFromIndex = new PrimitiveLongVisitor<RuntimeException>(){

        public boolean visited(long nodeId) throws RuntimeException {
            InMemoryIndex.this.indexData.remove(nodeId);
            return false;
        }
    };

    InMemoryIndex() {
        this(new HashBasedIndex());
    }

    InMemoryIndex(InMemoryIndexImplementation indexData) {
        this.indexData = indexData;
    }

    public String toString() {
        if (this.failure != null) {
            return String.format("%s[failure=\"%s\"]%s", this.getClass().getSimpleName(), this.failure, this.indexData);
        }
        return String.format("%s%s", this.getClass().getSimpleName(), this.indexData);
    }

    final IndexPopulator getPopulator() {
        return new Populator();
    }

    final IndexAccessor getOnlineAccessor() {
        return new OnlineAccessor();
    }

    protected final PrimitiveLongIterator indexSeek(Object propertyValue) {
        return this.indexData.seek(propertyValue);
    }

    protected boolean add(long nodeId, Object propertyValue, boolean applyIdempotently) throws IndexEntryConflictException, IOException {
        return this.indexData.add(nodeId, propertyValue, applyIdempotently);
    }

    protected void remove(long nodeId, Object propertyValue) {
        this.indexData.remove(nodeId, propertyValue);
    }

    protected void remove(long nodeId) {
        this.indexData.remove(nodeId);
    }

    InternalIndexState getState() {
        return this.state;
    }

    public void verifyDeferredConstraints(PropertyAccessor accessor) throws IndexEntryConflictException, IOException {
    }

    protected IndexUpdater newUpdater(IndexUpdateMode mode, boolean populating) {
        return new InMemoryIndexUpdater(populating);
    }

    InMemoryIndex snapshot() {
        InMemoryIndex snapshot = new InMemoryIndex(this.indexData.snapshot());
        snapshot.failure = this.failure;
        snapshot.state = this.state;
        return snapshot;
    }

    static String encodeAsString(Object propertyValue) {
        String repr = propertyValue instanceof int[] ? Arrays.toString((int[])propertyValue) : (propertyValue instanceof long[] ? Arrays.toString((long[])propertyValue) : (propertyValue instanceof boolean[] ? Arrays.toString((boolean[])propertyValue) : (propertyValue instanceof double[] ? Arrays.toString((double[])propertyValue) : (propertyValue instanceof float[] ? Arrays.toString((float[])propertyValue) : (propertyValue instanceof short[] ? Arrays.toString((short[])propertyValue) : (propertyValue instanceof byte[] ? Arrays.toString((byte[])propertyValue) : (propertyValue instanceof char[] ? Arrays.toString((char[])propertyValue) : (propertyValue instanceof Object[] ? Arrays.toString((Object[])propertyValue) : propertyValue.toString()))))))));
        return repr;
    }

    private class InMemoryIndexUpdater
    implements IndexUpdater {
        private final boolean applyIdempotently;

        private InMemoryIndexUpdater(boolean applyIdempotently) {
            this.applyIdempotently = applyIdempotently;
        }

        public Reservation validate(Iterable<NodePropertyUpdate> updates) throws IOException {
            return Reservation.EMPTY;
        }

        public void process(NodePropertyUpdate update) throws IOException, IndexEntryConflictException {
            switch (update.getUpdateMode()) {
                case ADDED: {
                    InMemoryIndex.this.add(update.getNodeId(), update.getValueAfter(), this.applyIdempotently);
                    break;
                }
                case CHANGED: {
                    InMemoryIndex.this.remove(update.getNodeId(), update.getValueBefore());
                    InMemoryIndex.this.add(update.getNodeId(), update.getValueAfter(), this.applyIdempotently);
                    break;
                }
                case REMOVED: {
                    InMemoryIndex.this.remove(update.getNodeId(), update.getValueBefore());
                    break;
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
        }

        public void close() throws IOException, IndexEntryConflictException {
        }

        public void remove(PrimitiveLongSet nodeIds) {
            nodeIds.visitKeys(InMemoryIndex.this.removeFromIndex);
        }
    }

    private class OnlineAccessor
    implements IndexAccessor {
        private OnlineAccessor() {
        }

        public void force() {
        }

        public void flush() {
        }

        public void drop() {
            InMemoryIndex.this.indexData.drop();
        }

        public IndexUpdater newUpdater(IndexUpdateMode mode) {
            return InMemoryIndex.this.newUpdater(mode, false);
        }

        public void close() {
        }

        public IndexReader newReader() {
            return InMemoryIndex.this.indexData;
        }

        public BoundedIterable<Long> newAllEntriesReader() {
            return InMemoryIndex.this.indexData;
        }

        public ResourceIterator<File> snapshotFiles() {
            return IteratorUtil.emptyIterator();
        }
    }

    private class Populator
    implements IndexPopulator {
        private Populator() {
        }

        public void create() {
            InMemoryIndex.this.indexData.initialize();
        }

        public void add(long nodeId, Object propertyValue) throws IndexEntryConflictException, IOException {
            InMemoryIndex.this.add(nodeId, propertyValue, false);
        }

        public void verifyDeferredConstraints(PropertyAccessor accessor) throws IndexEntryConflictException, IOException {
            InMemoryIndex.this.verifyDeferredConstraints(accessor);
        }

        public IndexUpdater newPopulatingUpdater(PropertyAccessor propertyAccessor) throws IOException {
            return InMemoryIndex.this.newUpdater(IndexUpdateMode.ONLINE, true);
        }

        public void drop() throws IOException {
            InMemoryIndex.this.indexData.drop();
        }

        public void close(boolean populationCompletedSuccessfully) throws IOException {
            if (populationCompletedSuccessfully) {
                InMemoryIndex.this.state = InternalIndexState.ONLINE;
            }
        }

        public void markAsFailed(String failureString) {
            InMemoryIndex.this.failure = failureString;
            InMemoryIndex.this.state = InternalIndexState.FAILED;
        }

        public long sampleResult(Register.DoubleLong.Out result) {
            try {
                return InMemoryIndex.this.indexData.sampleIndex(result);
            }
            catch (IndexNotFoundKernelException e) {
                throw new IllegalStateException(e);
            }
        }
    }
}

