/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.store;

import java.util.Iterator;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Transaction;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.kernel.api.constraints.UniquenessConstraint;
import org.neo4j.kernel.impl.api.store.DiskLayerTest;

public class DiskLayerSchemaTest
extends DiskLayerTest {
    @Test
    public void shouldListAllConstraints() {
        this.createUniquenessConstraint(this.label1, "name");
        this.createUniquenessConstraint(this.label2, "name");
        Set constraints = IteratorUtil.asSet((Iterator)this.disk.constraintsGetAll());
        int propKeyId = this.propertyKeyId("name");
        Set expectedConstraints = IteratorUtil.asSet((Object[])new UniquenessConstraint[]{new UniquenessConstraint(this.labelId(this.label1), propKeyId), new UniquenessConstraint(this.labelId(this.label2), propKeyId)});
        Assert.assertEquals((Object)expectedConstraints, (Object)constraints);
    }

    @Test
    public void shouldListAllConstraintsForLabel() {
        this.createUniquenessConstraint(this.label1, "name");
        this.createUniquenessConstraint(this.label2, "name");
        Set constraints = IteratorUtil.asSet((Iterator)this.disk.constraintsGetForLabel(this.labelId(this.label1)));
        Set expectedConstraints = IteratorUtil.asSet((Object[])new UniquenessConstraint[]{new UniquenessConstraint(this.labelId(this.label1), this.propertyKeyId("name"))});
        Assert.assertEquals((Object)expectedConstraints, (Object)constraints);
    }

    @Test
    public void shouldListAllConstraintsForLabelAndProperty() {
        this.createUniquenessConstraint(this.label1, "name");
        this.createUniquenessConstraint(this.label1, "age");
        Set constraints = IteratorUtil.asSet((Iterator)this.disk.constraintsGetForLabelAndPropertyKey(this.labelId(this.label1), this.propertyKeyId("name")));
        Set expectedConstraints = IteratorUtil.asSet((Object[])new UniquenessConstraint[]{new UniquenessConstraint(this.labelId(this.label1), this.propertyKeyId("name"))});
        Assert.assertEquals((Object)expectedConstraints, (Object)constraints);
    }

    private void createUniquenessConstraint(Label label, String propertyKey) {
        try (Transaction tx = this.db.beginTx();){
            this.db.schema().constraintFor(label).assertPropertyIsUnique(propertyKey).create();
            tx.success();
        }
    }
}

