/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.store;

import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.neo4j.collection.primitive.PrimitiveLongCollections;
import org.neo4j.kernel.impl.api.store.StoreIteratorRelationshipCursor;
import org.neo4j.kernel.impl.api.store.StoreStatement;
import org.neo4j.kernel.impl.locking.LockService;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.RelationshipStore;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.kernel.impl.util.InstanceCache;

public class StoreIteratorRelationshipCursorTest {
    private static final long RELATIONSHIP_ID = 1L;

    @Test
    public void retrieveUsedRelationship() throws Exception {
        RelationshipRecord relationshipRecord = new RelationshipRecord(-1L);
        RelationshipStore relationshipStore = (RelationshipStore)Mockito.mock(RelationshipStore.class);
        Mockito.when((Object)relationshipStore.fillRecord(Matchers.eq((long)1L), (RelationshipRecord)Matchers.eq((Object)relationshipRecord), (RecordLoad)Matchers.any(RecordLoad.class))).thenAnswer((Answer)new RelationshipAnswer(relationshipRecord, true));
        try (StoreIteratorRelationshipCursor cursor = this.createRelationshipCursor(relationshipRecord, relationshipStore);){
            cursor.init(PrimitiveLongCollections.iterator((long[])new long[]{1L}));
            Assert.assertTrue((boolean)cursor.next());
            Assert.assertEquals((long)1L, (long)cursor.get().id());
        }
    }

    @Test
    public void impossibleToRetrieveUnusedRelationship() {
        RelationshipRecord relationshipRecord = new RelationshipRecord(-1L);
        RelationshipStore relationshipStore = (RelationshipStore)Mockito.mock(RelationshipStore.class);
        Mockito.when((Object)relationshipStore.fillRecord(Matchers.eq((long)1L), (RelationshipRecord)Matchers.eq((Object)relationshipRecord), (RecordLoad)Matchers.any(RecordLoad.class))).thenAnswer((Answer)new RelationshipAnswer(relationshipRecord, false));
        try (StoreIteratorRelationshipCursor cursor = this.createRelationshipCursor(relationshipRecord, relationshipStore);){
            cursor.init(PrimitiveLongCollections.iterator((long[])new long[]{1L}));
            Assert.assertFalse((boolean)cursor.next());
        }
    }

    private StoreIteratorRelationshipCursor createRelationshipCursor(RelationshipRecord relationshipRecord, RelationshipStore relationshipStore) {
        NeoStores neoStores = (NeoStores)Mockito.mock(NeoStores.class);
        StoreStatement storeStatement = (StoreStatement)Mockito.mock(StoreStatement.class);
        Mockito.when((Object)neoStores.getRelationshipStore()).thenReturn((Object)relationshipStore);
        TestCursorCache instanceCache = new TestCursorCache();
        return new StoreIteratorRelationshipCursor(relationshipRecord, neoStores, storeStatement, (InstanceCache)instanceCache, LockService.NO_LOCK_SERVICE);
    }

    private class TestCursorCache
    extends InstanceCache<StoreIteratorRelationshipCursor> {
        private TestCursorCache() {
        }

        protected StoreIteratorRelationshipCursor create() {
            return null;
        }
    }

    private static class RelationshipAnswer
    implements Answer<Boolean> {
        private final RelationshipRecord relationshipRecord;
        private boolean used;

        RelationshipAnswer(RelationshipRecord relationshipRecord, boolean used) {
            this.relationshipRecord = relationshipRecord;
            this.used = used;
        }

        public Boolean answer(InvocationOnMock invocationOnMock) throws Throwable {
            this.relationshipRecord.setInUse(this.used);
            this.relationshipRecord.setId(1L);
            return true;
        }
    }
}

