/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.store;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.mockito.Mockito;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.impl.api.store.StoreSingleRelationshipCursor;
import org.neo4j.kernel.impl.api.store.StoreStatement;
import org.neo4j.kernel.impl.locking.LockService;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.RelationshipStore;
import org.neo4j.kernel.impl.store.StoreFactory;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.kernel.impl.util.InstanceCache;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.test.DefaultFileSystemRule;
import org.neo4j.test.PageCacheRule;
import org.neo4j.test.TargetDirectory;

public class StoreSingleRelationshipCursorTest {
    private static final long RELATIONSHIP_ID = 1L;
    private final TargetDirectory.TestDirectory testDirectory = TargetDirectory.testDirForTest(this.getClass());
    private final PageCacheRule pageCacheRule = new PageCacheRule();
    private final DefaultFileSystemRule fileSystemRule = new DefaultFileSystemRule();
    @Rule
    public final RuleChain ruleChain = RuleChain.outerRule((TestRule)this.testDirectory).around((TestRule)this.pageCacheRule).around((TestRule)this.fileSystemRule);
    private NeoStores neoStores;

    @After
    public void tearDown() {
        if (this.neoStores != null) {
            this.neoStores.close();
        }
    }

    @Before
    public void setUp() {
        StoreFactory storeFactory = this.getStoreFactory();
        this.neoStores = storeFactory.openNeoStores(true, new NeoStores.StoreType[]{NeoStores.StoreType.RELATIONSHIP_GROUP, NeoStores.StoreType.RELATIONSHIP});
    }

    @Test
    public void retrieveUsedRelationship() throws Exception {
        RelationshipStore relationshipStore = this.neoStores.getRelationshipStore();
        this.createRelationshipRecrod(relationshipStore, true);
        try (StoreSingleRelationshipCursor cursor = this.createRelationshipCursor();){
            cursor.init(1L);
            Assert.assertTrue((boolean)cursor.next());
            Assert.assertEquals((long)1L, (long)cursor.get().id());
        }
    }

    @Test
    public void impossibleToRetrieveUnusedRelationship() {
        RelationshipStore relationshipStore = this.neoStores.getRelationshipStore();
        this.createRelationshipRecrod(relationshipStore, false);
        try (StoreSingleRelationshipCursor cursor = this.createRelationshipCursor();){
            cursor.init(1L);
            Assert.assertFalse((boolean)cursor.next());
        }
    }

    private void createRelationshipRecrod(RelationshipStore relationshipStore, boolean used) {
        relationshipStore.forceUpdateRecord(new RelationshipRecord(1L, used, 1L, 2L, 1, -1L, -1L, -1L, -1L, true, true));
    }

    private StoreFactory getStoreFactory() {
        return new StoreFactory((FileSystemAbstraction)this.fileSystemRule.get(), this.testDirectory.directory(), this.pageCacheRule.getPageCache((FileSystemAbstraction)this.fileSystemRule.get()), (LogProvider)NullLogProvider.getInstance());
    }

    private StoreSingleRelationshipCursor createRelationshipCursor() {
        StoreStatement storeStatement = (StoreStatement)Mockito.mock(StoreStatement.class);
        TestCursorCache instanceCache = new TestCursorCache();
        return new StoreSingleRelationshipCursor(new RelationshipRecord(-1L), this.neoStores, storeStatement, (InstanceCache)instanceCache, LockService.NO_LOCK_SERVICE);
    }

    private class TestCursorCache
    extends InstanceCache<StoreSingleRelationshipCursor> {
        private TestCursorCache() {
        }

        protected StoreSingleRelationshipCursor create() {
            return null;
        }
    }
}

