/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.impl.api.RelationshipVisitor;
import org.neo4j.kernel.impl.api.store.RelationshipIterator;
import org.neo4j.kernel.impl.core.NodeProxy;
import org.neo4j.kernel.impl.core.RelationshipConversion;

public class RelationshipConversionTest {
    private NodeProxy.NodeActions nodeActions = (NodeProxy.NodeActions)Mockito.mock(NodeProxy.NodeActions.class);
    private Statement statement = (Statement)Mockito.mock(Statement.class);
    private RelationshipConversion relationshipConversion;

    @Before
    public void setUp() {
        this.relationshipConversion = new RelationshipConversion(this.nodeActions);
        this.relationshipConversion.statement = this.statement;
    }

    @Test
    public void closeStatementOnClose() throws Exception {
        this.relationshipConversion.close();
        ((Statement)Mockito.verify((Object)this.statement)).close();
    }

    @Test
    public void closeStatementWhenIterationIsOver() {
        this.relationshipConversion.iterator = new ArrayRelationshipVisitor(new long[]{1L, 8L});
        Assert.assertTrue((boolean)this.relationshipConversion.hasNext());
        this.relationshipConversion.next();
        ((Statement)Mockito.verify((Object)this.statement, (VerificationMode)Mockito.never())).close();
        Assert.assertTrue((boolean)this.relationshipConversion.hasNext());
        this.relationshipConversion.next();
        ((Statement)Mockito.verify((Object)this.statement, (VerificationMode)Mockito.never())).close();
        Assert.assertFalse((boolean)this.relationshipConversion.hasNext());
        ((Statement)Mockito.verify((Object)this.statement)).close();
    }

    @Test
    public void closeStatementOnlyOnce() {
        this.relationshipConversion.iterator = new ArrayRelationshipVisitor(new long[]{1L});
        Assert.assertTrue((boolean)this.relationshipConversion.hasNext());
        this.relationshipConversion.next();
        Assert.assertFalse((boolean)this.relationshipConversion.hasNext());
        Assert.assertFalse((boolean)this.relationshipConversion.hasNext());
        Assert.assertFalse((boolean)this.relationshipConversion.hasNext());
        Assert.assertFalse((boolean)this.relationshipConversion.hasNext());
        this.relationshipConversion.close();
        this.relationshipConversion.close();
        ((Statement)Mockito.verify((Object)this.statement)).close();
    }

    private static class ArrayRelationshipVisitor
    extends RelationshipIterator.BaseIterator {
        private final long[] ids;
        private int position;

        ArrayRelationshipVisitor(long[] ids) {
            this.ids = ids;
        }

        protected boolean fetchNext() {
            return this.ids.length > this.position && this.next(this.ids[this.position++]);
        }

        public <EXCEPTION extends Exception> boolean relationshipVisit(long relationshipId, RelationshipVisitor<EXCEPTION> visitor) throws EXCEPTION {
            visitor.visit(relationshipId, 1, 1L, 1L);
            return false;
        }
    }
}

