/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import java.util.UUID;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.test.TestGraphDatabaseFactory;

public class TestExceptionTypeOnInvalidIds {
    private static final long SMALL_POSSITIVE_INTEGER = 5L;
    private static final long SMALL_NEGATIVE_INTEGER = -5L;
    private static final long BIG_POSSITIVE_INTEGER = Integer.MAX_VALUE;
    private static final long BIG_NEGATIVE_INTEGER = Integer.MIN_VALUE;
    private static final long SMALL_POSSITIVE_LONG = 0x80000000L;
    private static final long SMALL_NEGATIVE_LONG = Integer.MAX_VALUE;
    private static final long BIG_POSSITIVE_LONG = Long.MAX_VALUE;
    private static final long BIG_NEGATIVE_LONG = Long.MIN_VALUE;
    private static GraphDatabaseService graphdb;
    private static GraphDatabaseService graphDbReadOnly;
    private Transaction tx;

    @BeforeClass
    public static void createDatabase() {
        graphdb = new TestGraphDatabaseFactory().newEmbeddedDatabase(TestExceptionTypeOnInvalidIds.getRandomStoreDir());
        String storeDir = TestExceptionTypeOnInvalidIds.getRandomStoreDir();
        new TestGraphDatabaseFactory().newEmbeddedDatabase(storeDir).shutdown();
        graphDbReadOnly = new TestGraphDatabaseFactory().newEmbeddedDatabaseBuilder(storeDir).setConfig(GraphDatabaseSettings.read_only, "true").newGraphDatabase();
    }

    private static String getRandomStoreDir() {
        return "target/var/id_test/" + UUID.randomUUID();
    }

    @AfterClass
    public static void destroyDatabase() {
        graphDbReadOnly.shutdown();
        graphDbReadOnly = null;
        graphdb.shutdown();
        graphdb = null;
    }

    @Before
    public void startTransaction() {
        this.tx = graphdb.beginTx();
    }

    @After
    public void endTransaction() {
        this.tx.close();
        this.tx = null;
    }

    @Test(expected=NotFoundException.class)
    public void getNodeBySmallPossitiveInteger() throws Exception {
        this.getNodeById(5L);
        this.getNodeByIdReadOnly(5L);
    }

    @Test(expected=NotFoundException.class)
    public void getNodeBySmallNegativeInteger() throws Exception {
        this.getNodeById(-5L);
        this.getNodeByIdReadOnly(-5L);
    }

    @Test(expected=NotFoundException.class)
    public void getNodeByBigPossitiveInteger() throws Exception {
        this.getNodeById(Integer.MAX_VALUE);
        this.getNodeByIdReadOnly(Integer.MAX_VALUE);
    }

    @Test(expected=NotFoundException.class)
    public void getNodeByBigNegativeInteger() throws Exception {
        this.getNodeById(Integer.MIN_VALUE);
        this.getNodeByIdReadOnly(Integer.MIN_VALUE);
    }

    @Test(expected=NotFoundException.class)
    public void getNodeBySmallPossitiveLong() throws Exception {
        this.getNodeById(0x80000000L);
        this.getNodeByIdReadOnly(0x80000000L);
    }

    @Test(expected=NotFoundException.class)
    public void getNodeBySmallNegativeLong() throws Exception {
        this.getNodeById(Integer.MAX_VALUE);
        this.getNodeByIdReadOnly(Integer.MAX_VALUE);
    }

    @Test(expected=NotFoundException.class)
    public void getNodeByBigPossitiveLong() throws Exception {
        this.getNodeById(Long.MAX_VALUE);
        this.getNodeByIdReadOnly(Long.MAX_VALUE);
    }

    @Test(expected=NotFoundException.class)
    public void getNodeByBigNegativeLong() throws Exception {
        this.getNodeById(Long.MIN_VALUE);
        this.getNodeByIdReadOnly(Long.MIN_VALUE);
    }

    @Test(expected=NotFoundException.class)
    public void getRelationshipBySmallPossitiveInteger() throws Exception {
        this.getRelationshipById(5L);
        this.getRelationshipByIdReadOnly(5L);
    }

    @Test(expected=NotFoundException.class)
    public void getRelationshipBySmallNegativeInteger() throws Exception {
        this.getRelationshipById(-5L);
        this.getRelationshipByIdReadOnly(5L);
    }

    @Test(expected=NotFoundException.class)
    public void getRelationshipByBigPossitiveInteger() throws Exception {
        this.getRelationshipById(Integer.MAX_VALUE);
        this.getRelationshipByIdReadOnly(Integer.MAX_VALUE);
    }

    @Test(expected=NotFoundException.class)
    public void getRelationshipByBigNegativeInteger() throws Exception {
        this.getRelationshipById(Integer.MIN_VALUE);
        this.getRelationshipByIdReadOnly(Integer.MIN_VALUE);
    }

    @Test(expected=NotFoundException.class)
    public void getRelationshipBySmallPossitiveLong() throws Exception {
        this.getRelationshipById(0x80000000L);
        this.getRelationshipByIdReadOnly(0x80000000L);
    }

    @Test(expected=NotFoundException.class)
    public void getRelationshipBySmallNegativeLong() throws Exception {
        this.getRelationshipById(Integer.MAX_VALUE);
        this.getRelationshipByIdReadOnly(Integer.MAX_VALUE);
    }

    @Test(expected=NotFoundException.class)
    public void getRelationshipByBigPossitiveLong() throws Exception {
        this.getRelationshipById(Long.MAX_VALUE);
        this.getRelationshipByIdReadOnly(Long.MAX_VALUE);
    }

    @Test(expected=NotFoundException.class)
    public void getRelationshipByBigNegativeLong() throws Exception {
        this.getRelationshipById(Long.MIN_VALUE);
        this.getRelationshipByIdReadOnly(Long.MIN_VALUE);
    }

    private void getNodeById(long index) {
        Node value = graphdb.getNodeById(index);
        Assert.fail((String)String.format("Returned Node [0x%x] for index 0x%x (int value: 0x%x)", value.getId(), index, (int)index));
    }

    private void getNodeByIdReadOnly(long index) {
        Node value = graphDbReadOnly.getNodeById(index);
        Assert.fail((String)String.format("Returned Node [0x%x] for index 0x%x (int value: 0x%x)", value.getId(), index, (int)index));
    }

    private void getRelationshipById(long index) {
        Relationship value = graphdb.getRelationshipById(index);
        Assert.fail((String)String.format("Returned Relationship [0x%x] for index 0x%x (int value: 0x%x)", value.getId(), index, (int)index));
    }

    private void getRelationshipByIdReadOnly(long index) {
        Relationship value = graphDbReadOnly.getRelationshipById(index);
        Assert.fail((String)String.format("Returned Relationship [0x%x] for index 0x%x (int value: 0x%x)", value.getId(), index, (int)index));
    }
}

