/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.locking;

import java.util.concurrent.Future;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.junit.Ignore;
import org.junit.Test;
import org.neo4j.kernel.impl.locking.LockingCompatibilityTestSuite;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.impl.locking.ResourceTypes;

@Ignore(value="Not a test. This is a compatibility suite, run from LockingCompatibilityTestSuite.")
public class AcquireAndReleaseLocksCompatibility
extends LockingCompatibilityTestSuite.Compatibility {
    public AcquireAndReleaseLocksCompatibility(LockingCompatibilityTestSuite suite) {
        super(suite);
    }

    @Test
    public void exclusiveShouldWaitForExclusive() throws Exception {
        this.clientA.acquireExclusive((Locks.ResourceType)ResourceTypes.NODE, new long[]{1L});
        Future<Object> clientBLock = this.acquireExclusive(this.clientB, (Locks.ResourceType)ResourceTypes.NODE, 1L).callAndAssertWaiting();
        this.clientA.releaseExclusive((Locks.ResourceType)ResourceTypes.NODE, 1L);
        this.assertNotWaiting(this.clientB, clientBLock);
    }

    @Test
    public void exclusiveShouldWaitForShared() throws Exception {
        this.clientA.acquireShared((Locks.ResourceType)ResourceTypes.NODE, new long[]{1L});
        this.clientC.acquireShared((Locks.ResourceType)ResourceTypes.NODE, new long[]{1L});
        Future<Object> clientBLock = this.acquireExclusive(this.clientB, (Locks.ResourceType)ResourceTypes.NODE, 1L).callAndAssertWaiting();
        this.clientA.releaseShared((Locks.ResourceType)ResourceTypes.NODE, 1L);
        this.clientC.releaseShared((Locks.ResourceType)ResourceTypes.NODE, 1L);
        this.assertNotWaiting(this.clientB, clientBLock);
    }

    @Test
    public void sharedShouldWaitForExclusive() throws Exception {
        this.clientA.acquireExclusive((Locks.ResourceType)ResourceTypes.NODE, new long[]{1L});
        Future<Object> clientBLock = this.acquireShared(this.clientB, (Locks.ResourceType)ResourceTypes.NODE, 1L).callAndAssertWaiting();
        this.clientA.releaseExclusive((Locks.ResourceType)ResourceTypes.NODE, 1L);
        this.assertNotWaiting(this.clientB, clientBLock);
    }

    @Test
    public void shouldTrySharedLock() throws Exception {
        Assert.assertTrue((boolean)this.clientA.trySharedLock((Locks.ResourceType)ResourceTypes.NODE, 1L));
        TestCase.assertFalse((boolean)this.clientB.tryExclusiveLock((Locks.ResourceType)ResourceTypes.NODE, 1L));
        Assert.assertTrue((boolean)this.clientB.trySharedLock((Locks.ResourceType)ResourceTypes.NODE, 1L));
    }

    @Test
    public void shouldTryExclusiveLock() throws Exception {
        Assert.assertTrue((boolean)this.clientA.tryExclusiveLock((Locks.ResourceType)ResourceTypes.NODE, 1L));
        TestCase.assertFalse((boolean)this.clientB.tryExclusiveLock((Locks.ResourceType)ResourceTypes.NODE, 1L));
        TestCase.assertFalse((boolean)this.clientB.trySharedLock((Locks.ResourceType)ResourceTypes.NODE, 1L));
    }

    @Test
    public void shouldTryUpgradeSharedToExclusive() throws Exception {
        Assert.assertTrue((boolean)this.clientA.trySharedLock((Locks.ResourceType)ResourceTypes.NODE, 1L));
        Assert.assertTrue((boolean)this.clientA.tryExclusiveLock((Locks.ResourceType)ResourceTypes.NODE, 1L));
        TestCase.assertFalse((boolean)this.clientB.trySharedLock((Locks.ResourceType)ResourceTypes.NODE, 1L));
    }

    @Test
    public void shouldUpgradeExclusiveOnTry() throws Exception {
        this.clientA.acquireShared((Locks.ResourceType)ResourceTypes.NODE, new long[]{1L});
        Assert.assertTrue((boolean)this.clientA.tryExclusiveLock((Locks.ResourceType)ResourceTypes.NODE, 1L));
        this.clientA.releaseExclusive((Locks.ResourceType)ResourceTypes.NODE, 1L);
    }
}

