/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.locking;

import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.neo4j.kernel.impl.locking.LockClientStoppedException;
import org.neo4j.kernel.impl.locking.LockCountVisitor;
import org.neo4j.kernel.impl.locking.LockingCompatibilityTestSuite;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.impl.locking.ResourceTypes;

@Ignore(value="Not a test. This is a compatibility suite, run from LockingCompatibilityTestSuite.")
public class CloseCompatibility
extends LockingCompatibilityTestSuite.Compatibility {
    public CloseCompatibility(LockingCompatibilityTestSuite suite) {
        super(suite);
    }

    @Test
    public void shouldNotBeAbleToHandOutClientsIfShutDown() throws Throwable {
        try (Locks.Client client = this.locks.newClient();){
            client.acquireExclusive((Locks.ResourceType)ResourceTypes.NODE, new long[]{0L});
        }
        this.locks.stop();
        this.locks.shutdown();
        try {
            this.locks.newClient();
            Assert.fail((String)"Should fail");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void closeShouldWaitAllOperationToFinish() {
        this.clientA.acquireShared((Locks.ResourceType)ResourceTypes.NODE, new long[]{1L});
        this.clientA.acquireShared((Locks.ResourceType)ResourceTypes.NODE, new long[]{3L});
        this.clientB.acquireShared((Locks.ResourceType)ResourceTypes.NODE, new long[]{1L});
        this.acquireShared(this.clientC, (Locks.ResourceType)ResourceTypes.NODE, 2L);
        this.acquireExclusive(this.clientB, (Locks.ResourceType)ResourceTypes.NODE, 1L).callAndAssertWaiting();
        this.acquireExclusive(this.clientC, (Locks.ResourceType)ResourceTypes.NODE, 1L).callAndAssertWaiting();
        this.clientB.close();
        this.clientC.close();
        this.clientA.close();
        LockCountVisitor lockCountVisitor = new LockCountVisitor();
        this.locks.accept((Locks.Visitor)lockCountVisitor);
        Assert.assertEquals((long)0L, (long)lockCountVisitor.getLockCount());
    }

    @Test(expected=LockClientStoppedException.class)
    public void shouldNotBeAbleToAcquireSharedLockFromClosedClient() {
        this.clientA.close();
        this.clientA.acquireShared((Locks.ResourceType)ResourceTypes.NODE, new long[]{1L});
    }

    @Test(expected=LockClientStoppedException.class)
    public void shouldNotBeAbleToAcquireExclusiveLockFromClosedClient() {
        this.clientA.close();
        this.clientA.acquireExclusive((Locks.ResourceType)ResourceTypes.NODE, new long[]{1L});
    }

    @Test(expected=LockClientStoppedException.class)
    public void shouldNotBeAbleToTryAcquireSharedLockFromClosedClient() {
        this.clientA.close();
        this.clientA.trySharedLock((Locks.ResourceType)ResourceTypes.NODE, 1L);
    }

    @Test(expected=LockClientStoppedException.class)
    public void shouldNotBeAbleToTryAcquireExclusiveLockFromClosedClient() {
        this.clientA.close();
        this.clientA.tryExclusiveLock((Locks.ResourceType)ResourceTypes.NODE, 1L);
    }
}

