/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.locking;

import java.util.concurrent.Future;
import org.neo4j.kernel.DeadlockDetectedException;
import org.neo4j.kernel.impl.locking.AcquireLockTimeoutException;
import org.neo4j.kernel.impl.locking.LockWorkerState;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.impl.locking.ResourceTypes;
import org.neo4j.logging.Logger;
import org.neo4j.test.OtherThreadExecutor;

public class LockWorker
extends OtherThreadExecutor<LockWorkerState> {
    public LockWorker(String name, Locks locks) {
        super(name, new LockWorkerState(locks));
    }

    private Future<Void> perform(AcquireLockCommand acquireLockCommand, boolean wait) throws Exception {
        Future<Void> future = this.executeDontWait(acquireLockCommand);
        if (wait) {
            this.awaitFuture(future);
        } else {
            this.waitUntilWaiting();
        }
        return future;
    }

    public Future<Void> getReadLock(final long resource, final boolean wait) throws Exception {
        return this.perform(new AcquireLockCommand(){

            @Override
            protected void acquireLock(LockWorkerState state) throws AcquireLockTimeoutException {
                state.doing("+R " + resource + ", wait:" + wait);
                state.client.acquireShared((Locks.ResourceType)ResourceTypes.NODE, new long[]{resource});
                state.done();
            }
        }, wait);
    }

    public Future<Void> getWriteLock(final long resource, final boolean wait) throws Exception {
        return this.perform(new AcquireLockCommand(){

            @Override
            protected void acquireLock(LockWorkerState state) throws AcquireLockTimeoutException {
                state.doing("+W " + resource + ", wait:" + wait);
                state.client.acquireExclusive((Locks.ResourceType)ResourceTypes.NODE, new long[]{resource});
                state.done();
            }
        }, wait);
    }

    public void releaseReadLock(final long resource) throws Exception {
        this.perform(new AcquireLockCommand(){

            @Override
            protected void acquireLock(LockWorkerState state) {
                state.doing("-R " + resource);
                state.client.releaseShared((Locks.ResourceType)ResourceTypes.NODE, resource);
                state.done();
            }
        }, true);
    }

    public void releaseWriteLock(final long resource) throws Exception {
        this.perform(new AcquireLockCommand(){

            @Override
            protected void acquireLock(LockWorkerState state) {
                state.doing("-W " + resource);
                state.client.releaseExclusive((Locks.ResourceType)ResourceTypes.NODE, resource);
                state.done();
            }
        }, true);
    }

    public boolean isLastGetLockDeadLock() {
        return ((LockWorkerState)this.state).deadlockOnLastWait;
    }

    @Override
    public void dump(Logger logger) {
        super.dump(logger);
        logger.log("What have I done up until now?");
        for (String op : ((LockWorkerState)this.state).completedOperations) {
            logger.log(op);
        }
        logger.log("Doing right now:");
        logger.log(((LockWorkerState)this.state).doing);
    }

    public static ResourceObject newResourceObject(String name) {
        return new ResourceObject(name);
    }

    private static abstract class AcquireLockCommand
    implements OtherThreadExecutor.WorkerCommand<LockWorkerState, Void> {
        private AcquireLockCommand() {
        }

        @Override
        public Void doWork(LockWorkerState state) throws Exception {
            try {
                this.acquireLock(state);
                state.deadlockOnLastWait = false;
            }
            catch (DeadlockDetectedException e) {
                state.deadlockOnLastWait = true;
            }
            return null;
        }

        protected abstract void acquireLock(LockWorkerState var1) throws AcquireLockTimeoutException;
    }

    public static class ResourceObject {
        private final String name;

        ResourceObject(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

