/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.locking;

import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.impl.locking.SimpleStatementLocks;
import org.neo4j.kernel.impl.locking.SimpleStatementLocksFactory;
import org.neo4j.kernel.impl.locking.StatementLocks;

public class SimpleStatementLocksFactoryTest {
    @Test
    public void throwsForNullLocks() {
        try {
            new SimpleStatementLocksFactory(null);
            Assert.fail((String)"Exception expected");
        }
        catch (Exception e) {
            Assert.assertThat((Object)e, (Matcher)Matchers.instanceOf(NullPointerException.class));
        }
    }

    @Test
    public void createSimpleStatementLocks() {
        Locks locks = (Locks)Mockito.mock(Locks.class);
        Locks.Client client = (Locks.Client)Mockito.mock(Locks.Client.class);
        Mockito.when((Object)locks.newClient()).thenReturn((Object)client);
        SimpleStatementLocksFactory factory = new SimpleStatementLocksFactory(locks);
        StatementLocks statementLocks = factory.newInstance();
        Assert.assertThat((Object)statementLocks, (Matcher)Matchers.instanceOf(SimpleStatementLocks.class));
        Assert.assertSame((Object)client, (Object)statementLocks.optimistic());
        Assert.assertSame((Object)client, (Object)statementLocks.pessimistic());
    }

    @Test
    public void newInstanceThrowsWhenNotInitialized() {
        SimpleStatementLocksFactory factory = new SimpleStatementLocksFactory();
        try {
            factory.newInstance();
            Assert.fail((String)"Exception expected");
        }
        catch (Exception e) {
            Assert.assertThat((Object)e, (Matcher)Matchers.instanceOf(IllegalStateException.class));
        }
    }

    @Test
    public void initializeThrowsForNullLocks() {
        SimpleStatementLocksFactory factory = new SimpleStatementLocksFactory();
        try {
            factory.initialize(null, new Config());
            Assert.fail((String)"Exception expected");
        }
        catch (Exception e) {
            Assert.assertThat((Object)e, (Matcher)Matchers.instanceOf(NullPointerException.class));
        }
    }
}

