/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.locking;

import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.impl.locking.SimpleStatementLocks;

public class SimpleStatementLocksTest {
    @Test
    public void shouldUseSameClientForImplicitAndExplicit() throws Exception {
        Locks.Client client = (Locks.Client)Mockito.mock(Locks.Client.class);
        SimpleStatementLocks statementLocks = new SimpleStatementLocks(client);
        Assert.assertSame((Object)client, (Object)statementLocks.pessimistic());
        Assert.assertSame((Object)client, (Object)statementLocks.optimistic());
    }

    @Test
    public void shouldDoNothingWithClientWhenPreparingForCommit() throws Exception {
        Locks.Client client = (Locks.Client)Mockito.mock(Locks.Client.class);
        SimpleStatementLocks statementLocks = new SimpleStatementLocks(client);
        statementLocks.prepareForCommit();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{client});
    }

    @Test
    public void shouldStopUnderlyingClient() throws Exception {
        Locks.Client client = (Locks.Client)Mockito.mock(Locks.Client.class);
        SimpleStatementLocks statementLocks = new SimpleStatementLocks(client);
        statementLocks.stop();
        ((Locks.Client)Mockito.verify((Object)client)).stop();
    }

    @Test
    public void shouldCloseUnderlyingClient() throws Exception {
        Locks.Client client = (Locks.Client)Mockito.mock(Locks.Client.class);
        SimpleStatementLocks statementLocks = new SimpleStatementLocks(client);
        statementLocks.close();
        ((Locks.Client)Mockito.verify((Object)client)).close();
    }
}

