/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.pagecache;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.impl.SingleFilePageSwapperFactory;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.pagecache.ConfigurablePageSwapperFactory;
import org.neo4j.kernel.impl.pagecache.ConfiguringPageCacheFactory;
import org.neo4j.logging.Log;
import org.neo4j.logging.NullLog;
import org.neo4j.test.EphemeralFileSystemRule;

public class ConfiguringPageCacheFactoryTest {
    @Rule
    public EphemeralFileSystemRule fsRule = new EphemeralFileSystemRule();

    @Before
    public void setUp() {
        PageSwapperFactoryForTesting.createdCounter.set(0);
        PageSwapperFactoryForTesting.configuredCounter.set(0);
        PageSwapperFactoryForTesting.cachePageSizeHint.set(0);
        PageSwapperFactoryForTesting.cachePageSizeHintIsStrict.set(false);
    }

    @Test
    public void shouldUseConfiguredPageSizeAndFitAsManyPagesAsItCan() throws Throwable {
        int pageSize = 4096;
        int maxPages = 60;
        Config config = new Config();
        config.applyChanges(MapUtil.stringMap((String[])new String[]{GraphDatabaseSettings.mapped_memory_page_size.name(), "4096", GraphDatabaseSettings.pagecache_memory.name(), Integer.toString(245760)}));
        ConfiguringPageCacheFactory factory = new ConfiguringPageCacheFactory((FileSystemAbstraction)this.fsRule.get(), config, PageCacheTracer.NULL, (Log)NullLog.getInstance());
        try (PageCache cache = factory.getOrCreatePageCache();){
            MatcherAssert.assertThat((Object)cache.pageSize(), (Matcher)CoreMatchers.equalTo((Object)4096));
            MatcherAssert.assertThat((Object)cache.maxCachedPages(), (Matcher)CoreMatchers.equalTo((Object)60));
        }
    }

    @Test
    public void mustUseConfiguredPageSwapper() throws Exception {
        Config config = new Config();
        config.applyChanges(MapUtil.stringMap((String[])new String[]{GraphDatabaseSettings.pagecache_memory.name(), "8m", GraphDatabaseSettings.pagecache_swapper.name(), "test"}));
        new ConfiguringPageCacheFactory((FileSystemAbstraction)this.fsRule.get(), config, PageCacheTracer.NULL, (Log)NullLog.getInstance());
        MatcherAssert.assertThat((Object)PageSwapperFactoryForTesting.countCreatedPageSwapperFactories(), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)PageSwapperFactoryForTesting.countConfiguredPageSwapperFactories(), (Matcher)Matchers.is((Object)1));
    }

    @Test
    public void mustUsePageSwapperCachePageSizeHintAsDefault() throws Exception {
        int cachePageSizeHint = 16384;
        PageSwapperFactoryForTesting.cachePageSizeHint.set(cachePageSizeHint);
        Config config = new Config();
        config.applyChanges(MapUtil.stringMap((String[])new String[]{GraphDatabaseSettings.pagecache_swapper.name(), "test"}));
        ConfiguringPageCacheFactory factory = new ConfiguringPageCacheFactory((FileSystemAbstraction)this.fsRule.get(), config, PageCacheTracer.NULL, (Log)NullLog.getInstance());
        try (PageCache cache = factory.getOrCreatePageCache();){
            MatcherAssert.assertThat((Object)cache.pageSize(), (Matcher)Matchers.is((Object)cachePageSizeHint));
        }
    }

    @Test
    public void mustIgnoreExplicitlySpecifiedCachePageSizeIfPageSwapperHintIsStrict() throws Exception {
        int cachePageSizeHint = 16384;
        PageSwapperFactoryForTesting.cachePageSizeHint.set(cachePageSizeHint);
        PageSwapperFactoryForTesting.cachePageSizeHintIsStrict.set(true);
        Config config = new Config();
        config.applyChanges(MapUtil.stringMap((String[])new String[]{GraphDatabaseSettings.mapped_memory_page_size.name(), "4096", GraphDatabaseSettings.pagecache_swapper.name(), "test"}));
        ConfiguringPageCacheFactory factory = new ConfiguringPageCacheFactory((FileSystemAbstraction)this.fsRule.get(), config, PageCacheTracer.NULL, (Log)NullLog.getInstance());
        try (PageCache cache = factory.getOrCreatePageCache();){
            MatcherAssert.assertThat((Object)cache.pageSize(), (Matcher)Matchers.is((Object)cachePageSizeHint));
        }
    }

    public static class PageSwapperFactoryForTesting
    extends SingleFilePageSwapperFactory
    implements ConfigurablePageSwapperFactory {
        private static final AtomicInteger createdCounter = new AtomicInteger();
        private static final AtomicInteger configuredCounter = new AtomicInteger();
        private static final AtomicInteger cachePageSizeHint = new AtomicInteger(8192);
        private static final AtomicBoolean cachePageSizeHintIsStrict = new AtomicBoolean();

        public static int countCreatedPageSwapperFactories() {
            return createdCounter.get();
        }

        public static int countConfiguredPageSwapperFactories() {
            return configuredCounter.get();
        }

        public PageSwapperFactoryForTesting() {
            createdCounter.getAndIncrement();
        }

        public String implementationName() {
            return "test";
        }

        public int getCachePageSizeHint() {
            return cachePageSizeHint.get();
        }

        public boolean isCachePageSizeHintStrict() {
            return cachePageSizeHintIsStrict.get();
        }

        public void configure(Config config) {
            configuredCounter.getAndIncrement();
        }
    }
}

